/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.text;

import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import org.makagiga.commons.FS;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MText;
import org.makagiga.commons.TK;
import org.makagiga.editors.text.TextEditor;
import org.makagiga.editors.text.TextEditorDocument;
import org.makagiga.editors.text.TextEditorKit;
import org.makagiga.richtext.RichTextPane;

public final class TextEditorCore
extends RichTextPane<TextEditorDocument, TextEditorKit> {
    private static final String PSEUDO_TAB = "&nbsp;&nbsp;&nbsp;&nbsp;";
    WeakReference<TextEditor> editorRef;

    public TextEditorCore() {
        this.getInputMap().put(KeyStroke.getKeyStroke("pressed ENTER"), "insert-break");
        this.getActionMap().put("insert-break", new MDataAction.Weak<TextEditorCore>(this, "TextEditorKit.insertBreakAction"){

            @Override
            public void onAction() {
                ((TextEditorCore)this.get()).insertBreak();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("pressed TAB"), "insert-tab");
        this.getActionMap().put("insert-tab", new MDataAction.Weak<TextEditorCore>(this, "TextEditorKit.insertTabAction"){

            @Override
            public void onAction() {
                ((TextEditorCore)this.get()).insertTab();
            }
        });
        int n = this.getCaret().getBlinkRate();
        DefaultCaret defaultCaret = new DefaultCaret(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MMouseAdapter.isMiddle(mouseEvent)) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
                    if (TextEditorCore.this.paste(clipboard == null ? MClipboard.getDefault() : clipboard)) {
                        mouseEvent.consume();
                    } else {
                        super.mouseClicked(mouseEvent);
                    }
                } else {
                    super.mouseClicked(mouseEvent);
                }
            }
        };
        defaultCaret.setBlinkRate(n);
        this.setCaret(defaultCaret);
    }

    @Deprecated
    public TextEditorDocument getDoc() {
        return (TextEditorDocument)this.getDocument();
    }

    @Deprecated
    public TextEditorKit getKit() {
        return (TextEditorKit)this.getEditorKit();
    }

    public void insertHTML(String string) {
        this.insertHTML(string, this.getCaretPosition(), null);
    }

    public void insertHTML(String string, int n) {
        this.insertHTML(string, n, null);
    }

    public void insertHTML(String string, int n, HTML.Tag tag) {
        try {
            this.getKit().insertHTML(this.getDoc(), n, string, 0, 0, tag);
        }
        catch (BadLocationException badLocationException) {
            MLogger.exception(badLocationException);
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
    }

    @Override
    public void moveCaretPosition(int n) {
        super.moveCaretPosition(this.fixZeroPos(n));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    @Override
    public void paste() {
        if (!this.paste(MClipboard.getDefault())) {
            super.paste();
        }
    }

    public boolean paste(Clipboard clipboard) {
        String string;
        if (!this.isEditable()) {
            return true;
        }
        if (!this.isEnabled()) {
            return true;
        }
        DataFlavor dataFlavor = null;
        try {
            DataFlavor[] dataFlavorArray = clipboard.getAvailableDataFlavors();
            dataFlavor = MDataTransfer.findBestHTMLFlavor(dataFlavorArray, false);
            string = dataFlavor != null ? MDataTransfer.getHTML(clipboard, dataFlavor) : (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) ? MDataTransfer.getString(clipboard) : "");
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return false;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            MLogger.exception(unsupportedFlavorException);
            return false;
        }
        if (string.isEmpty()) {
            return false;
        }
        this.replaceSelection("");
        try {
            if (dataFlavor != null) {
                string = string.replaceFirst(Pattern.quote("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"DTD/xhtml1-strict.dtd\">"), "");
                string = string.replaceFirst(Pattern.quote("<html xmlns=\"http://www.w3.org/1999/xhtml\">"), "");
                string = string.replaceAll("<html>|</html>|<body>|</body>", "");
            } else {
                boolean bl = string.contains("\n");
                if (string.contains("<") || string.contains(">") || string.contains("&")) {
                    string = TK.escapeXML(string);
                    string = this.filterWhitespace(string);
                }
                if (bl) {
                    string = string.replace("\n", "<br>\n");
                }
            }
            if (TK.startsWith(string.trim(), '/')) {
                string = string.replaceFirst("/", "&#" + Integer.toString(47) + ";");
            }
            this.insertHTML(string);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
        return true;
    }

    public void saveToFileAsHTML(OutputStream outputStream, String string) throws Exception {
        this.getDoc().putProperty("title", TK.escapeXML(string));
        MText.save((JTextComponent)this, outputStream);
    }

    public void saveToFileAsText(OutputStream outputStream) throws Exception {
        String string = this.getPlainText();
        FS.write(outputStream, TK.isEmpty(string) ? "\n" : string);
    }

    @Override
    public void setCaretPosition(int n) {
        super.setCaretPosition(this.fixZeroPos(n));
    }

    @Override
    public void setModified(boolean bl, Object object) {
        super.setModified(bl, object);
        TextEditor textEditor = (TextEditor)this.editorRef.get();
        textEditor.setModified(bl);
        if (bl) {
            textEditor.syncLater();
        }
    }

    private String filterWhitespace(String string) {
        String string2 = "\u00a0\u00a0";
        String string3 = string;
        string3 = string3.replace("  ", string2);
        string3 = string3.replace("\t", PSEUDO_TAB);
        return string3;
    }

    private int fixZeroPos(int n) {
        if (n != 0) {
            return n;
        }
        Element element = this.getDoc().findElement("body");
        if (element == null || element.getElementCount() == 0) {
            return n;
        }
        return element.getElement(0).getStartOffset();
    }

    private void insertBreak() {
        TextEditorDocument textEditorDocument = this.getDoc();
        TextEditorKit textEditorKit = this.getKit();
        this.replaceSelection("");
        AttributeSet attributeSet = this.getInputAttributes().copyAttributes();
        try {
            Element element = ((TextEditorDocument)this.getDocument()).findElement("body");
            if (element != null && this.getCaretPosition() == element.getStartOffset()) {
                textEditorDocument.insertAfterStart(element, "<br>");
            } else {
                textEditorKit.insertHTML(textEditorDocument, this.getCaretPosition(), "<br>", 0, 0, HTML.Tag.BR);
                MAction.fire("caret-begin-line", this);
            }
            this.getInputAttributes().addAttributes(attributeSet);
        }
        catch (BadLocationException badLocationException) {
            MLogger.exception(badLocationException);
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
    }

    private void insertTab() {
        this.replaceSelection("");
        AttributeSet attributeSet = this.getInputAttributes().copyAttributes();
        this.insertHTML("<span>&nbsp;&nbsp;&nbsp;&nbsp;</span>", this.getCaretPosition(), HTML.Tag.SPAN);
        this.getInputAttributes().addAttributes(attributeSet);
    }
}

