/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.form;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.BeanInfo;
import java.beans.EventHandler;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.makagiga.commons.AbstractProperty;
import org.makagiga.commons.AbstractSpinner;
import org.makagiga.commons.BeanProperty;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.DateProperty;
import org.makagiga.commons.DoubleProperty;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.FloatProperty;
import org.makagiga.commons.FontProperty;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MDateSpinner;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MFontButton;
import org.makagiga.commons.MFormattedTextField;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MNumberSpinner;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MPasswordField;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MSlider;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MSmallColorChooser;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.NumberProperty;
import org.makagiga.commons.Pair;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.SecureProperty;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueEvent;
import org.makagiga.commons.ValueListener;

public class PropertyPanel
extends MPanel {
    public static final String RESTORE_DEFAULT_VALUES_PROPERTY = "org.makagiga.form.PropertyPanel.RESTORE_DEFAULT_VALUES_PROPERTY";
    private boolean autoUpdateModel = true;
    private boolean highlightFocusedEditor = false;
    private final Map<Enum<?>, String> enumText = TK.newHashMap();
    private static final String PROPERTY_ACCESS_PROPERTY = "org.makagiga.form.PropertyPanel.propertyAccess";

    public PropertyPanel() {
        this(0);
    }

    public PropertyPanel(int n) {
        super(1);
        this.setMargin(n);
    }

    public MAction createDefaultsAction() {
        return new MDataAction.Weak<PropertyPanel>(this, MActionInfo.RESTORE_DEFAULT_VALUES){

            @Override
            public void onAction() {
                if (MMessage.simpleConfirm(this.getSourceWindow())) {
                    ((PropertyPanel)this.get()).restoreDefaultValues();
                }
            }
        };
    }

    public JComponent bind(PropertyAccess<?> propertyAccess, String string) {
        return this.bind(propertyAccess, string, null);
    }

    public JComponent bind(PropertyAccess<?> propertyAccess, String string, Class<? extends JComponent> clazz) {
        TK.checkNull(propertyAccess, "propertyAccess");
        PropertyAccess<Object> propertyAccess2 = propertyAccess instanceof SecureProperty ? ((SecureProperty)SecureProperty.class.cast(propertyAccess)).getProperty() : propertyAccess;
        if (clazz == null) {
            clazz = this.getPreferredEditorClass(propertyAccess2);
        }
        JComponent jComponent = null;
        if (Property.isBoolean(propertyAccess2)) {
            jComponent = this.createBooleanPropertyEditor(propertyAccess2, string);
        } else if (Property.isColor(propertyAccess2)) {
            jComponent = this.createColorPropertyEditor(propertyAccess2, string);
        } else if (Property.isDate(propertyAccess2)) {
            jComponent = this.createDatePropertyEditor(propertyAccess2, string);
        } else if (Property.isDouble(propertyAccess2)) {
            jComponent = this.createDoubleEditor((DoubleProperty)propertyAccess2, string);
        } else if (Property.isEnum(propertyAccess2)) {
            jComponent = this.createEnumPropertyEditor(propertyAccess2, string);
        } else if (Property.isFloat(propertyAccess2)) {
            jComponent = this.createFloatPropertyEditor(propertyAccess2, string);
        } else if (Property.isFont(propertyAccess2)) {
            jComponent = this.createFontPropertyEditor(propertyAccess2, string);
        } else if (Property.isInteger(propertyAccess2)) {
            if (clazz == MSlider.class) {
                jComponent = this.createNumberPropertyEditor(propertyAccess2, string);
            } else {
                int n = Integer.toString(Integer.MAX_VALUE).length() + 1;
                jComponent = this.createNumberPropertyEditor(propertyAccess2, string, n);
            }
        } else if (propertyAccess2 instanceof NumberProperty) {
            jComponent = this.createNumberEditor((NumberProperty)propertyAccess2, string, Long.toString(Long.MAX_VALUE).length() + 1);
        } else if (Property.isString(propertyAccess2)) {
            jComponent = clazz == MPasswordField.class ? this.createPasswordEditor((StringProperty)propertyAccess2, string) : this.createStringPropertyEditor(propertyAccess2, string);
        }
        if (jComponent == null) {
            jComponent = this.createCustomEditor(propertyAccess2, string, clazz);
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("Unsupported property type: " + propertyAccess2.getClass().getName() + " (" + propertyAccess2 + "; " + string + "; " + propertyAccess2.getType() + ")");
        }
        if (propertyAccess2 instanceof AbstractProperty && ((AbstractProperty)AbstractProperty.class.cast(propertyAccess2)).isReadOnly()) {
            Object t = PropertyPanel.getWrappedView(jComponent);
            if (t instanceof JTextComponent) {
                ((JTextComponent)JTextComponent.class.cast(t)).setEditable(false);
            } else if (t != null) {
                ((JComponent)t).setEnabled(false);
            }
        }
        jComponent.putClientProperty(PROPERTY_ACCESS_PROPERTY, propertyAccess);
        if (this.getComponentCount() > 0 && (!(jComponent instanceof MPanel) && this.getComponent(this.getComponentCount() - 1) instanceof MPanel || jComponent instanceof MPanel && !(this.getComponent(this.getComponentCount() - 1) instanceof MPanel) || jComponent instanceof MPanel && this.getComponent(this.getComponentCount() - 1) instanceof MPanel)) {
            this.addGap();
        }
        this.add(jComponent);
        return jComponent;
    }

    public void bind(PropertyAccess<?> propertyAccess, String string, PropertyAccess<?> propertyAccess2, String string2) {
        JComponent jComponent = this.getEditorView(propertyAccess);
        JComponent jComponent2 = this.getEditorView(propertyAccess2);
        if (jComponent == null || jComponent2 == null) {
            throw new IllegalArgumentException("Source or destination component not found");
        }
        if (jComponent == jComponent2) {
            throw new IllegalArgumentException("Invalid source or destination property");
        }
        if (!(jComponent instanceof AbstractButton)) {
            throw new IllegalArgumentException("Unsupported source property component");
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ActionListener actionListener = EventHandler.create(ActionListener.class, jComponent2, string2, "source." + string);
        actionListener.actionPerformed(new ActionEvent(jComponent, 1001, null));
        abstractButton.addActionListener(actionListener);
    }

    public BeanInfo bindBean(Object object, String ... stringArray) throws IntrospectionException {
        Set<String> set = TK.isEmpty(stringArray) ? null : TK.newHashSet(stringArray);
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        LinkedHashMap<String, PropertyDescriptor> linkedHashMap = new LinkedHashMap<String, PropertyDescriptor>(propertyDescriptorArray.length);
        for (PropertyDescriptor object2 : propertyDescriptorArray) {
            linkedHashMap.put(object2.getName(), object2);
        }
        for (PropertyDescriptor propertyDescriptor : TK.order(linkedHashMap, stringArray)) {
            if (propertyDescriptor.isHidden()) {
                if (set == null) continue;
                set.remove(propertyDescriptor.getName());
                continue;
            }
            if (set != null && !set.contains(propertyDescriptor.getName())) continue;
            String string = propertyDescriptor.getDisplayName();
            if (propertyDescriptor.getName().equals(string)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                for (char c : string.toCharArray()) {
                    boolean bl2;
                    if (stringBuilder.length() == 0) {
                        stringBuilder.append(Character.toUpperCase(c));
                        continue;
                    }
                    if (Character.isUpperCase(c)) {
                        if (bl2) {
                            stringBuilder.append(' ');
                            bl2 = false;
                        }
                    } else {
                        bl2 = true;
                    }
                    stringBuilder.append(c);
                }
                string = stringBuilder.toString();
            }
            if (set != null) {
                set.remove(propertyDescriptor.getName());
            }
            BeanProperty beanProperty = new BeanProperty(object, propertyDescriptor);
            this.bind(beanProperty, string);
        }
        if (set != null && !set.isEmpty()) {
            throw new IntrospectionException("Invalid properties: " + TK.toString(set, ", "));
        }
        return beanInfo;
    }

    public JComponent bindDouble(DoubleProperty doubleProperty, String string, final double d, final double d2) {
        MFormattedTextField mFormattedTextField = (MFormattedTextField)this.getViewComponent(this.bind(doubleProperty, string));
        mFormattedTextField.setColumns(Double.toString(d2).length() + 1);
        mFormattedTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                if (jComponent instanceof MFormattedTextField) {
                    MFormattedTextField mFormattedTextField = (MFormattedTextField)jComponent;
                    double d3 = (Double)mFormattedTextField.getValue();
                    return d3 >= d && d3 <= d2;
                }
                return true;
            }
        });
        return mFormattedTextField;
    }

    public JComponent bindFloat(FloatProperty floatProperty, String string, final float f, final float f2) {
        MFormattedTextField mFormattedTextField = (MFormattedTextField)this.getViewComponent(this.bind(floatProperty, string));
        mFormattedTextField.setColumns(Float.toString(f2).length() + 1);
        mFormattedTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                if (jComponent instanceof MFormattedTextField) {
                    MFormattedTextField mFormattedTextField = (MFormattedTextField)jComponent;
                    float f3 = ((Float)mFormattedTextField.getValue()).floatValue();
                    return f3 >= f && f3 <= f2;
                }
                return true;
            }
        });
        return mFormattedTextField;
    }

    public JComponent bindInteger(IntegerProperty integerProperty, String string, int n, int n2) {
        MNumberSpinner mNumberSpinner = (MNumberSpinner)this.getViewComponent(this.bind(integerProperty, string));
        mNumberSpinner.setRange(Integer.valueOf(n), Integer.valueOf(n2));
        mNumberSpinner.getTextField().setColumns(Integer.toString(n2).length() + 1);
        return mNumberSpinner;
    }

    public MTextField bindTextField(PropertyAccess<String> propertyAccess, String string) {
        return (MTextField)this.getViewComponent(this.bind(propertyAccess, string));
    }

    public boolean getAutoUpdateModel() {
        return this.autoUpdateModel;
    }

    public void setAutoUpdateModel(boolean bl) {
        this.autoUpdateModel = bl;
    }

    public String getEnumText(Enum<?> enum_) {
        return this.enumText.get(enum_);
    }

    public void setEnumText(Enum<?> enum_, String string) {
        this.enumText.put(enum_, string);
    }

    public boolean getHighlightFocusedEditor() {
        return this.highlightFocusedEditor;
    }

    public void setHighlightFocusedEditor(boolean bl) {
        this.highlightFocusedEditor = bl;
    }

    public void restoreDefaultValues() {
        boolean bl = false;
        for (Pair<PropertyAccess<?>, JComponent> pair : this.getEditors()) {
            if (Boolean.FALSE.equals(((JComponent)pair.getValue()).getClientProperty(RESTORE_DEFAULT_VALUES_PROPERTY))) continue;
            bl = true;
            ((PropertyAccess)pair.getKey()).reset();
        }
        if (bl) {
            this.updateView();
        }
    }

    public void setAllEnabled(boolean bl) {
        for (Pair<PropertyAccess<?>, JComponent> pair : this.getEditors()) {
            pair.getSecond().setEnabled(bl);
        }
    }

    public void updateModel() {
        for (Pair<PropertyAccess<?>, JComponent> pair : this.getEditors()) {
            JComponent jComponent;
            PropertyAccess propertyAccess = (PropertyAccess)pair.getKey();
            if (this.updateCustomModel(propertyAccess, jComponent = (JComponent)pair.getValue())) continue;
            PropertyAccess propertyAccess2 = propertyAccess;
            if (Property.isBoolean(propertyAccess)) {
                propertyAccess2.set(((MCheckBox)MCheckBox.class.cast(jComponent)).isSelected());
                continue;
            }
            if (Property.isColor(propertyAccess)) {
                propertyAccess2.set(((MSmallColorChooser)MSmallColorChooser.class.cast(jComponent)).getColor());
                continue;
            }
            if (Property.isDate(propertyAccess)) {
                propertyAccess2.set((MDate)((MDateSpinner)MDateSpinner.class.cast(jComponent)).getSelectedDate());
                continue;
            }
            if (Property.isDouble(propertyAccess)) {
                propertyAccess2.set((Double)((MFormattedTextField)MFormattedTextField.class.cast(jComponent)).getValue());
                continue;
            }
            if (Property.isEnum(propertyAccess)) {
                MComboBox mComboBox = (MComboBox)jComponent;
                propertyAccess2.set(mComboBox.getSelectedItem());
                continue;
            }
            if (Property.isFloat(propertyAccess)) {
                propertyAccess2.set((Float)((MFormattedTextField)MFormattedTextField.class.cast(jComponent)).getValue());
                continue;
            }
            if (Property.isFont(propertyAccess)) {
                propertyAccess2.set(((MFontButton)MFontButton.class.cast(jComponent)).getSelectedFont());
                continue;
            }
            if (Property.isInteger(propertyAccess)) {
                if (jComponent instanceof MSlider) {
                    propertyAccess2.set(((MSlider)MSlider.class.cast(jComponent)).getValue());
                    continue;
                }
                propertyAccess2.set((Integer)((MNumberSpinner)MNumberSpinner.class.cast(jComponent)).getNumber());
                continue;
            }
            if (propertyAccess instanceof NumberProperty) {
                if (jComponent instanceof MSlider) {
                    propertyAccess2.set(((MSlider)MSlider.class.cast(jComponent)).getValue());
                    continue;
                }
                propertyAccess2.set(((MNumberSpinner)MNumberSpinner.class.cast(jComponent)).getNumber());
                continue;
            }
            if (!Property.isString(propertyAccess)) continue;
            propertyAccess2.set(((MTextField)MTextField.class.cast(jComponent)).getText());
        }
    }

    public void updateView() {
        for (Pair<PropertyAccess<?>, JComponent> pair : this.getEditors()) {
            JComponent jComponent;
            PropertyAccess propertyAccess = (PropertyAccess)pair.getKey();
            if (this.updateCustomView(propertyAccess, jComponent = (JComponent)pair.getValue())) continue;
            if (Property.isBoolean(propertyAccess)) {
                ((MCheckBox)MCheckBox.class.cast(jComponent)).setSelected((Boolean)propertyAccess.get());
                continue;
            }
            if (Property.isColor(propertyAccess)) {
                ((MSmallColorChooser)MSmallColorChooser.class.cast(jComponent)).setColor((Color)propertyAccess.get());
                continue;
            }
            if (Property.isDate(propertyAccess)) {
                ((MDateSpinner)MDateSpinner.class.cast(jComponent)).setSelectedDate((MDate)propertyAccess.get());
                continue;
            }
            if (Property.isDouble(propertyAccess)) {
                ((MFormattedTextField)MFormattedTextField.class.cast(jComponent)).setValue(propertyAccess.get());
                continue;
            }
            if (Property.isEnum(propertyAccess)) {
                ((MComboBox)MComboBox.class.cast(jComponent)).setSelectedItem(propertyAccess.get());
                continue;
            }
            if (Property.isFloat(propertyAccess)) {
                ((MFormattedTextField)MFormattedTextField.class.cast(jComponent)).setValue(propertyAccess.get());
                continue;
            }
            if (Property.isFont(propertyAccess)) {
                ((MFontButton)MFontButton.class.cast(jComponent)).setSelectedFont((Font)propertyAccess.get());
                continue;
            }
            if (Property.isInteger(propertyAccess)) {
                if (jComponent instanceof MSlider) {
                    ((MSlider)MSlider.class.cast(jComponent)).setValue((Integer)propertyAccess.get());
                    continue;
                }
                ((MNumberSpinner)MNumberSpinner.class.cast(jComponent)).setValue((Integer)propertyAccess.get());
                continue;
            }
            if (propertyAccess instanceof NumberProperty) {
                NumberProperty numberProperty = (NumberProperty)propertyAccess;
                if (jComponent instanceof MSlider) {
                    ((MSlider)MSlider.class.cast(jComponent)).setValue(((Number)numberProperty.get()).intValue());
                    continue;
                }
                ((MNumberSpinner)MNumberSpinner.class.cast(jComponent)).setNumber((Number)numberProperty.get());
                continue;
            }
            if (!Property.isString(propertyAccess)) continue;
            ((MTextField)MTextField.class.cast(jComponent)).setText((String)propertyAccess.get());
        }
    }

    protected JComponent createBooleanEditor(BooleanProperty booleanProperty, String string) {
        return this.createBooleanPropertyEditor(booleanProperty, string);
    }

    protected JComponent createBooleanPropertyEditor(PropertyAccess<Boolean> propertyAccess, String string) {
        MCheckBox mCheckBox = new MCheckBox(string);
        mCheckBox.setSelected(propertyAccess.get());
        mCheckBox.addActionListener(new StaticPropertyHandler(this, propertyAccess));
        return mCheckBox;
    }

    protected JComponent createColorEditor(ColorProperty colorProperty, String string) {
        return this.createColorPropertyEditor(colorProperty, string);
    }

    protected JComponent createColorPropertyEditor(PropertyAccess<Color> propertyAccess, String string) {
        MSmallColorChooser mSmallColorChooser = new MSmallColorChooser(null, this.createColorPalette());
        mSmallColorChooser.setColor(propertyAccess.get());
        mSmallColorChooser.setDefaultColor(propertyAccess.getDefaultValue());
        mSmallColorChooser.setTitle(string);
        mSmallColorChooser.addChangeListener(new StaticPropertyHandler(this, propertyAccess));
        return mSmallColorChooser;
    }

    protected Color[] createColorPalette() {
        return MSmallColorChooser.createDefaultPalette();
    }

    protected JComponent createCustomEditor(PropertyAccess<?> propertyAccess, String string, Class<? extends JComponent> clazz) {
        return null;
    }

    protected JComponent createDateEditor(DateProperty dateProperty, String string) {
        return this.createDatePropertyEditor(dateProperty, string);
    }

    protected JComponent createDatePropertyEditor(final PropertyAccess<MDate> propertyAccess, String string) {
        MDateSpinner mDateSpinner = new MDateSpinner();
        mDateSpinner.setSelectedDate(propertyAccess.get());
        mDateSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PropertyPanel.this.autoUpdateModel) {
                    MDateSpinner mDateSpinner = (MDateSpinner)changeEvent.getSource();
                    propertyAccess.set((MDate)mDateSpinner.getSelectedDate());
                    PropertyPanel.this.onUserPropertyChange(propertyAccess);
                }
            }
        });
        HorizontalWrapper<MDateSpinner> horizontalWrapper = new HorizontalWrapper<MDateSpinner>(mDateSpinner, string, true);
        horizontalWrapper.addEast(new DatePropertyEditorButton(mDateSpinner));
        return horizontalWrapper;
    }

    protected JComponent createDoubleEditor(DoubleProperty doubleProperty, String string) {
        MFormattedTextField mFormattedTextField = new MFormattedTextField(doubleProperty.get());
        this.setFormatToolTipText(mFormattedTextField, 0.5);
        mFormattedTextField.getDocument().addDocumentListener(new StaticPropertyHandler(this, mFormattedTextField, doubleProperty));
        return new HorizontalWrapper<MFormattedTextField>(mFormattedTextField, string, true);
    }

    protected JComponent createEnumEditor(EnumProperty<?> enumProperty, String string) {
        return this.createEnumPropertyEditor(enumProperty, string);
    }

    protected JComponent createEnumPropertyEditor(final PropertyAccess<? extends Enum<?>> propertyAccess, String string) {
        MComboBox mComboBox = new MComboBox();
        mComboBox.setRenderer(new EnumRenderer(this));
        Enum<?>[] enumArray = propertyAccess.getType().getEnumConstants();
        if (enumArray != null) {
            mComboBox.addAllItems(enumArray);
            mComboBox.setSelectedItem(propertyAccess.get());
        }
        mComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PropertyPanel.this.autoUpdateModel) {
                    MComboBox mComboBox = (MComboBox)actionEvent.getSource();
                    EnumProperty.set(propertyAccess, ((Enum)mComboBox.getSelectedItem()).name());
                    PropertyPanel.this.onUserPropertyChange(propertyAccess);
                }
            }
        });
        return new HorizontalWrapper(mComboBox, string, true);
    }

    protected JComponent createFloatEditor(FloatProperty floatProperty, String string) {
        return this.createFloatPropertyEditor(floatProperty, string);
    }

    protected JComponent createFloatPropertyEditor(PropertyAccess<Float> propertyAccess, String string) {
        MFormattedTextField mFormattedTextField = new MFormattedTextField(propertyAccess.get());
        this.setFormatToolTipText(mFormattedTextField, Float.valueOf(0.5f));
        mFormattedTextField.getDocument().addDocumentListener(new StaticPropertyHandler(this, mFormattedTextField, propertyAccess));
        return new HorizontalWrapper<MFormattedTextField>(mFormattedTextField, string, true);
    }

    protected JComponent createFontEditor(FontProperty fontProperty, String string) {
        return this.createFontPropertyEditor(fontProperty, string);
    }

    protected JComponent createFontPropertyEditor(final PropertyAccess<Font> propertyAccess, String string) {
        MFontButton mFontButton = new MFontButton(string, null);
        mFontButton.setSelectedFont(propertyAccess.get());
        mFontButton.addValueListener(new ValueListener<Font>(){

            @Override
            public void valueChanged(ValueEvent<Font> valueEvent) {
                if (PropertyPanel.this.autoUpdateModel) {
                    propertyAccess.set(valueEvent.getNewValue());
                    PropertyPanel.this.onUserPropertyChange(propertyAccess);
                }
            }
        });
        return mFontButton;
    }

    protected JComponent createIntegerEditor(IntegerProperty integerProperty, String string) {
        return this.createNumberEditor(integerProperty, string, Integer.toString(Integer.MAX_VALUE).length());
    }

    protected <T extends Number> JComponent createNumberEditor(NumberProperty<T> numberProperty, String string, int n) {
        return this.createNumberPropertyEditor(numberProperty, string, n);
    }

    protected <T extends Number> JComponent createNumberPropertyEditor(PropertyAccess<T> propertyAccess, String string) {
        MSlider mSlider = new MSlider();
        if (!propertyAccess.isNull()) {
            mSlider.setValue(((Number)propertyAccess.get()).intValue());
        }
        mSlider.addChangeListener(new StaticPropertyHandler(this, propertyAccess));
        HorizontalWrapper<MSlider> horizontalWrapper = new HorizontalWrapper<MSlider>(mSlider, null, false);
        horizontalWrapper.setTitle(string);
        MLabel mLabel = MLabel.createSmall(null, null);
        mLabel.setName("value");
        if (!propertyAccess.isNull()) {
            mLabel.setNumber((Number)propertyAccess.get());
        }
        mLabel.setToolTipText(UI._("Value"));
        horizontalWrapper.addEast(mLabel);
        horizontalWrapper.limitHeight();
        return horizontalWrapper;
    }

    protected <T extends Number> JComponent createNumberPropertyEditor(PropertyAccess<T> propertyAccess, String string, int n) {
        MNumberSpinner<Number> mNumberSpinner = new MNumberSpinner<Number>();
        mNumberSpinner.getTextField().setColumns(n);
        mNumberSpinner.setNumber((Number)propertyAccess.get());
        mNumberSpinner.addChangeListener(new StaticPropertyHandler(this, propertyAccess));
        return new HorizontalWrapper(mNumberSpinner, string, true);
    }

    protected JComponent createPasswordEditor(StringProperty stringProperty, String string) {
        MPasswordField mPasswordField = new MPasswordField();
        mPasswordField.setText((String)stringProperty.get());
        mPasswordField.getDocument().addDocumentListener(new StaticPropertyHandler(this, mPasswordField, stringProperty));
        return new HorizontalWrapper<MPasswordField>(mPasswordField, string, true);
    }

    protected JComponent createStringEditor(StringProperty stringProperty, String string) {
        return this.createStringPropertyEditor(stringProperty, string);
    }

    protected JComponent createStringPropertyEditor(PropertyAccess<String> propertyAccess, String string) {
        MTextField mTextField = new MTextField(propertyAccess.get());
        mTextField.getDocument().addDocumentListener(new StaticPropertyHandler(this, mTextField, propertyAccess));
        return new HorizontalWrapper<MTextField>(mTextField, string, true);
    }

    protected JComponent getEditorView(PropertyAccess<?> propertyAccess) {
        List<Pair<PropertyAccess<?>, JComponent>> list = this.getEditors();
        for (Pair<PropertyAccess<?>, JComponent> pair : list) {
            if (pair.getFirst() != propertyAccess) continue;
            return pair.getSecond();
        }
        return null;
    }

    protected List<Pair<PropertyAccess<?>, JComponent>> getEditors() {
        Component[] componentArray = this.getComponents();
        MArrayList<Pair<PropertyAccess<?>, JComponent>> mArrayList = MArrayList.create(componentArray.length);
        for (Component component : componentArray) {
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            PropertyAccess propertyAccess = (PropertyAccess)jComponent.getClientProperty(PROPERTY_ACCESS_PROPERTY);
            if (propertyAccess instanceof SecureProperty) {
                propertyAccess = ((SecureProperty)SecureProperty.class.cast(propertyAccess)).getProperty();
            }
            if (propertyAccess == null) continue;
            mArrayList.add(new Pair(propertyAccess, this.getViewComponent(jComponent)));
        }
        return mArrayList;
    }

    protected Class<? extends JComponent> getPreferredEditorClass(PropertyAccess<?> propertyAccess) {
        return null;
    }

    @Deprecated
    protected <T extends JComponent> T getViewComponent(JComponent jComponent) {
        return PropertyPanel.getWrappedView(jComponent);
    }

    protected void onUserPropertyChange(PropertyAccess<?> propertyAccess) {
    }

    protected boolean updateCustomModel(PropertyAccess<?> propertyAccess, JComponent jComponent) {
        return false;
    }

    protected boolean updateCustomView(PropertyAccess<?> propertyAccess, JComponent jComponent) {
        return false;
    }

    private void setFormatToolTipText(MFormattedTextField mFormattedTextField, Object object) {
        JFormattedTextField.AbstractFormatter abstractFormatter = mFormattedTextField.getFormatter();
        if (abstractFormatter instanceof NumberFormatter) {
            try {
                mFormattedTextField.setToolTipText(UI._("Example: {0}", abstractFormatter.valueToString(object)));
            }
            catch (ParseException parseException) {
                MLogger.exception(parseException);
            }
        }
    }

    void uninstallPropertyChangeListeners(PropertyChangeListener propertyChangeListener) {
        for (Pair<PropertyAccess<?>, JComponent> pair : this.getEditors()) {
            ((PropertyAccess)pair.getKey()).removePropertyChangeListener(propertyChangeListener);
        }
    }

    private static final class StaticPropertyHandler<P>
    extends MDocumentAdapter<JTextComponent>
    implements ActionListener,
    ChangeListener {
        private final PropertyAccess<P> property;
        private final WeakReference<PropertyPanel> propertyPanelRef;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof MCheckBox) {
                this.update(((MCheckBox)MCheckBox.class.cast(actionEvent.getSource())).isSelected());
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof MNumberSpinner) {
                this.update(((MNumberSpinner)MNumberSpinner.class.cast(changeEvent.getSource())).getNumber());
            } else if (changeEvent.getSource() instanceof MSlider) {
                Component component;
                Container container;
                MSlider mSlider = (MSlider)changeEvent.getSource();
                if (!mSlider.getValueIsAdjusting()) {
                    this.update(mSlider.getValue());
                }
                if ((container = mSlider.getParent()) != null && (component = ContainerIterator.findName(container, "value")) instanceof MLabel) {
                    ((MLabel)MLabel.class.cast(component)).setNumber(mSlider.getValue());
                }
            } else if (changeEvent.getSource() instanceof MSmallColorChooser) {
                this.update(((MSmallColorChooser)MSmallColorChooser.class.cast(changeEvent.getSource())).getColor());
            }
        }

        @Override
        protected void onChange(DocumentEvent documentEvent) {
            Object t = this.getTextComponent();
            if (t instanceof MFormattedTextField) {
                MFormattedTextField mFormattedTextField = (MFormattedTextField)t;
                try {
                    mFormattedTextField.commitEdit();
                    this.update(mFormattedTextField.getValue());
                }
                catch (ParseException parseException) {}
            } else if (t != null) {
                this.update(((JTextComponent)t).getText());
            }
        }

        private StaticPropertyHandler(PropertyPanel propertyPanel, JTextComponent jTextComponent, PropertyAccess<P> propertyAccess) {
            super(jTextComponent);
            this.propertyPanelRef = TK.newWeakRef(propertyPanel);
            this.property = propertyAccess;
        }

        private StaticPropertyHandler(PropertyPanel propertyPanel, PropertyAccess<P> propertyAccess) {
            this.propertyPanelRef = TK.newWeakRef(propertyPanel);
            this.property = propertyAccess;
        }

        private void update(Object object) {
            PropertyPanel propertyPanel = (PropertyPanel)this.propertyPanelRef.get();
            if (propertyPanel != null && propertyPanel.getAutoUpdateModel()) {
                this.property.set(object);
                propertyPanel.onUserPropertyChange(this.property);
            }
        }
    }

    private static final class StaticFocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            MPanel.Wrapper wrapper = this.getWrapper(focusEvent);
            if (wrapper != null) {
                wrapper.setState(MPanel.Wrapper.State.FOCUSED);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            MPanel.Wrapper wrapper = this.getWrapper(focusEvent);
            if (wrapper != null) {
                wrapper.setState(MPanel.Wrapper.State.NORMAL);
            }
        }

        private StaticFocusHandler(JComponent jComponent) {
            Component component;
            JComponent jComponent2 = null;
            if (jComponent instanceof AbstractSpinner) {
                jComponent2 = ((AbstractSpinner)AbstractSpinner.class.cast(jComponent)).getTextField();
            } else if (jComponent instanceof JScrollPane && (component = ((JScrollPane)JScrollPane.class.cast(jComponent)).getViewport().getView()) instanceof JComponent) {
                jComponent2 = (JComponent)component;
            }
            if (jComponent2 == null) {
                jComponent2 = jComponent;
            }
            jComponent2.addFocusListener(this);
        }

        private MPanel.Wrapper getWrapper(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JComponent) {
                MPanel.Wrapper wrapper = UI.getAncestorOfClass(MPanel.Wrapper.class, (JComponent)focusEvent.getSource());
                if (wrapper == null) {
                    return null;
                }
                if (focusEvent.getID() == 1004 && wrapper.getParent() instanceof PropertyPanel && !((PropertyPanel)PropertyPanel.class.cast(wrapper.getParent())).getHighlightFocusedEditor()) {
                    return null;
                }
                return wrapper;
            }
            return null;
        }
    }

    private static final class EnumRenderer
    extends MRenderer<Enum<?>> {
        private final WeakReference<PropertyPanel> propertyPanelRef;

        @Override
        protected void onRender(Enum<?> enum_) {
            PropertyPanel propertyPanel = (PropertyPanel)this.propertyPanelRef.get();
            String string = propertyPanel == null ? null : propertyPanel.getEnumText(enum_);
            this.setText(string == null ? enum_.toString() : string);
        }

        private EnumRenderer(PropertyPanel propertyPanel) {
            this.propertyPanelRef = new WeakReference<PropertyPanel>(propertyPanel);
        }
    }

    private static final class DatePropertyEditorButton
    extends MSmallButton {
        private final WeakReference<MDateSpinner> spinnerRef;

        @Override
        protected MMenu onPopupMenu() {
            MDateSpinner mDateSpinner = (MDateSpinner)this.spinnerRef.get();
            if (mDateSpinner == null) {
                return null;
            }
            MMenu mMenu = new MMenu();
            mMenu.add(mDateSpinner.createMenuCalendarPanel(mMenu));
            return mMenu;
        }

        private DatePropertyEditorButton(MDateSpinner mDateSpinner) {
            super(MActionInfo.SET_DATE_TIME);
            this.spinnerRef = new WeakReference<MDateSpinner>(mDateSpinner);
            this.setPopupMenuArrowPainted(false);
            this.setPopupMenuEnabled(true);
        }
    }

    public static class VerticalWrapper<T extends JComponent>
    extends MPanel.Wrapper<T> {
        public VerticalWrapper(T t, String string) {
            super(10, 5, 1, t, string);
            new StaticFocusHandler((JComponent)t);
        }
    }

    public static class HorizontalWrapper<T extends JComponent>
    extends MPanel.Wrapper<T> {
        public HorizontalWrapper(T t, String string, boolean bl) {
            super(10, 5, 0, t, string);
            if (bl) {
                this.limitHeight((Component)t);
            }
            new StaticFocusHandler((JComponent)t);
        }
    }
}

