/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.commons.Config;
import org.makagiga.commons.FileSelection;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLinkAction;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.DocumentLinks;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoAction;
import org.makagiga.fs.MetaInfoMenu;
import org.makagiga.fs.dnd.MetaInfoSelection;
import org.makagiga.search.Hit;
import org.makagiga.search.Query;
import org.makagiga.search.SortMethod;
import org.makagiga.tree.PropertiesBar;
import org.makagiga.tree.Tree;
import org.makagiga.tree.tracker.Tracker;

public final class Links {
    private static final String META_INFO_PROPERTY = "org.makagiga.fs.Links.metaInfo";

    public static boolean addLink(MetaInfo metaInfo, MetaInfo metaInfo2) {
        if (!Links.canAdd(metaInfo, metaInfo2)) {
            return false;
        }
        List<MetaInfo> list = Links.getLinks(metaInfo);
        if (!list.contains(metaInfo2)) {
            list.add(metaInfo2);
            Config config = metaInfo.getConfig();
            config.write("links", Links.toString(list, ','));
            config.sync();
            return true;
        }
        return false;
    }

    public static boolean addLink(MetaInfo metaInfo, URI uRI) {
        List<URI> list = Links.getURILinks(metaInfo);
        if (!list.contains(uRI)) {
            list.add(uRI);
            Config config = metaInfo.getConfig();
            config.write("uriLinks", Links.toString(list, ' '));
            config.sync();
            return true;
        }
        return false;
    }

    public static boolean canAdd(MetaInfo metaInfo, MetaInfo metaInfo2) {
        if (metaInfo2 == metaInfo) {
            return false;
        }
        return !metaInfo2.isVirtualFile() && !TK.isEmpty(metaInfo2.getID());
    }

    public static MButton createLinksButton() {
        MButton mButton = new MButton(){

            @Override
            protected MMenu onPopupMenu() {
                return Links.createLinksMenu(this, UI.getClientProperty(this, Links.META_INFO_PROPERTY, null));
            }
        };
        mButton.setPopupMenuEnabled(true);
        UI.setHTMLHelp(mButton, UI._("Links to other related items.<br><br>Tip: You can drag and drop items here<br>to create new links."));
        mButton.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                if (!transferSupport.getComponent().isEnabled()) {
                    return false;
                }
                if (!transferSupport.isDrop()) {
                    return false;
                }
                for (DataFlavor dataFlavor : transferSupport.getDataFlavors()) {
                    if (!dataFlavor.equals(MetaInfoSelection.META_INFO_LIST) && !FileSelection.isURIList(dataFlavor)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                Transferable transferable = transferSupport.getTransferable();
                try {
                    if (transferSupport.isDataFlavorSupported(MetaInfoSelection.META_INFO_LIST)) {
                        MetaInfoSelection.MetaInfoList metaInfoList = MDataTransfer.getData(transferable, MetaInfoSelection.META_INFO_LIST, MetaInfoSelection.MetaInfoList.class);
                        if (metaInfoList != null) {
                            MetaInfo metaInfo = UI.getClientProperty((JComponent)transferSupport.getComponent(), Links.META_INFO_PROPERTY, null);
                            for (MetaInfo metaInfo2 : metaInfoList) {
                                Links.addLink(metaInfo, metaInfo2);
                            }
                            Links.updateButtonText(metaInfo);
                            return true;
                        }
                    } else {
                        FileSelection.URIList uRIList = FileSelection.getURIList(transferable);
                        if (uRIList != null) {
                            MetaInfo metaInfo = UI.getClientProperty((JComponent)transferSupport.getComponent(), Links.META_INFO_PROPERTY, null);
                            for (URI uRI : uRIList) {
                                Links.addLink(metaInfo, uRI);
                            }
                            Links.updateButtonText(metaInfo);
                            return true;
                        }
                    }
                    return false;
                }
                catch (Exception exception) {
                    MMessage.error(null, exception);
                    return false;
                }
            }
        });
        return mButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MMenu createLinksMenu(MButton mButton, MetaInfo metaInfo) {
        MMenu mMenu = new MMenu();
        mMenu.setSplitMenu(true);
        try {
            Collection<MLinkAction> collection;
            Serializable serializable;
            Object object;
            Object object2;
            UI.setWaitCursor(mButton, true);
            List<URI> list = Links.getURILinks(metaInfo);
            if (!list.isEmpty()) {
                mMenu.addTitle(UI._("External Links"));
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (URI)object2.next();
                    serializable = new MLinkAction((URI)object);
                    mMenu.add((MAction)serializable);
                }
            }
            if (!(object2 = Links.getLinks(metaInfo)).isEmpty()) {
                mMenu.addTitle(UI._("Local Items"));
                object = object2.iterator();
                while (object.hasNext()) {
                    serializable = (MetaInfo)object.next();
                    mMenu.add(new OpenLinkAction((MetaInfo)serializable));
                }
            }
            if ((serializable = ((Tabs)(object = Tabs.getInstance())).getTabAt(metaInfo)) instanceof DocumentLinks && !(collection = ((DocumentLinks)DocumentLinks.class.cast(serializable)).getDocumentLinks()).isEmpty()) {
                mMenu.addTitle(UI._("Links in this Document"));
                for (MLinkAction mLinkAction : collection) {
                    mMenu.add(mLinkAction);
                }
            }
            boolean bl = true;
            if (mMenu.isEmpty()) {
                bl = false;
                mMenu.addTitle(UI._("No Links"));
            }
            if (metaInfo.isWriteable()) {
                if (bl) {
                    mMenu.addSeparator();
                }
                mMenu.add(Links.createAddLinkMenu(metaInfo, (List<MetaInfo>)object2));
                if (bl) {
                    mMenu.addSeparator();
                    mMenu.add(Links.createRemoveLinkMenu(metaInfo));
                }
            }
            mMenu.addSeparator();
            mMenu.add(Links.createWhatLinksHereMenu(metaInfo));
        }
        finally {
            UI.setWaitCursor(mButton, false);
        }
        return mMenu;
    }

    public static List<MetaInfo> getLinks(MetaInfo metaInfo) {
        if (metaInfo.isLink()) {
            return Links.getLinks(metaInfo.getLink());
        }
        if (metaInfo.isVirtualFile()) {
            return Collections.emptyList();
        }
        Config config = metaInfo.getConfig();
        MArrayList<MetaInfo> mArrayList = new MArrayList<MetaInfo>();
        String string = config.read("links", null);
        if (TK.isEmpty(string)) {
            return mArrayList;
        }
        boolean bl = false;
        List<String> list = TK.fastSplit(string, ',');
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            MetaInfo metaInfo2 = Tracker.getByID(string2);
            if (metaInfo2 != null) {
                if (metaInfo2 == metaInfo) continue;
                mArrayList.add(metaInfo2);
                continue;
            }
            MLogger.warning("links", "Removing dead link: %s", string2);
            bl = true;
            iterator.remove();
        }
        if (bl) {
            config.write("links", TK.join(list, ","));
            config.sync();
        }
        if (!mArrayList.isEmpty()) {
            mArrayList.sort();
        }
        return mArrayList;
    }

    public static List<URI> getURILinks(MetaInfo metaInfo) {
        if (metaInfo.isLink()) {
            return Links.getURILinks(metaInfo.getLink());
        }
        Config config = metaInfo.getConfig();
        MArrayList<URI> mArrayList = new MArrayList<URI>();
        String string = config.read("uriLinks", null);
        if (TK.isEmpty(string)) {
            return mArrayList;
        }
        for (String string2 : TK.fastSplit(string, ' ')) {
            try {
                mArrayList.add(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                MLogger.exception(uRISyntaxException);
            }
        }
        if (!mArrayList.isEmpty()) {
            mArrayList.sort();
        }
        return mArrayList;
    }

    public static void removeAllLinks(MetaInfo metaInfo) {
        Config config = metaInfo.getConfig();
        config.removeString("links");
        config.removeString("uriLinks");
        config.sync();
    }

    public static void removeLink(MetaInfo metaInfo, MetaInfo metaInfo2) {
        List<MetaInfo> list = Links.getLinks(metaInfo);
        if (list.contains(metaInfo2)) {
            list.remove(metaInfo2);
            Config config = metaInfo.getConfig();
            config.write("links", Links.toString(list, ','));
            config.sync();
        }
    }

    public static void removeLink(MetaInfo metaInfo, URI uRI) {
        List<URI> list = Links.getURILinks(metaInfo);
        if (list.contains(uRI)) {
            list.remove(uRI);
            Config config = metaInfo.getConfig();
            config.write("uriLinks", Links.toString(list, ' '));
            config.sync();
        }
    }

    public static void updateButton(MButton mButton, MetaInfo metaInfo) {
        mButton.putClientProperty(META_INFO_PROPERTY, metaInfo);
        if (metaInfo.isFile()) {
            mButton.setEnabled(true);
            Links.updateButtonText(metaInfo);
        } else {
            mButton.setEnabled(false);
            mButton.setText(UI._("Links"));
        }
    }

    private Links() {
    }

    private static MMenu createAddLinkMenu(final MetaInfo metaInfo, final List<MetaInfo> list) {
        MMenu mMenu = new MMenu(UI._("Add Link"), "ui/newfile");
        mMenu.setSplitMenu(true);
        mMenu.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                mMenu.add(new AddLinkAddressAction(metaInfo));
                mMenu.addSeparator();
                List<AbstractFS> list2 = TK.sortByValue(Tree.getInstance().getFileSystems(), new Comparator<AbstractFS>(){

                    @Override
                    public int compare(AbstractFS abstractFS, AbstractFS abstractFS2) {
                        if (abstractFS.getInfo() == null || abstractFS2.getInfo() == null) {
                            return 1;
                        }
                        return abstractFS.getInfo().compareTo(abstractFS2.getInfo());
                    }
                });
                for (AbstractFS abstractFS : list2) {
                    mMenu.add(new MetaInfoMenu(abstractFS.getRoot()){

                        @Override
                        protected boolean canAdd(MetaInfo metaInfo) {
                            if (metaInfo.isFolder() && !TK.isEmpty(metaInfo.getID())) {
                                return true;
                            }
                            return Links.canAdd(metaInfo, metaInfo) && !list.contains(metaInfo);
                        }

                        @Override
                        protected void onAction(MetaInfo metaInfo) {
                            Links.addLink(metaInfo, metaInfo);
                            Links.updateButtonText(metaInfo);
                        }
                    });
                }
                if (mMenu.isEmpty()) {
                    mMenu.addTitle(UI._("No Items"));
                }
            }
        });
        return mMenu;
    }

    private static MMenu createRemoveLinkMenu(final MetaInfo metaInfo) {
        MMenu mMenu = new MMenu(UI._("Remove Link"), "ui/delete");
        mMenu.setSplitMenu(true);
        mMenu.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                for (URI object : Links.getURILinks(metaInfo)) {
                    mMenu.add(new RemoveLinkAction(metaInfo, object));
                }
                List<MetaInfo> list = Links.getLinks(metaInfo);
                if (!list.isEmpty()) {
                    if (!mMenu.isEmpty()) {
                        mMenu.addSeparator();
                    }
                    for (MetaInfo metaInfo2 : list) {
                        mMenu.add(new RemoveLinkAction(metaInfo, metaInfo2));
                    }
                }
                if (mMenu.isEmpty()) {
                    mMenu.addTitle(UI._("No Links"));
                } else {
                    mMenu.addSeparator();
                    mMenu.add(new RemoveAllLinksAction(metaInfo));
                }
            }
        });
        return mMenu;
    }

    private static MMenu createWhatLinksHereMenu(final MetaInfo metaInfo) {
        MMenu mMenu = new MMenu(UI._("What Links Here"));
        mMenu.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                if (!metaInfo.getID().isEmpty()) {
                    for (Hit hit : Query.all(SortMethod.PATH)) {
                        MetaInfo metaInfo2 = (MetaInfo)hit.get();
                        if (metaInfo == metaInfo2 || !Links.getLinks(metaInfo2).contains(metaInfo)) continue;
                        mMenu.add(new OpenLinkAction(metaInfo2));
                    }
                }
                if (mMenu.isEmpty()) {
                    mMenu.addTitle(UI._("No Items"));
                }
            }
        });
        return mMenu;
    }

    private static String toString(List<?> list, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c);
            }
            if (obj instanceof MetaInfo) {
                stringBuilder.append(((MetaInfo)MetaInfo.class.cast(obj)).getID());
                continue;
            }
            if (!(obj instanceof URI)) continue;
            stringBuilder.append(obj.toString());
        }
        return stringBuilder.toString();
    }

    private static void updateButtonText(MetaInfo metaInfo) {
        Config config = metaInfo.getConfig();
        String string = config.read("links", null);
        String string2 = config.read("uriLinks", null);
        int n = 0;
        if (!TK.isEmpty(string)) {
            n += TK.fastSplit(string, ',').size();
        }
        if (!TK.isEmpty(string2)) {
            n += TK.fastSplit(string2, ' ').size();
        }
        MButton mButton = PropertiesBar.getInstance().getLinksButton();
        if (n == 0) {
            mButton.setText(UI._("Links"));
        } else {
            mButton.setText(UI._("Links: {0}", n));
        }
    }

    private static final class RemoveLinkAction
    extends MetaInfoAction {
        private final MetaInfo parent;
        private URI uriLink;

        @Override
        public void onAction() {
            if (!MMessage.confirmDelete(null, UI._("Remove link?"), this.getName())) {
                return;
            }
            if (this.uriLink != null) {
                Links.removeLink(this.parent, this.uriLink);
            } else {
                Links.removeLink(this.parent, (MetaInfo)this.getData());
            }
            Links.updateButtonText(this.parent);
        }

        private RemoveLinkAction(MetaInfo metaInfo, MetaInfo metaInfo2) {
            super(metaInfo2, true);
            this.parent = metaInfo;
        }

        private RemoveLinkAction(MetaInfo metaInfo, URI uRI) {
            super(MetaInfo.createDummy(uRI.toString(), null), false);
            this.parent = metaInfo;
            this.uriLink = uRI;
        }
    }

    private static final class RemoveAllLinksAction
    extends MDataAction<MetaInfo> {
        @Override
        public void onAction() {
            MetaInfo metaInfo = (MetaInfo)this.getData();
            ArrayList<Comparable<URI>> arrayList = new ArrayList<Comparable<URI>>();
            arrayList.addAll(Links.getURILinks(metaInfo));
            arrayList.addAll(Links.getLinks(metaInfo));
            if (MMessage.customConfirm(null, MIcon.stock("ui/delete"), new MActionInfo(UI._("Remove All"), "ui/delete"), null, UI._("Remove all links?"), arrayList.toArray())) {
                Links.removeAllLinks(metaInfo);
                Links.updateButtonText(metaInfo);
            }
        }

        private RemoveAllLinksAction(MetaInfo metaInfo) {
            super(metaInfo, UI._("Remove All Links"), "ui/delete");
        }
    }

    private static final class OpenLinkAction
    extends MetaInfoAction {
        @Override
        public void onAction() {
            super.onAction();
            MainWindow.showSidebar();
        }

        private OpenLinkAction(MetaInfo metaInfo) {
            super(metaInfo, true);
        }
    }

    private static final class AddLinkAddressAction
    extends MDataAction<MetaInfo> {
        @Override
        public void onAction() {
            String string = MMessage.input(null, null, UI._("Link Address (examples: {0}):", "http://makagiga.sf.net, /home, mailto:email@example.com, xmpp:jid@example.com"), UI._("Add Link Address"), "ui/misc", "linkurl");
            if (string != null) {
                MetaInfo metaInfo = (MetaInfo)this.getData();
                try {
                    Links.addLink(metaInfo, new URI(string));
                    Links.updateButtonText(metaInfo);
                }
                catch (URISyntaxException uRISyntaxException) {
                    MMessage.error(null, uRISyntaxException, UI._("Invalid link adress"));
                }
            }
        }

        private AddLinkAddressAction(MetaInfo metaInfo) {
            super(metaInfo, UI._("Add Link Address..."), "ui/misc");
        }
    }
}

