/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.ghns;

import java.awt.Image;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.makagiga.commons.MDate;
import org.makagiga.commons.Searchable;
import org.makagiga.commons.TK;
import org.makagiga.ghns.LocalizedString;

public class Stuff
implements Comparable<Stuff>,
Searchable<String>,
Serializable {
    private static final long serialVersionUID = 2486247718866838672L;
    private Author author;
    private transient Image previewCache;
    private int downloads;
    private int rating;
    private List<Changes> changes;
    private List<Name> name;
    private List<Payload> payload;
    private List<Preview> preview;
    private List<Summary> summary;
    private MDate releaseDate;
    private String category;
    private String version;
    private int pluginRequires;
    private int pluginVersion;
    private String pluginID;

    @XmlElement(name="author")
    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    @XmlAttribute(name="category")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    @XmlElement(name="changes")
    public List<Changes> getChanges() {
        return this.changes;
    }

    public void setChanges(List<Changes> list) {
        this.changes = list;
    }

    @XmlTransient
    public String getLocalizedChanges() {
        return LocalizedString.get(this.changes);
    }

    @XmlElement(name="downloads")
    public int getDownloads() {
        return this.downloads;
    }

    public void setDownloads(int n) {
        this.downloads = n;
    }

    @XmlElement(name="name")
    public List<Name> getName() {
        return this.name;
    }

    public void setName(List<Name> list) {
        this.name = list;
    }

    @XmlTransient
    public String getLocalizedName() {
        return LocalizedString.get(this.name);
    }

    @XmlElement(name="payload")
    public List<Payload> getPayload() {
        return this.payload;
    }

    public void setPayload(List<Payload> list) {
        this.payload = list;
    }

    @XmlTransient
    public String getLocalizedPayload() {
        return LocalizedString.get(this.payload);
    }

    @XmlElement(name="preview")
    public List<Preview> getPreview() {
        return this.preview;
    }

    public void setPreview(List<Preview> list) {
        this.preview = list;
    }

    @XmlTransient
    public String getLocalizedPreview() {
        return LocalizedString.get(this.preview);
    }

    @XmlTransient
    public Image getPreviewCache() {
        return this.previewCache;
    }

    public void setPreviewCache(Image image) {
        this.previewCache = image;
    }

    @XmlElement(name="rating")
    public int getRating() {
        return this.rating;
    }

    public void setRating(int n) {
        this.rating = Math.max(Math.min(n, 100), 0);
    }

    @XmlElement(name="releasedate")
    public String getReleaseDate() {
        return this.releaseDate == null ? null : this.releaseDate.format("yyyy-MM-dd", Locale.US);
    }

    public void setReleaseDate(String string) {
        this.releaseDate = MDate.parse(string, "yyyy-MM-dd", Locale.US, null);
        if (this.releaseDate != null) {
            this.releaseDate.freeze();
        }
    }

    @XmlTransient
    public MDate getReleaseDateValue() {
        return this.releaseDate;
    }

    public void setReleaseDateValue(MDate mDate) {
        this.releaseDate = mDate == null ? null : new MDate(mDate).freeze();
    }

    @XmlElement(name="summary")
    public List<Summary> getSummary() {
        return this.summary;
    }

    public void setSummary(List<Summary> list) {
        this.summary = list;
    }

    @XmlTransient
    public String getLocalizedSummary() {
        return LocalizedString.get(this.summary);
    }

    @XmlElement(name="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    @XmlElement(name="id", namespace="http://makagiga.org/damn.good.coffee/hot/")
    public String getPluginID() {
        return this.pluginID;
    }

    public void setPluginID(String string) {
        this.pluginID = string;
    }

    @XmlElement(name="version", namespace="http://makagiga.org/damn.good.coffee/hot/")
    public int getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(int n) {
        this.pluginVersion = n;
    }

    @XmlElement(name="requires", namespace="http://makagiga.org/damn.good.coffee/hot/")
    public int getPluginRequires() {
        return this.pluginRequires;
    }

    public void setPluginRequires(int n) {
        this.pluginRequires = n;
    }

    @Deprecated
    public boolean matches(String string) {
        if (TK.isEmpty(string)) {
            return true;
        }
        if (this.author != null && this.author.matches(string)) {
            return true;
        }
        return TK.containsIgnoreCase(this.category, string) || TK.containsIgnoreCase(this.getLocalizedChanges(), string) || TK.containsIgnoreCase(this.getLocalizedName(), string) || TK.containsIgnoreCase(this.getLocalizedPayload(), string) || TK.containsIgnoreCase(this.getLocalizedSummary(), string) || TK.containsIgnoreCase(this.getVersion(), string) || this.releaseDate != null && this.releaseDate.isValid() && TK.containsIgnoreCase(this.formatReleaseDate(), string);
    }

    @Override
    public int compareTo(Stuff stuff) {
        return this.getLocalizedName().compareToIgnoreCase(stuff.getLocalizedName());
    }

    @Override
    public boolean matches(String string, EnumSet<Searchable.Matches> enumSet) {
        return this.matches(string);
    }

    String formatReleaseDate() {
        return this.releaseDate.fancyFormat(1, false);
    }

    public static final class Summary
    extends LocalizedString {
    }

    public static final class Preview
    extends LocalizedURL {
    }

    public static final class Payload
    extends LocalizedURL {
    }

    public static final class Name
    extends LocalizedString {
    }

    public static abstract class LocalizedURL
    extends LocalizedString {
        public URL toURL() throws MalformedURLException {
            return new URL(this.getValue());
        }

        public static URL toURL(List<LocalizedURL> list) throws MalformedURLException {
            return new URL(LocalizedURL.get(list));
        }
    }

    public static final class Changes
    extends LocalizedString {
    }

    public static final class Author
    implements Searchable<String>,
    Serializable {
        private String email;
        private String homePage;
        private String im;
        private String name;

        @XmlAttribute(name="email")
        public String getEmail() {
            return this.email;
        }

        public void setEmail(String string) {
            this.email = string;
        }

        @XmlAttribute(name="homepage")
        public String getHomePage() {
            return this.homePage;
        }

        public void setHomePage(String string) {
            this.homePage = string;
        }

        @XmlAttribute(name="im")
        public String getIM() {
            return this.im;
        }

        public void setIM(String string) {
            this.im = string;
        }

        @XmlValue
        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        @Deprecated
        public boolean matches(String string) {
            if (TK.isEmpty(string)) {
                return true;
            }
            return TK.containsIgnoreCase(this.email, string) || TK.containsIgnoreCase(this.homePage, string) || TK.containsIgnoreCase(this.im, string) || TK.containsIgnoreCase(this.name, string);
        }

        @Override
        public boolean matches(String string, EnumSet<Searchable.Matches> enumSet) {
            return this.matches(string);
        }
    }
}

