/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import com.jhlabs.image.GrayscaleFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.MSlider;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

final class CustomColorSettings
extends MSettingsPage {
    private final ColorPanel colorPanel;
    private final MSlider hSlider;
    private StaticHandler staticHandler;

    @Override
    public void restoreDefaultValues() {
        super.restoreDefaultValues();
        this.setCustomColor((Color)UI.customColor.getDefaultValue());
        this.updateComponents();
    }

    private static float[] getHSB(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    private void setCustomColor(Color color) {
        float[] fArray = CustomColorSettings.getHSB(color);
        this.hSlider.setValue((int)(fArray[0] * (float)this.hSlider.getMaximum()));
    }

    private void updateComponents() {
        MCheckBox mCheckBox = (MCheckBox)this.getEditorView(UI.useCustomColor);
        boolean bl = mCheckBox.isSelected();
        this.colorPanel.setCursor(bl ? 12 : 0);
        this.colorPanel.setEnabled(bl);
        this.hSlider.setEnabled(bl);
    }

    private void updateCustomColors(boolean bl, int n) {
        MCheckBox mCheckBox = (MCheckBox)this.getEditorView(UI.useCustomColor);
        if (!mCheckBox.isSelected()) {
            return;
        }
        float[] fArray = CustomColorSettings.getHSB((Color)UI.customColor.getDefaultValue());
        UI.customColor.set(Color.getHSBColor((float)n / (float)this.hSlider.getMaximum(), fArray[1], fArray[2]));
        if (!bl) {
            UI.initCustomColor(UIManager.getDefaults());
            Window window = this.getWindowAncestor();
            if (window != null) {
                window.repaint();
            } else {
                this.repaint();
            }
        }
    }

    @Override
    protected void onClose() {
        if (this.staticHandler != null) {
            this.hSlider.removeChangeListener(this.staticHandler);
            MCheckBox mCheckBox = (MCheckBox)this.getEditorView(UI.useCustomColor);
            mCheckBox.removeActionListener(this.staticHandler);
            this.staticHandler = null;
        }
    }

    CustomColorSettings() {
        this.setDialogFlags(36);
        Color color = new Color(51, 98, 140);
        if (UI.customColor.isDefaultValue()) {
            UI.customColor.set(color);
        }
        UI.customColor.setDefaultValue(color);
        MCheckBox mCheckBox = (MCheckBox)this.bind(UI.useCustomColor, UI._("Use Custom Color"));
        this.addContentGap();
        this.colorPanel = new ColorPanel(this);
        this.add(this.colorPanel);
        this.hSlider = new MSlider();
        this.hSlider.setMinimum(0);
        this.hSlider.setMaximum(359);
        this.add(this.hSlider);
        this.addContentGap();
        MPanel mPanel = MPanel.createVBoxPanel();
        mPanel.setTitle(UI._("Preview"));
        mPanel.add(new MButton(UI._("Preview")));
        mPanel.addGap();
        mPanel.add(new MTextField(UI._("Preview")));
        this.add(mPanel);
        this.staticHandler = new StaticHandler();
        this.hSlider.addChangeListener(this.staticHandler);
        mCheckBox.addActionListener(this.staticHandler);
        this.setCustomColor((Color)UI.customColor.get());
        this.updateComponents();
    }

    private static final class StaticHandler
    implements ActionListener,
    ChangeListener {
        private StaticHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MCheckBox mCheckBox = (MCheckBox)actionEvent.getSource();
            CustomColorSettings customColorSettings = UI.getAncestorOfClass(CustomColorSettings.class, mCheckBox);
            customColorSettings.updateComponents();
            if (mCheckBox.isSelected()) {
                customColorSettings.hSlider.requestFocusInWindow();
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MSlider mSlider = (MSlider)changeEvent.getSource();
            UI.getAncestorOfClass(CustomColorSettings.class, mSlider).updateCustomColors(mSlider.getValueIsAdjusting(), mSlider.getValue());
        }
    }

    private static final class ColorPanel
    extends MComponent {
        private final BufferedImage cache;
        private final BufferedImage disabledCache;
        private final Dimension size = new Dimension(720, MIcon.getUISize());
        private final WeakReference<CustomColorSettings> settingsRef;

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return (Dimension)this.size.clone();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.isEnabled()) {
                if (this.cache != null) {
                    graphics.drawImage(this.cache, 0, 0, null);
                }
            } else if (this.disabledCache != null) {
                graphics.drawImage(this.disabledCache, 0, 0, null);
            }
        }

        private ColorPanel(CustomColorSettings customColorSettings) {
            this.settingsRef = TK.newWeakRef(customColorSettings);
            this.setToolTipText(UI._("Color"));
            this.cache = UI.createCompatibleImage(this.size.width, this.size.height, false);
            float[] fArray = CustomColorSettings.getHSB((Color)UI.customColor.getDefaultValue());
            Graphics2D graphics2D = this.cache.createGraphics();
            for (int i = 0; i < this.size.width; i += 2) {
                graphics2D.setColor(new Color(Color.HSBtoRGB((float)i / (float)this.size.width, fArray[1], 0.8f)));
                graphics2D.fillRect(i, 0, 2, this.size.height);
            }
            graphics2D.dispose();
            GrayscaleFilter grayscaleFilter = new GrayscaleFilter();
            this.disabledCache = grayscaleFilter.filter(this.cache, null);
            this.addMouseListener(new MMouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ColorPanel colorPanel = (ColorPanel)mouseEvent.getSource();
                    if (colorPanel.isEnabled()) {
                        ((CustomColorSettings)colorPanel.settingsRef.get()).hSlider.setValue(mouseEvent.getX() / 2);
                    }
                }
            });
        }
    }
}

