/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.BasicPermission;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.event.EventListenerList;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Gettext;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MLinkButton;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MSettingsDialog;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MZip;
import org.makagiga.commons.OS;
import org.makagiga.commons.SafeMode;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.Tuple;
import org.makagiga.commons.UI;
import org.makagiga.commons.VersionProperty;
import org.makagiga.commons.preview.AbstractPreview;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.plugins.AbstractPlugin;
import org.makagiga.plugins.LookAndFeelPlugin;
import org.makagiga.plugins.Pluggable;
import org.makagiga.plugins.PluginClassLoader;
import org.makagiga.plugins.PluginDownloader;
import org.makagiga.plugins.PluginEvent;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginInstaller;
import org.makagiga.plugins.PluginListener;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.plugins.PluginOptions;
import org.makagiga.plugins.PluginSettings;
import org.makagiga.plugins.PluginType;
import org.makagiga.plugins.ScriptPlugin;

public final class PluginManager
implements MApplication.ShutDownListener {
    public static final MActionInfo GET_MORE_PLUGINS_ACTION_INFO = new MActionInfo(UI._("Get More Plugins..."), "ui/download");
    public static final MActionInfo UPDATE_PLUGINS_ACTION_INFO = new MActionInfo(UI._("Update Plugins..."), "ui/refresh");
    public static final int REGISTER_INTERNAL = 1;
    public static final int REGISTER_TEST = 2;
    public static final int REGISTER_FORCE = 4;
    private static PluginManager _instance;
    private final EventListenerList listeners = new EventListenerList();
    private final Map<String, PluginInfo> idMap = new HashMap<String, PluginInfo>();
    private PublicKey publicKey;
    private final Table table;

    public void addPluginListener(PluginListener pluginListener) {
        this.listeners.add(PluginListener.class, pluginListener);
    }

    public void removePluginListener(PluginListener pluginListener) {
        this.listeners.remove(PluginListener.class, pluginListener);
    }

    @SafeMode
    public static void addPluginOptions(MSettingsDialog<MSettingsPage> mSettingsDialog) {
        for (PluginInfo pluginInfo : PluginManager.getTable()) {
            Pluggable pluggable = pluginInfo.getPluggable();
            if (!(pluggable instanceof PluginOptions) || pluggable instanceof LookAndFeelPlugin && (!(pluggable instanceof LookAndFeelPlugin) || ((LookAndFeelPlugin)LookAndFeelPlugin.class.cast(pluggable)).getLookAndFeelInfo() != null) || "{70b8557a-09e0-41e1-91da-1b5f5f733cbc}".equals(pluginInfo.getID())) continue;
            PluginSettings.Panel panel = null;
            if (pluggable instanceof ScriptPlugin) {
                MPanel mPanel = PluginSettings.createConfigPanel(pluggable, false);
                if (mPanel != null) {
                    panel = new PluginSettings.Panel(pluginInfo, mPanel);
                }
            } else {
                panel = new PluginSettings.Panel(pluginInfo, null);
            }
            if (panel == null) continue;
            mSettingsDialog.addPage(panel);
        }
    }

    public static MLinkButton createPluginInstallButton(List<Tuple.Two<String, String>> list) {
        PluginManager pluginManager = PluginManager.getInstance();
        MArrayList<Tuple.Two<String, String>> mArrayList = MArrayList.create();
        for (Tuple.Two<String, String> two : list) {
            PluginInfo pluginInfo = pluginManager.getByID(two.get2());
            if (pluginInfo != null) continue;
            mArrayList.add(two);
        }
        InstallButton installButton = new InstallButton(mArrayList);
        if (mArrayList.isEmpty()) {
            installButton.setVisible(false);
        }
        return installButton;
    }

    public static MAction createPluginOptionsAction() {
        return new MAction(UI._("Plugin Settings"), "ui/configure"){

            @Override
            public void onAction() {
                MSettingsDialog<MSettingsPage> mSettingsDialog = new MSettingsDialog<MSettingsPage>(this.getSourceWindow(), UI._("Plugin Settings"), "ui/configure", "plugin-settings", 2);
                mSettingsDialog.setAutoResizeWindow(true);
                PluginManager.addPluginOptions(mSettingsDialog);
                mSettingsDialog.exec();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginInfo getByID(String string) {
        if (string == null) {
            return null;
        }
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            return this.idMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey getPublicKey() throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        PluginManager.checkPermission("getPublicKey");
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            if (this.publicKey == null) {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                InputStream inputStream = this.getClass().getResourceAsStream("Key.public");
                try {
                    keyStore.load(inputStream, null);
                    Certificate certificate = keyStore.getCertificate("http://makagiga.sourceforge.net");
                    this.publicKey = certificate.getPublicKey();
                    MLogger.debug("plugin", "Found public key: %s", certificate);
                }
                finally {
                    FS.close(inputStream);
                }
            }
            return this.publicKey;
        }
    }

    public static Table getTable() {
        return PluginManager.getTable(null, false);
    }

    public static synchronized Table getTable(String string, boolean bl) {
        Table table = new Table();
        for (PluginInfo pluginInfo : PluginManager.getInstance().table) {
            if (string != null && !pluginInfo.type.equalsValue(string) || !bl && (!((Boolean)pluginInfo.enabled.get()).booleanValue() || !((Boolean)pluginInfo.loaded.get()).booleanValue())) continue;
            table.add(pluginInfo);
        }
        return table;
    }

    public static PluginManager getInstance() {
        PluginManager.checkPermission("getInstance");
        return _instance;
    }

    public static void init() {
        PluginManager.init(false);
    }

    public static synchronized void init(boolean bl) {
        PluginManager.checkPermission("init");
        if (_instance != null) {
            throw new IllegalStateException("Plugin manager already initialized");
        }
        MLogger.info("plugin", "Initializing plugin manager...");
        if (bl && System.getSecurityManager() == null) {
            throw new IllegalStateException("No security manager");
        }
        new PluginManager();
        DefaultPreview.getInstance().addHandler("mgplugin", new AbstractPreview(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Image getImage(File file, int n, MProperties mProperties) throws Exception {
                MZip mZip = MZip.read(file);
                try {
                    for (ZipEntry zipEntry : mZip) {
                        if (zipEntry.isDirectory() || !zipEntry.getName().endsWith("/preview.png")) continue;
                        BufferedImage bufferedImage = ImageIO.read(mZip.getInputStream());
                        return bufferedImage;
                    }
                }
                finally {
                    FS.close(mZip);
                }
                return null;
            }
        });
    }

    public static <T> Iterable<T> loadServices(Class<T> clazz) {
        MArrayList mArrayList = new MArrayList();
        for (PluginInfo pluginInfo : PluginManager.getTable()) {
            ClassLoader classLoader;
            if (pluginInfo.getPluggable() == null || !((classLoader = pluginInfo.getPluggable().getClass().getClassLoader()) instanceof PluginClassLoader)) continue;
            PluginClassLoader pluginClassLoader = (PluginClassLoader)classLoader;
            try {
                pluginClassLoader.loadServices(clazz, mArrayList);
            }
            catch (Exception exception) {
                MLogger.exception(exception);
            }
        }
        return mArrayList;
    }

    @SafeMode
    public static synchronized void postInit() {
        for (PluginInfo pluginInfo : PluginManager.getTable()) {
            try {
                pluginInfo.getPluggable().onPostInit();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                MLogger.exception(throwable);
            }
        }
    }

    public synchronized PluginListener.Result register(PluginInfo pluginInfo) {
        MLogger.info("plugin", "Registering %s plugin: %s", pluginInfo.isInternal() ? "internal" : "external", pluginInfo);
        if (pluginInfo.isInternal()) {
            this.registerInternal(pluginInfo.getPath());
        } else {
            this.registerExternal(pluginInfo.getPath(), 0);
        }
        return this.firePluginChanged(pluginInfo, PluginEvent.ID.LOADED);
    }

    public synchronized boolean registerExternal(String string, int n) {
        try {
            PluginInstaller.unpackJars(string);
            return this.register(string, n);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return false;
        }
    }

    public synchronized boolean registerInternal(String string) {
        try {
            return this.register(string, 1);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return false;
        }
    }

    public static void setupGetMorePluginsButton(AbstractButton abstractButton) {
        if (((Boolean)UI.buttonIcons.get()).booleanValue()) {
            abstractButton.setIcon(GET_MORE_PLUGINS_ACTION_INFO.getSmallIcon());
        }
        abstractButton.setText(GET_MORE_PLUGINS_ACTION_INFO.getText());
    }

    public static synchronized void shutDown() {
        PluginManager.checkPermission("shutDown");
        if (_instance == null) {
            return;
        }
        for (PluginInfo pluginInfo : PluginManager._instance.table) {
            PluginManager.doShutDown(pluginInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PluginListener.Result unregister(PluginInfo pluginInfo) {
        this.idMap.remove(pluginInfo.getID());
        this.table.remove(pluginInfo);
        try {
            PluginListener.Result result = this.firePluginChanged(pluginInfo, PluginEvent.ID.UNLOADED);
            return result;
        }
        finally {
            PluginManager.doShutDown(pluginInfo);
        }
    }

    public static void updateMenu(MMenu mMenu, String string, boolean bl) {
        PluginManager.updateMenu(PluginManager.getTable(), mMenu, string, bl);
    }

    @SafeMode
    public static void updateMenu(PluginMenu pluginMenu, MMenu mMenu, String string, boolean bl) {
        int n = mMenu.getItemCount();
        pluginMenu.updateMenu(string, mMenu);
        if (bl && mMenu.getItemCount() != n) {
            mMenu.addSeparator();
        }
    }

    @SafeMode
    public static void updateMenu(Table table, MMenu mMenu, String string, boolean bl) {
        int n = mMenu.getItemCount();
        for (PluginInfo pluginInfo : table) {
            Pluggable pluggable = pluginInfo.getPluggable();
            if (!(pluggable instanceof PluginMenu)) continue;
            ((PluginMenu)PluginMenu.class.cast(pluggable)).updateMenu(string, mMenu);
        }
        if (bl && mMenu.getItemCount() != n) {
            mMenu.addSeparator();
        }
    }

    public static void updateToolBar(MToolBar mToolBar, String string, boolean bl) {
        PluginManager.updateToolBar(PluginManager.getTable(), mToolBar, string, bl);
    }

    @SafeMode
    public static void updateToolBar(Table table, MToolBar mToolBar, String string, boolean bl) {
        boolean bl2 = string.equals("EDITOR_TOOL_BAR");
        int n = mToolBar.getComponentCount();
        for (PluginInfo pluginInfo : table) {
            Pluggable pluggable = pluginInfo.getPluggable();
            if (bl2 && "org.makagiga.editors.EditorPlugin".equals(pluggable.getClass().getName()) || !(pluggable instanceof PluginMenu)) continue;
            try {
                ((PluginMenu)PluginMenu.class.cast(pluggable)).updateToolBar(string, mToolBar);
            }
            catch (AccessControlException accessControlException) {
                MLogger.exception(accessControlException);
            }
        }
        if (bl && mToolBar.getComponentCount() != n) {
            mToolBar.addSeparator();
        }
    }

    @Override
    public void shutDown(MApplication.ShutDownEvent shutDownEvent) {
        PluginManager.shutDown();
    }

    private PluginManager() {
        _instance = this;
        this.table = new Table();
        this.findExternalPlugins(FS.makePath(FS.getBaseDir(), "plugins"));
        this.findExternalPlugins(FS.makeConfigPath("plugins"));
        MApplication.addShutDownListener(this);
    }

    private void addLibs(PluginInfo pluginInfo, MArrayList<URL> mArrayList, String string) {
        if (string != null) {
            for (String string2 : TK.fastSplit(string, ' ')) {
                if (!string2.endsWith(".jar")) continue;
                mArrayList.add(FS.toURL(new File(pluginInfo.getPath(), string2)));
            }
        }
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private boolean deletePluginData(PluginInfo pluginInfo, String string) {
        return this.deletePluginData(pluginInfo, string, false);
    }

    private boolean deletePluginData(PluginInfo pluginInfo, String string, boolean bl) {
        String string2;
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        try {
            string2 = file.getCanonicalPath();
            if (TK.isEmpty(string2) || string.equals(".") || string.contains("..") || string2.equals(File.separator)) {
                MLogger.error("plugin", "Cannot remove plugin from this directory: \"%s\"", string2);
                return false;
            }
            if (file.isDirectory()) {
                string2 = string2 + File.separator;
            }
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return false;
        }
        if (TK.toUpperCase(string2).startsWith(TK.toUpperCase(pluginInfo.getPath()) + File.separator)) {
            if (file.isDirectory()) {
                if (bl) {
                    return FS.deleteDir(string2, true);
                }
                return file.delete();
            }
            return file.delete();
        }
        MLogger.error("plugin", "Cannot remove file from the outside plugin directory: \"%s\"", string2);
        return false;
    }

    private static void doShutDown(PluginInfo pluginInfo) {
        try {
            Pluggable pluggable = pluginInfo.getPluggable();
            if (pluggable != null) {
                pluggable.onDestroy();
                pluginInfo.setPluggable(null);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            MLogger.exception(throwable);
        }
    }

    @SafeMode
    private void findExternalPlugins(String string) {
        for (File file : FS.listFiles(new File(string), FS.DIRECTORY_FILTER)) {
            MLogger.info("plugin", "External plugin: \"%s\"", file.getPath());
            this.registerExternal(file.getPath(), 0);
        }
    }

    private PluginListener.Result firePluginChanged(PluginInfo pluginInfo, PluginEvent.ID iD) {
        PluginListener[] pluginListenerArray;
        PluginListener.Result result = PluginListener.Result.OK;
        if (this.listeners != null && (pluginListenerArray = (PluginListener[])this.listeners.getListeners(PluginListener.class)).length > 0) {
            PluginEvent pluginEvent = new PluginEvent(this, pluginInfo, iD);
            for (PluginListener pluginListener : pluginListenerArray) {
                PluginListener.Result result2 = pluginListener.pluginChanged(pluginEvent);
                if (result2 == PluginListener.Result.OK) continue;
                result = result2;
            }
        }
        return result;
    }

    private static boolean readConfig(Config config, Config config2, PluginInfo pluginInfo) {
        String string;
        int n;
        String string2 = config.read("name", null);
        if (TK.isEmpty(string2)) {
            MLogger.error("plugin", "No \"String.name\" specified: \"%s\"", pluginInfo.getPath());
            return false;
        }
        pluginInfo.name.set(string2);
        pluginInfo.bugs.set(config.read("bugs", null));
        pluginInfo.copyright.set(config.read("copyright", null));
        pluginInfo.homePageURL.set(config.read("homePageURL", null));
        pluginInfo.iconName.set(config.read("icon", null));
        pluginInfo.licenseName.set(config.read("licenseName", null));
        pluginInfo.licenseURL.set(config.read("licenseURL", null));
        pluginInfo.longDescription.set(config.read("longDescription", null));
        pluginInfo.shortDescription.set(config.read("shortDescription", null));
        if (pluginInfo.isInternal()) {
            pluginInfo.priority.set(config.readInt("priority", 0));
        }
        if ((n = config2.readInt("Plugin.priority." + pluginInfo.getID(), Integer.MIN_VALUE)) > Integer.MIN_VALUE) {
            pluginInfo.priority.set(n);
        }
        boolean bl = config.read("default.enabled", true);
        pluginInfo.enabled.set(config2.read("Plugin.enabled." + pluginInfo.getID(), bl));
        if (((Boolean)pluginInfo.enabled.get()).booleanValue() && !pluginInfo.isInternal() && MApplication.isSafeMode()) {
            MLogger.error("plugin", "SAFE MODE: This plugin will be disabled: %s", pluginInfo.name);
            pluginInfo.enabled.no();
        }
        if (!PluginType.isValidType(string = config.read("type", null))) {
            MLogger.error("plugin", "%s: Unknown plugin type: \"%s\"", pluginInfo, string);
            return false;
        }
        pluginInfo.type.set(string);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean register(String string, int n) throws Exception {
        Flags flags = new Flags(n);
        boolean bl = flags.isSet(1L);
        boolean bl2 = flags.isSet(2L);
        try {
            Pluggable pluggable;
            Config config;
            Object object;
            String string2 = null;
            if (bl) {
                object = (MProperties)TK.newInstance(string.replace('/', '.') + ".plugin");
                config = new Config((MProperties)object, 1);
            } else {
                string2 = string + File.separator + "plugin.properties";
                config = new Config(string2, 1);
                if (config.isError()) {
                    MLogger.error("plugin", "Properties file not found: \"%s\"", string2);
                    return false;
                }
            }
            object = null;
            try {
                object = config.read("id", null);
                if (TK.isEmpty((String)object) || ((String)object).length() != 38 || ((String)object).charAt(0) != '{' || ((String)object).charAt(37) != '}') {
                    throw new IllegalArgumentException("\"{\" or \"}\" expected: \"" + (String)object + "\"");
                }
                UUID.fromString(((String)object).substring(1, 37));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MLogger.exception(illegalArgumentException);
                MLogger.error("plugin", "%s: Invalid ID: \"%s\"", string2, object);
                return false;
            }
            PluginInfo pluginInfo = null;
            if (!bl && ("{4cdd28f0-a52d-4b36-b818-154503b54cd2}".equals(object) && !MLogger.isDeveloper() || "{9afcf313-d31d-4d23-ba63-24451a691552}".equals(object) || "{d6c65f19-8899-48ac-993a-351742dae134}".equals(object))) {
                MLogger.warning("plugin", "Disabling old plugin: \"%s\"", object);
                return false;
            }
            if (this.idMap.containsKey(object)) {
                MLogger.error("plugin", "Duplicate ID: \"%s\"", object);
                return false;
            }
            Config config2 = Config.getDefault();
            String string3 = config.read("className", null);
            pluginInfo = new PluginInfo((String)object, string3, bl);
            pluginInfo.setPath(string);
            pluginInfo.test.set(bl2);
            VersionProperty versionProperty = MApplication.getInternalVersion();
            if (bl) {
                pluginInfo.version.set(versionProperty.get());
            } else {
                try {
                    pluginInfo.version.parse(config.read("version", null));
                }
                catch (ParseException parseException) {
                    MLogger.exception(parseException);
                }
            }
            if (!bl) {
                if ("{93bc8b06-f015-4797-89c5-3fa2c2ab8975}".equals(object)) {
                    return false;
                }
                if ("{3fc7350b-c598-4362-9ca5-8cd1c1e8780c}".equals(object) && (Integer)pluginInfo.version.get() < 393216) {
                    MLogger.warning("plugin", "Disabling old Substance Look And Feel plugin (please upgrade): \"%s\"", object);
                    return false;
                }
                if ("{ffe67edc-578a-49a3-8da1-68a6cf2cbc0e}".equals(object) && (Integer)pluginInfo.version.get() <= 262148) {
                    MLogger.warning("plugin", "Disabling old A03 Look And Feel plugin (please upgrade): \"%s\"", object);
                    return false;
                }
            }
            if (!PluginManager.readConfig(config, config2, pluginInfo)) {
                return false;
            }
            try {
                pluginInfo.requires.parse(config.read("requires", versionProperty.toString()));
            }
            catch (ParseException parseException) {
                MLogger.exception(parseException);
                pluginInfo.requires.set(versionProperty.get());
            }
            pluginInfo.compatible = bl ? true : (pluginInfo.isSimple() ? true : PluginInfo.isCompatible(pluginInfo.requires));
            if (!flags.isSet(4L) && !pluginInfo.isCompatible()) {
                if ((Integer)pluginInfo.requires.get() <= (Integer)versionProperty.get()) {
                    MLogger.error("plugin", "This plugin is not compatible: %s", pluginInfo.name);
                } else {
                    MLogger.error("plugin", "This plugin requires Makagiga in version %s or later: %s", pluginInfo.requires, pluginInfo.name);
                }
                pluginInfo.enabled.no();
            }
            boolean bl3 = false;
            String string4 = null;
            if (TK.isEmpty(string3)) {
                string4 = config.read("scriptName", null);
                if (string4 == null) {
                    string3 = "Plugin";
                } else {
                    bl3 = true;
                }
            }
            String string5 = null;
            if (!bl3) {
                string5 = bl ? (string3.contains(".") ? this.toClassPath(string3) : this.toClassPath(FS.makePath(string, string3))) : this.toClassPath(string3);
            }
            if (!bl && config2.read("Plugin.remove." + pluginInfo.getID(), false)) {
                MLogger.info("plugin", "Removing plugin: \"%s\"", pluginInfo);
                boolean bl4 = false;
                if (string4 != null && !this.deletePluginData(pluginInfo, FS.makePath(pluginInfo.getPath(), string4))) {
                    bl4 = true;
                }
                if (!this.deletePluginData(pluginInfo, FS.makePath(pluginInfo.getPath(), "icon.png"))) {
                    bl4 = true;
                }
                if (!this.deletePluginData(pluginInfo, FS.makePath(pluginInfo.getPath(), "i18n.jar"))) {
                    bl4 = true;
                }
                if (!this.deletePluginData(pluginInfo, FS.makePath(pluginInfo.getPath(), "plugin.jar"))) {
                    bl4 = true;
                }
                if (!this.deletePluginData(pluginInfo, FS.makePath(pluginInfo.getPath(), "plugin.properties"))) {
                    bl4 = true;
                }
                if (!this.deletePluginData(pluginInfo, FS.makePath(pluginInfo.getPath(), "LICENSE.txt"))) {
                    bl4 = true;
                }
                StringList stringList = new StringList();
                for (Object iterator : config.getProperties().keySet()) {
                    String exception;
                    String string6 = iterator.toString();
                    if (!string6.equals("String.libs") && !string6.startsWith("String.libs@") || TK.isEmpty(exception = config.getProperties().getProperty(string6))) continue;
                    stringList.addAll(TK.fastSplit(exception, ' '));
                }
                String string8 = config.read("resources", null);
                if (!TK.isEmpty(string8)) {
                    stringList.add(string8);
                }
                for (String string6 : stringList) {
                    if (this.deletePluginData(pluginInfo, FS.makePath(pluginInfo.getPath(), string6), true)) continue;
                    bl4 = true;
                }
                if (!this.deletePluginData(pluginInfo, pluginInfo.getPath() + File.separator, false)) {
                    bl4 = true;
                }
                if (bl4) {
                    MLogger.error("plugin", "Could not remove all plugin files");
                }
                config2.removeBoolean("Plugin.remove." + pluginInfo.getID());
                config2.sync();
                return true;
            }
            this.idMap.put((String)object, pluginInfo);
            if (!((Boolean)pluginInfo.enabled.get()).booleanValue()) {
                this.table.add(pluginInfo);
                return true;
            }
            MArrayList<URL> mArrayList = new MArrayList<URL>(3);
            String string9 = Config.getPlatformKey("libs");
            this.addLibs(pluginInfo, mArrayList, config.read("libs", null));
            this.addLibs(pluginInfo, mArrayList, config.read(string9, null));
            String string10 = OS.getArch();
            if (!"unknown".equals(string10)) {
                this.addLibs(pluginInfo, mArrayList, config.read(string9 + "-" + string10, null));
            }
            if (bl3) {
                pluggable = new ScriptPlugin(string4);
            } else {
                try {
                    void var19_32;
                    Object object2;
                    if (bl) {
                        Class<?> clazz = this.getClass().getClassLoader().loadClass(string5);
                    } else {
                        mArrayList.add(0, FS.toURL(string + "/plugin.jar"));
                        if (pluginInfo.type.equalsValue(PluginType.LOOK_AND_FEEL.getType())) {
                            for (URL uRL : mArrayList) {
                                AbstractPlugin.addToSystemClassPath(uRL);
                            }
                        }
                        object2 = PluginClassLoader.create(pluginInfo.getID(), mArrayList.toArray(URL.class));
                        ((PluginClassLoader)object2).pluginInfo = pluginInfo;
                        Class<?> clazz = ((ClassLoader)object2).loadClass(string5);
                    }
                    object2 = var19_32.newInstance();
                    if (!(object2 instanceof Pluggable)) {
                        throw new PluginException("Plugin \"" + string5 + "\" does not implement Pluggable interface");
                    }
                    pluggable = (Pluggable)object2;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    MLogger.exception(noClassDefFoundError);
                    return false;
                }
                catch (Exception exception) {
                    MLogger.exception(exception);
                    return false;
                }
            }
            pluginInfo.setPluggable(pluggable);
            if (!bl) {
                Gettext.addCatalogFromProperties(pluginInfo.getPath());
            }
            pluggable.onInit(config, pluginInfo);
            pluginInfo.loaded.yes();
            this.table.add(pluginInfo);
            return true;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            MLogger.exception(throwable);
            MLogger.error("plugin", throwable.toString());
            return false;
        }
    }

    private String toClassPath(String string) {
        return string.replace('/', '.').replace('\\', '.');
    }

    private static final class InstallButton
    extends MLinkButton {
        private final List<Tuple.Two<String, String>> installList;

        @Override
        protected MMenu onPopupMenu() {
            MMenu mMenu = new MMenu();
            for (final Tuple.Two<String, String> two : this.installList) {
                mMenu.add(new MDataAction<String>(two.get2(), UI._("Install {0}", two.get1()), "ui/download"){

                    @Override
                    public void onAction() {
                        if (PluginDownloader.install(this.getSourceWindow(), PluginDownloader.getDefaultSource(), (String)this.getData())) {
                            InstallButton.this.installList.remove(two);
                            InstallButton.this.setVisible(!InstallButton.this.installList.isEmpty());
                        }
                    }
                });
            }
            return mMenu;
        }

        private InstallButton(List<Tuple.Two<String, String>> list) {
            this.installList = list;
            this.setPopupMenuEnabled(true);
            PluginManager.setupGetMorePluginsButton(this);
        }
    }

    public static final class Table
    extends TreeSet<PluginInfo> {
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }
}

