/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.search;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MTreeModel;
import org.makagiga.commons.MV;
import org.makagiga.commons.Property;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSQuery;
import org.makagiga.fs.MetaInfo;
import org.makagiga.search.Hit;
import org.makagiga.search.Index;
import org.makagiga.search.SortComparator;
import org.makagiga.search.SortMethod;
import org.makagiga.tags.Tags;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.Tree;

public final class Query {
    private boolean filterTree;
    private boolean processSearchFS = true;
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String BOOKMARK = "bookmark";
    public static final String CATEGORY = "category";
    public static final String ICON = "icon";
    public static final String KEYWORDS = "keywords";
    public static final String RATING = "rating";
    public static final String TAG = "tag";
    public static final String TYPE = "type";
    public static final Boolean YES = true;
    public static final Boolean NO = false;
    public static final int SCORE_NOT_FOUND = 0;
    public static final int SCORE_BEST = 100;
    private boolean allVisible;
    private boolean matchAll;
    private Hits list;
    private final Map<String, Criterium> criteria = TK.newLinkedHashMap();
    private SortMethod sortMethod;

    @Deprecated
    public Query() {
        this(false, SortMethod.DEFAULT);
    }

    public Query(SortMethod sortMethod) {
        this(false, sortMethod);
    }

    @Deprecated
    public Query(String string) {
        this(string, SortMethod.DEFAULT);
    }

    public Query(String string, SortMethod sortMethod) {
        this(false, sortMethod);
        this.parse(string);
    }

    public void add(String string, Object object) {
        this.add(string, Operator.EQUALS, object);
    }

    public void add(String string, Operator operator, Object object) {
        this.criteria.put(string, new Criterium(operator, object));
    }

    public void add(String string, Operator operator, String[] stringArray) {
        this.add(string, operator, new StringList(stringArray));
    }

    @Deprecated
    public static Hits all() {
        return Query.all(SortMethod.DEFAULT);
    }

    public static Hits all(SortMethod sortMethod) {
        Query query = new Query(true, sortMethod);
        return query.start();
    }

    public Map<String, Criterium> getCriteria() {
        return this.criteria;
    }

    public boolean isAllVisible() {
        return this.allVisible;
    }

    public boolean matchesKeywords(MetaInfo metaInfo, Criterium criterium) {
        StringList stringList = criterium.getKeywords();
        for (String string : stringList) {
            if (this.matchesKeyword(metaInfo, string) == 0) continue;
            return true;
        }
        return false;
    }

    public void setFilterTree(boolean bl) {
        this.filterTree = bl;
    }

    public void setProcessSearchFS(boolean bl) {
        this.processSearchFS = bl;
    }

    public Hits sort(SortMethod sortMethod) {
        this.list.sort(SortComparator.create(sortMethod));
        return this.list;
    }

    public Hits start() {
        Tree tree = Tree.getInstance();
        final BooleanProperty booleanProperty = new BooleanProperty();
        final ArrayList arrayList = new ArrayList();
        this.allVisible = true;
        this.list = new Hits();
        for (final AbstractFS object : tree.getFileSystems().values()) {
            booleanProperty.set("trash".equals(object.getID()));
            new Tree.Scanner(object){

                @Override
                public void processItem(MetaInfo metaInfo) {
                    if (this.isSearchFS(object) && !Query.this.processSearchFS || metaInfo.isLink()) {
                        return;
                    }
                    int n = Query.this.matches(metaInfo, (Boolean)booleanProperty.get());
                    if (n == 0 && object instanceof FSQuery) {
                        n = ((FSQuery)FSQuery.class.cast(object)).matches(Query.this, metaInfo);
                    }
                    if (n != 0) {
                        Hit hit = new Hit(metaInfo, n);
                        if (!Query.this.list.contains(hit)) {
                            Query.this.list.add(hit);
                            if (Query.this.filterTree) {
                                metaInfo.setVisible(true);
                            }
                        }
                    } else if (Query.this.filterTree) {
                        Query.this.allVisible = false;
                        metaInfo.setVisible(false);
                    }
                }

                @Override
                public void processParent(MetaInfo metaInfo) {
                    if (!Query.this.filterTree) {
                        return;
                    }
                    if (this.isSearchFS(object) && !Query.this.processSearchFS) {
                        return;
                    }
                    if (!metaInfo.isFSRoot()) {
                        if (!metaInfo.isEmpty(MV.VIEW) || Query.this.list.contains(new Hit(metaInfo, 100))) {
                            metaInfo.setVisible(true);
                            arrayList.add(metaInfo);
                        } else {
                            Query.this.allVisible = false;
                            metaInfo.setVisible(false);
                        }
                    }
                    metaInfo.reload();
                }

                private boolean isSearchFS(AbstractFS abstractFS) {
                    return abstractFS != null && "search".equals(abstractFS.getID());
                }
            };
        }
        if (this.filterTree) {
            if (this.allVisible || this.list.isEmpty()) {
                ((MTreeModel)tree.getModel()).setAllVisible(true);
            }
            for (MetaInfo metaInfo : arrayList) {
                tree.setExpanded(metaInfo, true);
            }
        }
        if (this.sortMethod != SortMethod.UNSORTED) {
            this.sort(this.sortMethod);
        }
        return this.list;
    }

    private Query(boolean bl, SortMethod sortMethod) {
        this.matchAll = bl;
        this.sortMethod = sortMethod;
    }

    private int matches(MetaInfo metaInfo, boolean bl) {
        if (this.matchAll) {
            return 100;
        }
        CategoryList categoryList = null;
        Tags tags = null;
        boolean bl2 = this.criteria.containsKey(OR);
        int n = 0;
        for (Map.Entry<String, Criterium> entry : this.criteria.entrySet()) {
            Object object;
            String string = entry.getKey();
            Criterium criterium = entry.getValue();
            if (AND.equals(string)) {
                n = 0;
                continue;
            }
            if (criterium.isNull()) continue;
            if (string.equals(BOOKMARK)) {
                if (!bl && criterium.matches(metaInfo.isBookmark())) {
                    n = 100;
                }
            } else if (string.equals(CATEGORY)) {
                if (!bl) {
                    if (categoryList == null) {
                        categoryList = metaInfo.getCategoryList();
                    }
                    if (categoryList != null) {
                        for (Object object2 : categoryList) {
                            if (!criterium.matches(((Category)object2).getName())) continue;
                            n = 100;
                            break;
                        }
                    }
                }
            } else if (string.equals(ICON)) {
                object = metaInfo.getIconName();
                if (object != null && criterium.matches(object)) {
                    n = 100;
                }
            } else if (string.equals(RATING)) {
                if (criterium.matches(Float.valueOf(metaInfo.getRating()))) {
                    n = 100;
                }
            } else if (string.equals(TAG)) {
                if (!bl) {
                    if (tags == null) {
                        tags = TagsUtils.removeDuplicates(metaInfo.getTags());
                    }
                    if (criterium.matches("")) {
                        if (tags.isEmpty()) {
                            n = 100;
                        }
                    } else {
                        for (Object object2 : tags) {
                            if (!criterium.matches(object2)) continue;
                            n = 100;
                            break;
                        }
                    }
                }
            } else if (string.equals(TYPE)) {
                object = metaInfo.getExtension();
                if (object != null && criterium.matches(object)) {
                    n = 100;
                }
            } else if (string.equals(KEYWORDS) && this.matchesKeywords(metaInfo, criterium)) {
                n = 100;
            }
            if (n == 0) {
                if (!bl2) break;
                continue;
            }
            if (!bl2) continue;
            break;
        }
        return n;
    }

    private int matchesKeyword(MetaInfo metaInfo, String string) {
        if (TK.containsIgnoreCase(metaInfo.toString(), string)) {
            return 100;
        }
        String string2 = metaInfo.getParentFolder().toString();
        if (TK.containsIgnoreCase(string2, string)) {
            return 70;
        }
        if (TK.containsIgnoreCase(metaInfo.getCategories(), string)) {
            return 60;
        }
        if (TK.containsIgnoreCase(metaInfo.getComment(), string)) {
            return 80;
        }
        if (Index.getInstance().containsIgnoreCase(metaInfo, string)) {
            return 90;
        }
        if (TK.containsIgnoreCase(metaInfo.getTags(), string)) {
            return 60;
        }
        return 0;
    }

    private void parse(String string) {
        List<String> list;
        if (string == null) {
            return;
        }
        try {
            list = TK.parseArguments(string);
        }
        catch (ParseException parseException) {
            return;
        }
        StringList stringList = new StringList();
        for (String string2 : list) {
            String string3;
            String string4;
            if (AND.equals(string2)) {
                this.add(AND, null);
                continue;
            }
            int n = string2.indexOf(61);
            if (n == -1) {
                string4 = null;
                string3 = null;
                stringList.add(string2);
                continue;
            }
            string4 = string2.substring(0, n);
            if ("".equals(string4)) {
                string4 = null;
            }
            if ("".equals(string3 = string2.substring(n + 1))) {
                string3 = null;
            }
            if (BOOKMARK.equals(string4)) {
                if (string3 == null) continue;
                this.add(BOOKMARK, Boolean.valueOf(string3));
                continue;
            }
            if (RATING.equals(string4)) {
                try {
                    if (string3 == null) continue;
                    this.add(RATING, Float.valueOf(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    MLogger.exception(numberFormatException);
                }
                continue;
            }
            if (!CATEGORY.equals(string4) && !ICON.equals(string4) && !TAG.equals(string4) && !TYPE.equals(string4) || string3 == null) continue;
            this.add(string4, string3);
        }
        if (!stringList.isEmpty()) {
            this.add(KEYWORDS, Operator.CONTAINS_IGNORE_CASE, stringList.toArray());
        }
    }

    public static final class Hits
    extends MArrayList<Hit> {
    }

    public static final class Criterium
    extends Property<Object> {
        private Object[] values;
        private final Operator operator;

        public Criterium(Operator operator, Object object) {
            super(object);
            this.operator = operator;
            if (object instanceof String) {
                this.values = TK.fastSplit(object.toString(), '|').toArray();
                if (this.values.length == 0) {
                    this.values = new Object[]{""};
                }
            } else {
                this.values = new Object[1];
                this.values[0] = object;
            }
        }

        public StringList getKeywords() {
            return (StringList)this.get();
        }

        public boolean matches(Object object) {
            block4: for (Object object2 : this.values) {
                switch (this.operator) {
                    case CONTAINS_IGNORE_CASE: {
                        if (!TK.containsIgnoreCase(object2.toString(), object.toString())) continue block4;
                        return true;
                    }
                    case EQUALS: {
                        if (!object2.equals(object)) continue block4;
                        return true;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
                    }
                }
            }
            return false;
        }
    }

    public static enum Operator {
        CONTAINS_IGNORE_CASE,
        EQUALS;

    }
}

