/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.search;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Item;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIconChooser;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMultiPanel;
import org.makagiga.commons.MRating;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginType;
import org.makagiga.search.Query;
import org.makagiga.search.SortMethod;
import org.makagiga.tags.Tags;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.Tree;

public class QueryEditor
extends MMultiPanel<SelectionItem> {
    private QueryCategory defaultCategory = Config.getDefault().readEnum("Search.category", this.defaultCategory);

    public QueryEditor(String string) {
        Query query = new Query(string, SortMethod.UNSORTED);
        for (Map.Entry<String, Query.Criterium> entry : query.getCriteria().entrySet()) {
            String string2 = entry.getKey();
            Query.Criterium criterium = entry.getValue();
            if ("category".equals(string2)) {
                this.addItem(new SelectionItem(QueryCategory.CATEGORY, criterium.get()));
                continue;
            }
            if ("icon".equals(string2)) {
                this.addItem(new SelectionItem(QueryCategory.ICON, criterium.get()));
                continue;
            }
            if ("keywords".equals(string2)) {
                this.addItem(new SelectionItem(QueryCategory.KEYWORDS, criterium.getKeywords()));
                continue;
            }
            if ("rating".equals(string2)) {
                this.addItem(new SelectionItem(QueryCategory.RATING, criterium.get()));
                continue;
            }
            if ("tag".equals(string2)) {
                this.addItem(new SelectionItem(QueryCategory.TAGS, criterium.get()));
                continue;
            }
            if (!"type".equals(string2)) continue;
            this.addItem(new SelectionItem(QueryCategory.TYPE, criterium.get()));
        }
        if (this.isEmpty()) {
            this.addItem(this.createDefaultItem());
        }
    }

    public static String getQuery(Window window, String string) {
        boolean bl;
        int n = 7;
        boolean bl2 = bl = Tree.getInstance().getFS("search") != null;
        if (bl) {
            n |= 8;
        }
        Dialog dialog = new Dialog(window, n, string);
        if (bl) {
            dialog.changeButton((AbstractButton)dialog.getUserButton(), MActionInfo.SAVE_AS);
        }
        if (dialog.exec()) {
            return dialog.queryEditor.getQuery();
        }
        return null;
    }

    public void saveConfig() {
        SelectionItem selectionItem = (SelectionItem)this.getItems().get(0);
        this.defaultCategory = (QueryCategory)((Object)((Item)selectionItem.categorySelection.getSelectedItem()).getValue());
        Config config = Config.getDefault();
        config.write("Search.category", this.defaultCategory);
        config.sync();
    }

    @Deprecated
    public static void setupTextFieldPanel(MTextFieldPanel mTextFieldPanel) {
        mTextFieldPanel.getMenuButton().setPopupMenuArrowPainted(false);
        mTextFieldPanel.getMenuButton().setToolTipText(UI._("Select search options"));
        mTextFieldPanel.setAutoCompletion("query");
    }

    @Override
    protected SelectionItem onAddItem(MButton mButton) {
        return this.createDefaultItem();
    }

    private void append(StringBuilder stringBuilder, String string, Object object) {
        if (object == null) {
            return;
        }
        String string2 = object.toString();
        string2 = this.escape(string2);
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append(string).append("=\"").append(string2).append('\"');
    }

    private SelectionItem createDefaultItem() {
        return new SelectionItem(this.defaultCategory, null);
    }

    private String escape(String string) {
        return string.replace("\"", "\\\"");
    }

    private String getQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (SelectionItem selectionItem : this.getItems()) {
            QueryCategory queryCategory = (QueryCategory)((Object)((Item)selectionItem.categorySelection.getSelectedItem()).getValue());
            switch (queryCategory) {
                case CATEGORY: {
                    CategorySelection categorySelection = (CategorySelection)selectionItem.valueSelection;
                    String string = (String)((Item)categorySelection.getSelectedItem()).getValue();
                    this.append(stringBuilder, "category", string);
                    continue block8;
                }
                case TAGS: {
                    TagsSelection tagsSelection = (TagsSelection)selectionItem.valueSelection;
                    String string = (String)((Item)tagsSelection.getSelectedItem()).getValue();
                    this.append(stringBuilder, "tag", string);
                    continue block8;
                }
                case RATING: {
                    RatingSelection ratingSelection = (RatingSelection)selectionItem.valueSelection;
                    float f = ratingSelection.getValue();
                    this.append(stringBuilder, "rating", Float.valueOf(f));
                    continue block8;
                }
                case ICON: {
                    IconSelection iconSelection = (IconSelection)selectionItem.valueSelection;
                    String string = (String)((Item)iconSelection.getSelectedItem()).getValue();
                    this.append(stringBuilder, "icon", string);
                    continue block8;
                }
                case TYPE: {
                    TypeSelection typeSelection = (TypeSelection)selectionItem.valueSelection;
                    String string = (String)((Item)typeSelection.getSelectedItem()).getValue();
                    this.append(stringBuilder, "type", string);
                    continue block8;
                }
                case KEYWORDS: {
                    KeywordsSelection keywordsSelection = (KeywordsSelection)selectionItem.valueSelection;
                    keywordsSelection.saveAutoCompletion();
                    String string = keywordsSelection.getText();
                    if (TK.isEmpty(string)) continue block8;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" AND ");
                    }
                    stringBuilder.append(this.escape(string));
                    continue block8;
                }
            }
            throw new WTFError(queryCategory);
        }
        return stringBuilder.toString();
    }

    private boolean saveQuery(Window window) {
        Tree tree = Tree.getInstance();
        AbstractFS abstractFS = tree.getFS("search");
        if (abstractFS == null) {
            return false;
        }
        String string = this.getQuery();
        String string2 = MMessage.input(window, string, UI._("Folder Name:"), MActionInfo.SAVE_AS.getDialogTitle(), MActionInfo.SAVE_AS.getIconName(), "rename");
        if (string2 == null) {
            return false;
        }
        MetaInfo metaInfo = abstractFS.getRoot();
        string2 = FSHelper.getUniqueName(metaInfo.getTargetPath(), string2, "properties");
        MetaInfo metaInfo2 = abstractFS.addDynamicFolder(metaInfo, string2 = FSHelper.removePropertiesSuffix(string2));
        if (metaInfo2 == null) {
            return false;
        }
        Config config = metaInfo2.getConfig();
        config.write("x.query", string);
        metaInfo2.sync();
        metaInfo.reload();
        tree.selectItem(metaInfo2, true);
        return true;
    }

    private static final class TypeSelection
    extends AbstractComboBoxSelection<String> {
        private TypeSelection(String string) {
            PluginManager.Table table = PluginType.EDITOR.get();
            if (string != null) {
                this.addItem(new Item<String>(string, string));
            }
            if (table.isEmpty()) {
                if (this.isEmpty()) {
                    this.addItem(new Item<Object>(null, UI._("No File Types")));
                    this.setEnabled(false);
                }
            } else {
                for (PluginInfo pluginInfo : table) {
                    StringBuilder stringBuilder = new StringBuilder();
                    EditorPlugin editorPlugin = (EditorPlugin)pluginInfo.getPluggable();
                    for (EditorPlugin.FileType fileType : editorPlugin.getFileTypes()) {
                        for (String string2 : fileType.getExtensions()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append('|');
                            }
                            stringBuilder.append(string2);
                        }
                    }
                    Item<String> item = new Item<String>(stringBuilder.toString(), editorPlugin.getDocumentDisplayName());
                    item.setIcon(pluginInfo.getIcon());
                    this.addItem(item);
                }
            }
            this.selectValue(string);
        }
    }

    private static final class TagsSelection
    extends AbstractComboBoxSelection<String> {
        private TagsSelection(String string) {
            if (string != null) {
                this.addItem(new Item<String>(string, string));
            }
            for (String string2 : Tags.getAll()) {
                String string3;
                if (string2.equals(string3 = TagsUtils.getLocalizedText(string2))) {
                    this.addItem(new Item<String>(string2, string2));
                    continue;
                }
                this.addItem(new Item<String>(string2, string2 + " (" + string3 + ")"));
            }
            if (this.isEmpty()) {
                this.addItem(new Item<String>("", UI._("No Tags")));
                this.setEnabled(false);
            }
            this.selectValue(string);
        }
    }

    private static final class RatingSelection
    extends MRating {
        private RatingSelection(Float f) {
            super(f == null ? 0.0f : f.floatValue());
            this.setClearButtonVisible(true);
        }
    }

    private static final class QueryCategorySelection
    extends AbstractComboBoxSelection<QueryCategory> {
        private QueryCategorySelection(final SelectionItem selectionItem, QueryCategory queryCategory) {
            for (QueryCategory queryCategory2 : QueryCategory.values()) {
                Item<QueryCategory> item = new Item<QueryCategory>(queryCategory2, queryCategory2.toString());
                item.setIconName(queryCategory2.iconName);
                this.addItem(item);
            }
            this.selectValue(queryCategory);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    selectionItem.setValueSelection((QueryCategory)((Object)((Item)QueryCategorySelection.this.getSelectedItem()).getValue()), null);
                }
            });
        }
    }

    private static final class KeywordsSelection
    extends MTextField {
        private KeywordsSelection(StringList stringList) {
            this.setText(stringList == null ? null : stringList.join(" "));
            this.setAutoCompletion("query");
        }
    }

    private static final class IconSelection
    extends AbstractComboBoxSelection<String> {
        private IconSelection(String string) {
            for (MIconChooser.IconItem iconItem : MIconChooser.getStockIcons()) {
                String string2 = (String)iconItem.getValue();
                string2 = FS.getBaseName(string2);
                Item<String> item = new Item<String>(string2, iconItem.getText());
                item.setIcon(iconItem.getIcon());
                this.addItem(item);
            }
            this.selectValue(string);
        }
    }

    private static final class Dialog
    extends MDialog {
        private final QueryEditor queryEditor;

        @Override
        protected boolean onAccept() {
            this.queryEditor.saveConfig();
            return true;
        }

        @Override
        protected void onUserClick() {
            if (this.queryEditor.saveQuery(this)) {
                this.reject();
            }
        }

        private Dialog(Window window, int n, String string) {
            super(window, MActionInfo.SEARCH, n);
            this.changeButton((AbstractButton)this.getOKButton(), MActionInfo.SEARCH.getDialogTitle(), MActionInfo.SEARCH.getIconName());
            this.queryEditor = new QueryEditor(string);
            MScrollPane mScrollPane = new MScrollPane(this.queryEditor, 2);
            mScrollPane.setVerticalScrollBarPolicy(22);
            this.addCenter(mScrollPane);
            this.setSize(UI.WindowSize.MEDIUM);
        }
    }

    private static final class CategorySelection
    extends AbstractComboBoxSelection<String> {
        private CategorySelection(String string) {
            for (Category category : CategoryManager.getSharedInstance().getCategorySet()) {
                Item<String> item = new Item<String>(category.getName(), category.getName());
                item.setIcon(category.getCategoryIcon());
                this.addItem(item);
            }
            if (this.isEmpty()) {
                this.addItem(new Item<String>("", UI._("No Categories")));
                this.setEnabled(false);
            }
            this.selectValue(string);
        }
    }

    private static class AbstractComboBoxSelection<I>
    extends MComboBox<Item<I>> {
        protected void selectValue(I i) {
            if (i == null) {
                return;
            }
            for (Item item : this) {
                if (!item.getValue().equals(i)) continue;
                this.setSelectedItem(item);
                break;
            }
        }

        private AbstractComboBoxSelection() {
            this.setRenderer(Item.createListCellRenderer());
            this.setMouseWheelEventsEnabled(false);
        }
    }

    protected static final class SelectionItem
    extends MMultiPanel.PanelItem {
        private JComponent valueSelection;
        private final QueryCategorySelection categorySelection;

        private SelectionItem(QueryCategory queryCategory, Object object) {
            this.categorySelection = new QueryCategorySelection(this, queryCategory);
            this.valueSelection = new MComponent();
            this.setGroupLayout(true);
            this.getGroupLayout().setDefaultVerticalAlignment(GroupLayout.Alignment.CENTER);
            this.getGroupLayout().addComponent(this.categorySelection).addComponent(MLabel.createSmall("=", null)).addHStretchComponent(this.valueSelection);
            this.setValueSelection(queryCategory, object);
        }

        private void setValueSelection(QueryCategory queryCategory, Object object) {
            JComponent jComponent = this.valueSelection;
            switch (queryCategory) {
                case CATEGORY: {
                    this.valueSelection = new CategorySelection((String)object);
                    break;
                }
                case TAGS: {
                    this.valueSelection = new TagsSelection((String)object);
                    break;
                }
                case RATING: {
                    this.valueSelection = new RatingSelection((Float)object);
                    break;
                }
                case ICON: {
                    this.valueSelection = new IconSelection((String)object);
                    break;
                }
                case TYPE: {
                    this.valueSelection = new TypeSelection((String)object);
                    break;
                }
                case KEYWORDS: {
                    this.valueSelection = new KeywordsSelection((StringList)object);
                    break;
                }
                default: {
                    throw new WTFError(queryCategory);
                }
            }
            this.getGroupLayout().replace(jComponent, this.valueSelection);
        }
    }

    private static enum QueryCategory {
        CATEGORY(UI._("Category"), "ui/misc"),
        TAGS(UI._("Tags"), "ui/misc"),
        RATING(UI._("Rating"), "ui/star"),
        ICON(UI._("Icon"), "labels/emotion/happy"),
        TYPE(UI._("File Type"), "ui/file"),
        KEYWORDS(UI._("Keywords"), "ui/misc");

        private String iconName;
        private String text;

        public String toString() {
            return this.text;
        }

        private QueryCategory(String string2, String string3) {
            this.text = string2;
            this.iconName = string3;
        }
    }
}

