/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tags;

import java.util.TreeSet;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.fs.MetaInfo;
import org.makagiga.search.Hit;
import org.makagiga.search.Query;
import org.makagiga.search.SortMethod;
import org.makagiga.tags.TagsUtils;

public final class Tags
extends TreeSet<String> {
    private static boolean needUpdate = true;
    private static Tags all = new Tags();

    public Tags() {
        super(TagsUtils.COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addAll(String string) {
        Tags tags;
        if (TK.isEmpty(string) || (tags = TagsUtils.removeDuplicates(string)).isEmpty()) return;
        Class<Tags> clazz = Tags.class;
        synchronized (Tags.class) {
            all.addAll(tags);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        MLogger.debug("tags", "Clearing tag cache...");
        Class<Tags> clazz = Tags.class;
        synchronized (Tags.class) {
            all.clear();
            needUpdate = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized Tags getAll() {
        if (all.isEmpty() && needUpdate) {
            MLogger.debug("tags", "Recreating tag cache...");
            for (Hit hit : Query.all(SortMethod.UNSORTED)) {
                MetaInfo metaInfo = (MetaInfo)hit.get();
                if (!metaInfo.isAnyFile() && !metaInfo.isAnyFolder()) continue;
                all.addAll(TagsUtils.removeDuplicates(metaInfo.getTags()));
            }
            needUpdate = false;
        } else {
            MLogger.debug("tags", "Using cached tags... (size=%s)", all.size());
        }
        return all;
    }

    @Override
    public String toString() {
        return TK.toString(this, " ");
    }
}

