/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tags;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MTip;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.tags.Tags;
import org.makagiga.tags.TagsUtils;

public class TagsEditor
extends MTextFieldPanel {
    private boolean modified;
    private MTip tip;

    public TagsEditor() {
        this(new Tags());
    }

    public TagsEditor(Tags tags) {
        super(tags.toString());
        MTextField mTextField = this.getTextField();
        Font font = mTextField.getFont();
        int n = font == null ? UI.getDefaultFontSize() : font.getSize();
        mTextField.setFont(UI.createMonospacedFont(n));
        this.setAutoCompletion("tags");
        UI.setHTMLHelp(mTextField, UI._("A space separated list of one-word tags.<br>You can assign tags to any file or folder.<br><br>Example: <code>blog todo java priority:HIGH</code>"));
        mTextField.getDocument().addDocumentListener(new MDocumentAdapter<MTextField>(){

            @Override
            public void onChange(DocumentEvent documentEvent) {
                MTextField mTextField = TagsEditor.this.getTextField();
                TagsEditor.this.modified = true;
                if (mTextField.getText().contains(",")) {
                    TagsEditor.this.tip.setColor(MHighlighter.DEFAULT_COLOR, Color.BLACK, true);
                }
            }
        });
        this.getMenuButton().setToolTipText(UI._("Add/Remove Tags"));
        this.tip = new MTip(TagsEditor.class.getName());
        this.tip.showNextTip();
        this.addSouth(this.tip);
        AutoCompletion autoCompletion = mTextField.getAutoCompletion();
        autoCompletion.caseSensitive.yes();
        autoCompletion.setMode(AutoCompletion.Mode.CURRENT_WORD);
        this.updateAutoCompletion();
        this.setLabel(UI._("Tags:"));
        this.modified = false;
    }

    public static MMenu createPopupMenu(final TagListener tagListener) {
        MMenu mMenu = new MMenu();
        mMenu.setSplitMenu(true);
        mMenu.addTitle(UI._("Add/Remove Tags"));
        Tags tags = Tags.getAll();
        if (tags.isEmpty()) {
            mMenu.addTitle(UI._("No Tags"));
            return mMenu;
        }
        Tags tags2 = tagListener.getCurrentTags();
        for (String string : tags) {
            TagAction tagAction = new TagAction(string){

                @Override
                public void onTag() {
                    Tags tags = tagListener.getCurrentTags();
                    if (this.isSelected()) {
                        tags.add(this.getTag());
                        tagListener.onTagChange(this.getTag(), true);
                    } else {
                        tags.remove(this.getTag());
                        tagListener.onTagChange(this.getTag(), false);
                    }
                }
            };
            mMenu.add(TagsEditor.createTagCheckBoxMenuItem(tagAction, tags2.contains(string)));
        }
        return mMenu;
    }

    public static JCheckBoxMenuItem createTagCheckBoxMenuItem(TagAction tagAction, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(tagAction);
        if (bl) {
            tagAction.setSelected(true);
            UI.setStyle("font-weight: bold", jCheckBoxMenuItem);
        }
        return jCheckBoxMenuItem;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height + (this.tip.isVisible() ? this.tip.getPreferredSize().height : 0));
    }

    public Tags getTags() {
        return TagsUtils.removeDuplicates(this.getText());
    }

    public void setTags(Tags tags) {
        this.setText(tags.toString());
    }

    public MTip getTip() {
        return this.tip;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.getLabelComponent().setEnabled(bl);
    }

    public void updateAutoCompletion() {
        AutoCompletion autoCompletion = this.getTextField().getAutoCompletion();
        for (String string : Tags.getAll()) {
            autoCompletion.addItem(string);
        }
    }

    @Override
    protected MMenu onPopupMenu() {
        return TagsEditor.createPopupMenu(new TagListener(){

            @Override
            public Tags getCurrentTags() {
                return TagsEditor.this.getTags();
            }

            @Override
            public void onTagChange(String string, boolean bl) {
                Tags tags = this.getCurrentTags();
                if (bl) {
                    tags.add(string);
                } else if (string == null) {
                    tags.clear();
                } else {
                    tags.remove(string);
                }
                TagsEditor.this.setTags(tags);
            }
        });
    }

    @Override
    protected void updateClearButton(boolean bl) {
        super.updateClearButton(bl);
        this.getClearButton().setVisible(false);
    }

    public static interface TagListener {
        public Tags getCurrentTags();

        public void onTagChange(String var1, boolean var2);
    }

    public static abstract class TagAction
    extends MAction {
        private boolean set;
        private final String tag;

        public TagAction(String string) {
            super(string);
            this.tag = string;
        }

        public String getTag() {
            return this.tag;
        }

        @Override
        public final void onAction() {
            this.setSelected(!this.set);
            this.onTag();
        }

        public abstract void onTag();

        @Override
        public void setSelected(boolean bl) {
            super.setSelected(bl);
            this.set = bl;
        }
    }
}

