/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.Color;
import javax.swing.Icon;
import org.makagiga.commons.MColorIcon;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.UI;

public enum Priority {
    VERY_LOW(UI._("Very Low"), 11786751, null),
    LOW(UI._("Low"), 14286771, null),
    NORMAL(UI._("Normal"), null),
    HIGH(UI._("High"), 0xFFFFB3, "ui/warning"),
    VERY_HIGH(UI._("Very High"), 0xFFB3B3, "ui/warning");

    public static final Priority DEFAULT;
    private Color color;
    private Icon smallIcon;
    private MColorIcon smallColorIcon;
    private String name;

    public static Priority fromInt(int n) {
        for (Priority priority : Priority.values()) {
            if (n != priority.ordinal()) continue;
            return priority;
        }
        return DEFAULT;
    }

    public static Priority fromString(String string) {
        try {
            return Priority.fromInt(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            MLogger.exception(numberFormatException);
            return DEFAULT;
        }
    }

    public Color getColor() {
        return this.color;
    }

    @Deprecated
    public static Color getPrimaryColor() {
        return null;
    }

    @Deprecated
    public static void setPrimaryColor(Color color) {
    }

    public synchronized Icon getSmallColorIcon() {
        if (this.smallColorIcon == null) {
            int n = MIcon.getSmallSize();
            this.smallColorIcon = new MColorIcon(this.getColor(), n, n, MColorIcon.Type.RECTANGLE);
        }
        return this.smallColorIcon;
    }

    public Icon getSmallIcon() {
        return this.smallIcon;
    }

    public String toString() {
        return this.name;
    }

    public static Priority[] valuesReversed() {
        return new Priority[]{VERY_HIGH, HIGH, NORMAL, LOW, VERY_LOW};
    }

    private Priority(String string2, Color color) {
        this.color = color;
        this.name = string2;
    }

    private Priority(String string2, int n2, String string3) {
        this(string2, new Color(n2));
        this.smallIcon = MIcon.small(string3);
    }

    static {
        DEFAULT = NORMAL;
    }
}

