/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.util.EnumMap;
import javax.swing.Icon;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MRenderer;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskState;
import org.makagiga.todo.TaskTable;

public class SummaryRenderer
extends MRenderer<String> {
    private static EnumMap<TaskState, Icon> iconCache = new EnumMap(TaskState.class);

    public SummaryRenderer() {
        this.setHTMLEnabled(false);
    }

    @Override
    protected void onRender(String string) {
        this.setText(string);
        TaskTable taskTable = (TaskTable)this.getTable();
        Task task = (Task)((TaskModel)taskTable.getModel()).getRowAt(this.getModelRow());
        TaskState taskState = task.getDateTimeState();
        if (taskState.isImportant() && !task.isDone()) {
            Icon icon = iconCache.get((Object)taskState);
            if (icon == null && (icon = taskState.getSmallIcon()) != null) {
                icon = MIcon.getColorizedInstance(icon, MColor.GRAY);
                iconCache.put(taskState, icon);
            }
            this.getLabel().setIcon(icon);
        } else {
            this.getLabel().setIcon(null);
        }
        this.getLabel().setStrikeThrough(task.isDone());
    }
}

