/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MMenuItem;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoAction;
import org.makagiga.fs.MetaInfoComparator;
import org.makagiga.plugins.PluginManager;
import org.makagiga.search.Hit;
import org.makagiga.search.Query;
import org.makagiga.search.SortComparator;
import org.makagiga.search.SortMethod;
import org.makagiga.tree.Tree;

public final class Bookmarks {
    public static boolean canBookmark(MetaInfo metaInfo) {
        if (((Boolean)Vars.treeReadOnly.get()).booleanValue()) {
            return false;
        }
        return metaInfo != null && (metaInfo.isAnyFolder() || metaInfo.isFile()) && metaInfo.isWriteable();
    }

    public static void updateMenu(MMenu mMenu, boolean bl) {
        Serializable serializable;
        Object object;
        mMenu.removeAll();
        mMenu.setSplitMenu(true);
        if (bl) {
            object = new ToggleAction();
            ((ToggleAction)object).tree = false;
            mMenu.add((MAction)object);
            serializable = Tabs.getInstance().getCurrentMetaInfo();
            ((ToggleAction)object).update((MetaInfo)serializable);
        }
        object = new Query(SortMethod.UNSORTED);
        ((Query)object).add("OR", null);
        ((Query)object).add("bookmark", true);
        ((Query)object).add("icon", MActionInfo.ADD_STAR.getIconName() + "|labels/todo");
        serializable = ((Query)object).start();
        if (((ArrayList)serializable).isEmpty()) {
            mMenu.addTitle(UI._("No Bookmarks"));
        } else {
            mMenu.addSeparator();
            Bookmarks.groupByFolder(mMenu, (Query.Hits)serializable);
        }
        PluginManager.updateMenu(mMenu, "BOOKMARKS_MENU", false);
    }

    @Deprecated
    public static void updateMenu(MMenu mMenu) {
        Bookmarks.updateMenu(mMenu, true);
    }

    private Bookmarks() {
    }

    private static void groupByFolder(MMenu mMenu, Query.Hits hits) {
        Iterable<Hit> iterable;
        MetaInfo metaInfo;
        HashMap<MetaInfo, Query.Hits> hashMap = new HashMap<MetaInfo, Query.Hits>();
        for (Hit object : hits) {
            metaInfo = ((MetaInfo)object.get()).getParentFolder();
            if (metaInfo == null) continue;
            iterable = (Query.Hits)hashMap.get(metaInfo);
            if (iterable == null) {
                iterable = new Query.Hits();
                hashMap.put(metaInfo, (Query.Hits)iterable);
            }
            ((ArrayList)iterable).add(object);
        }
        for (final Map.Entry entry : TK.sortByKey(hashMap, MetaInfoComparator.BY_NAME).entrySet()) {
            metaInfo = (MetaInfo)entry.getKey();
            ((Query.Hits)entry.getValue()).sort(SortComparator.create(SortMethod.NAME));
            if (((Query.Hits)entry.getValue()).size() == 1) {
                Bookmarks.initFolderMenu(mMenu, entry, true);
                continue;
            }
            iterable = new MMenu(metaInfo.toString(), new MetaInfoAction.Icon(metaInfo));
            ((MMenu)iterable).setSplitMenu(true);
            ((JMenu)((Object)iterable)).addMenuListener(new MMenuAdapter(false){

                @Override
                protected void onSelect(MMenu mMenu) {
                    mMenu.removeAll();
                    Bookmarks.initFolderMenu(mMenu, entry, false);
                }
            });
            mMenu.add((JMenuItem)((Object)iterable));
        }
    }

    private static void initFolderMenu(MMenu mMenu, Map.Entry<MetaInfo, Query.Hits> entry, boolean bl) {
        int n = 0;
        for (Hit hit : entry.getValue()) {
            MetaInfo metaInfo = (MetaInfo)hit.get();
            if (metaInfo.isFile()) {
                ++n;
            }
            MMenuItem mMenuItem = mMenu.add(new MetaInfoAction(metaInfo, false){

                @Override
                public void onAction() {
                    MainWindow.getInstance().restore();
                    super.onAction();
                }
            });
            if (!metaInfo.isOpen()) continue;
            mMenuItem.setStyle("font-weight: bold");
        }
        if (bl) {
            return;
        }
        if (!mMenu.isEmpty()) {
            mMenu.addSeparator();
        }
        MetaInfoAction metaInfoAction = new MetaInfoAction(entry.getKey(), false){

            @Override
            public void onAction() {
                MainWindow.getInstance().restore();
                MetaInfo metaInfo = (MetaInfo)this.getData();
                Tree tree = Tree.getInstance();
                if (metaInfo.isFSRoot()) {
                    tree.selectItem(metaInfo, true);
                } else {
                    super.onAction();
                }
                tree.setExpanded(metaInfo, true);
            }
        };
        metaInfoAction.setName(UI._("Show This Folder"));
        mMenu.add(metaInfoAction);
        if (n > 1) {
            mMenu.addSeparator();
            mMenu.add(new Tree.OpenAllInTabsAction(mMenu){

                @Override
                protected List<MetaInfo> getFileList() {
                    MMenu mMenu = this.getParent();
                    if (mMenu == null) {
                        return null;
                    }
                    MArrayList<MetaInfo> mArrayList = new MArrayList<MetaInfo>();
                    for (JMenuItem jMenuItem : mMenu) {
                        MetaInfo metaInfo;
                        Action action;
                        if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof MetaInfoAction) || !(metaInfo = (MetaInfo)((MetaInfoAction)MetaInfoAction.class.cast(action)).getData()).isFile()) continue;
                        mArrayList.add(metaInfo);
                    }
                    return mArrayList;
                }
            });
        }
    }

    public static final class ToggleAction
    extends MAction {
        private boolean tree = true;

        @Override
        public void onAction() {
            MetaInfo metaInfo = this.tree ? this.getMetaInfo(Tree.getInstance().getSelectedItems()) : Tabs.getInstance().getCurrentMetaInfo();
            if (metaInfo == null) {
                return;
            }
            metaInfo.setBookmark(!metaInfo.isBookmark());
            metaInfo.sync();
        }

        public void setMode(Mode mode) {
            this.setEnabled(mode != Mode.NO_ITEM);
            switch (mode) {
                case ADD: 
                case NO_ITEM: {
                    this.setIconName("ui/bookmark");
                    this.setHTMLHelp(UI._("Adds the selected item to the bookmarks."));
                    this.setName(UI._("Add Bookmark"));
                    break;
                }
                case REMOVE: {
                    this.setIconName("ui/clearright");
                    this.setHTMLHelp(UI._("Removes the selected item from the bookmarks."));
                    this.setName(UI._("Remove Bookmark"));
                    break;
                }
                default: {
                    throw new WTFError(mode);
                }
            }
        }

        public void update(MetaInfo[] metaInfoArray) {
            this.update(this.getMetaInfo(metaInfoArray));
        }

        private MetaInfo getMetaInfo(MetaInfo[] metaInfoArray) {
            return metaInfoArray.length != 1 ? null : metaInfoArray[0];
        }

        private void update(MetaInfo metaInfo) {
            if (Bookmarks.canBookmark(metaInfo)) {
                this.setMode(metaInfo.isBookmark() ? Mode.REMOVE : Mode.ADD);
            } else {
                this.setMode(Mode.NO_ITEM);
            }
        }

        public static enum Mode {
            ADD,
            NO_ITEM,
            REMOVE;

        }
    }

    public static final class Menu
    extends MMenu {
        public Menu(Icon icon, final boolean bl) {
            super(UI._("&Bookmarks"), icon);
            this.addMenuListener(new MMenuAdapter(true){

                @Override
                protected void onSelect(MMenu mMenu) {
                    Bookmarks.updateMenu(mMenu, bl);
                }
            });
        }

        public Menu(Icon icon) {
            this(icon, true);
        }
    }
}

