/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import org.makagiga.MainWindow;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLineBorder;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorSearch;
import org.makagiga.search.SearchBar;
import org.makagiga.tree.PropertiesBar;

public final class EditorQuickFind
extends MToolBar {
    private boolean active;
    private boolean reset = true;
    private MCheckBox caseSensitive;
    private MSearchPanel text;
    private static String lastSearch = "";
    private static WeakReference<EditorQuickFind> _instanceRef;

    public static void autoSearch() {
        String string = SearchBar.getQuery();
        if (!string.isEmpty() && !string.contains("=")) {
            lastSearch = string;
            EditorQuickFind.getInstance().setActive(true);
        }
    }

    public void findNext() {
        if (this.reset) {
            this.resetSearch();
        }
        this.startSearch();
    }

    public static synchronized EditorQuickFind getInstance() {
        if (!EditorQuickFind.isInstance()) {
            EditorQuickFind editorQuickFind = new EditorQuickFind();
            _instanceRef = new WeakReference<EditorQuickFind>(editorQuickFind);
            return editorQuickFind;
        }
        return (EditorQuickFind)_instanceRef.get();
    }

    public static synchronized boolean isInstance() {
        return _instanceRef != null && _instanceRef.get() != null;
    }

    public void setActive(boolean bl) {
        this.setVisible(bl);
        if (bl) {
            this.resetSearch();
            this.repaint();
            this.text.makeDefault();
        } else {
            if (PropertiesBar.isInstance()) {
                MainWindow.getInstance().installTabBar(PropertiesBar.getInstance());
            }
            this.cancelSearch();
        }
        this.active = bl;
    }

    private EditorQuickFind() {
        MWhatsThis.set(this, UI._("Search in the active document")).setKeyStroke(70, MAction.getMenuMask());
        this.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.setVisible(false);
        this.showLineBorder(MLineBorder.Position.TOP);
        this.text = new MSearchPanel(){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                EditorQuickFind.this.reset = true;
                if (EditorQuickFind.this.active) {
                    EditorQuickFind.this.startSearch();
                }
            }
        };
        this.text.setAutoCompletion("find");
        this.text.setEnterPressAction(new MAction(){

            @Override
            public void onAction() {
                EditorQuickFind.this.startSearch();
            }
        });
        this.text.limitHeight();
        this.addGap();
        this.add(MLabel.createFor(this.text, UI._("Find:")));
        this.addGap();
        this.add(this.text);
        this.addGap();
        this.caseSensitive = new MCheckBox(UI._("Case sensitive")){

            @Override
            protected void onClick() {
                EditorQuickFind.this.reset = true;
                EditorQuickFind.this.startSearch();
            }
        };
        this.caseSensitive.setOpaque(false);
        this.add(this.caseSensitive);
        this.addGap();
        this.add(new FindNextAction(), 1);
        this.addStretch();
        CloseAction closeAction = new CloseAction();
        this.add(closeAction);
        this.readConfig("find-text");
        closeAction.connect((JComponent)this.text, 2);
    }

    private void cancelSearch() {
        this.text.setState(MTextFieldPanel.State.NORMAL);
        MStatusBar.ready();
        Editor<?> editor = this.getEditor();
        if (editor != null) {
            ((Component)editor.getCore()).requestFocusInWindow();
        }
    }

    private Editor<?> getEditor() {
        Editor<?> editor = Editor.getCurrentEditor();
        return editor instanceof EditorSearch ? editor : null;
    }

    private void resetSearch() {
        this.reset = true;
        this.text.setState(MTextFieldPanel.State.NORMAL);
        MStatusBar.ready();
        Editor<?> editor = this.getEditor();
        if (editor == null) {
            this.text.setText(lastSearch);
        } else {
            EditorSearch editorSearch = (EditorSearch)((Object)editor);
            Flags flags = new Flags(editorSearch.getSupportedSearchOptions());
            if (flags.isSet(1L)) {
                this.caseSensitive.setVisible(true);
            } else {
                this.caseSensitive.setSelected(false);
                this.caseSensitive.setVisible(false);
            }
            String string = SearchBar.getQuery();
            if (TK.isEmpty(string)) {
                string = editorSearch.getDefaultSearchText();
            }
            this.text.setText(string == null ? lastSearch : string);
        }
    }

    private void startSearch() {
        EditorSearch.SearchResult searchResult;
        String string;
        this.text.getChangeEventDelayTimer().stop();
        this.text.setState(MTextFieldPanel.State.NORMAL);
        MStatusBar.ready();
        Editor<?> editor = this.getEditor();
        if (editor == null) {
            return;
        }
        if (this.text.isEmpty()) {
            return;
        }
        lastSearch = string = this.text.getText();
        Flags flags = new Flags(this.caseSensitive.isSelected() ? 1L : 0L);
        if (this.reset) {
            this.reset = false;
            searchResult = ((EditorSearch)EditorSearch.class.cast(editor)).findText(string, flags);
        } else {
            searchResult = ((EditorSearch)EditorSearch.class.cast(editor)).findNextText(string, flags);
        }
        switch (searchResult) {
            case FOUND: {
                if (string.length() > 3) {
                    this.text.saveAutoCompletion();
                }
                this.text.setState(MTextFieldPanel.State.OK);
                MStatusBar.ready();
                break;
            }
            case NOT_FOUND: {
                this.text.setState(MTextFieldPanel.State.ERROR);
                String string2 = string;
                string2 = string2.replace(" ", "<" + TK.toString(32, 0) + ">");
                string2 = string2.replace("\t", "<" + TK.toString(9, 0) + ">");
                string2 = string2.replace("\n", "\\n");
                string2 = string2.replace("\r", "\\r");
                MStatusBar.error(UI._("Text not found: \"{0}\"", string2));
                break;
            }
            case WRAP_AROUND: {
                this.text.setState(MTextFieldPanel.State.WARNING);
                MStatusBar.warning(UI._("End of the document reached. Continuing search from beginning."));
                break;
            }
            default: {
                throw new WTFError(searchResult);
            }
        }
    }

    private final class FindNextAction
    extends MApplication.FindNextAction {
        private FindNextAction() {
        }

        @Override
        public void onAction() {
            EditorQuickFind.this.startSearch();
        }
    }

    private final class CloseAction
    extends MAction {
        public CloseAction() {
            super(MActionInfo.CLOSE.getText(), MActionInfo.CLOSE.getIconName(), 27);
        }

        @Override
        public void onAction() {
            EditorQuickFind.this.setActive(false);
        }
    }
}

