/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.summary;

import java.util.Comparator;
import java.util.EnumSet;
import javax.swing.event.DocumentEvent;
import javax.swing.tree.MutableTreeNode;
import org.makagiga.Vars;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MTreeScanner;
import org.makagiga.commons.MV;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.Property;
import org.makagiga.commons.Searchable;
import org.makagiga.commons.UI;
import org.makagiga.todo.Column;
import org.makagiga.todo.Task;
import org.makagiga.tools.summary.Reminder;
import org.makagiga.tools.summary.SummaryData;
import org.makagiga.tools.summary.SummaryTree;

public final class SummaryPanel
extends MPanel
implements Focusable {
    private static MGuardedObject<SummaryPanel> _guardedInstance;
    private MSearchPanel searchPanel;
    private SummaryTree tree;

    public static synchronized SummaryPanel getInstance() {
        if (_guardedInstance == null) {
            _guardedInstance = new MGuardedObject<SummaryPanel>(new SummaryPanel(), "org.makagiga.tools.summary.SummaryPanel", PermissionInfo.ThreatLevel.MEDIUM, "Task Summary");
        }
        return _guardedInstance.get();
    }

    public MSearchPanel getSearchPanel() {
        return this.searchPanel;
    }

    public SummaryTree getTree() {
        return this.tree;
    }

    @Override
    public void focus() {
        this.tree.requestFocusInWindow();
    }

    private SummaryPanel() {
        this.initSearchPanel();
        this.initTree();
        this.initToolBar();
        Vars.alarmEnabled.addPropertyChangeListener(new Property.ValueChangeListener<Boolean>(){

            @Override
            protected void onChange(Boolean bl) {
                if (bl.booleanValue()) {
                    SummaryData.getInstance().updateAlarms();
                } else {
                    Reminder.hideAllNotifications();
                }
                Config.getDefault().sync();
            }
        });
    }

    private MMenu createPrintMenu() {
        MMenu mMenu = new MMenu();
        ActionGroup actionGroup = this.tree.getActionGroup();
        actionGroup.updateMenu(mMenu);
        mMenu.addSeparator();
        MAction mAction = new MAction(UI._("Print Date/Time")){

            @Override
            public void onAction() {
                Vars.summaryPrintDateTime.set(this.isSelected());
            }
        };
        mAction.setSelected((Boolean)Vars.summaryPrintDateTime.get());
        mMenu.addCheckBox(mAction);
        return mMenu;
    }

    private MMenu createSettingsMenu() {
        MMenu mMenu = new MMenu();
        MAction mAction = new MAction(UI._("Enable Alarms")){

            @Override
            public void onAction() {
                Vars.alarmEnabled.set(this.isSelected());
            }
        };
        mAction.setSelected((Boolean)Vars.alarmEnabled.get());
        mMenu.addCheckBox(mAction);
        mMenu.addSeparator();
        MAction mAction2 = new MAction(UI._("Show Completed Tasks")){

            @Override
            public void onAction() {
                Vars.summaryShowAllTasks.set(this.isSelected());
                Config.getDefault().sync();
                SummaryData summaryData = SummaryData.getInstance();
                summaryData.reload();
                summaryData.expandImportantNodes();
            }
        };
        mAction2.setSelected((Boolean)Vars.summaryShowAllTasks.get());
        mMenu.addCheckBox(mAction2);
        MMenu mMenu2 = new MMenu(UI._("Sort By"));
        for (Column column : Column.values()) {
            mMenu2.addRadioButton(new SortAction(column), column == Vars.summarySortMethod.get());
        }
        mMenu.add(mMenu2);
        return mMenu;
    }

    private void filter(final String string) {
        SummaryData summaryData = SummaryData.getInstance();
        if (string.isEmpty()) {
            summaryData.setAllVisible(true);
            summaryData.expandImportantNodes();
            this.searchPanel.setState(MTextFieldPanel.State.NORMAL);
            return;
        }
        final BooleanProperty booleanProperty = new BooleanProperty(false);
        final MArrayList mArrayList = new MArrayList();
        new MTreeScanner<SummaryData.Node>((SummaryData.Node)summaryData.getRootItem()){

            @Override
            public void processItem(SummaryData.Node node) {
                Task task = node.getTask();
                if (task != null) {
                    if (task.matches(string, (EnumSet<Searchable.Matches>)Task.DEFAULT_SEARCH_OPTIONS)) {
                        node.setVisible(true);
                        booleanProperty.yes();
                    } else {
                        node.setVisible(false);
                    }
                } else {
                    node.setVisible(true);
                }
            }

            @Override
            public void processParent(SummaryData.Node node) {
                if (node.getMetaInfo() != null) {
                    if (node.isEmpty(MV.VIEW)) {
                        node.setVisible(false);
                    } else {
                        mArrayList.add(node);
                        node.setVisible(true);
                    }
                }
            }
        };
        if (((Boolean)booleanProperty.get()).booleanValue()) {
            this.searchPanel.setState(MTextFieldPanel.State.OK);
        } else {
            this.searchPanel.setState(MTextFieldPanel.State.ERROR);
        }
        ((SummaryData)this.tree.getModel()).reload();
        for (SummaryData.Node node : mArrayList) {
            this.tree.setExpanded(node, true);
        }
    }

    private void initSearchPanel() {
        this.searchPanel = new MSearchPanel(true, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                SummaryPanel.this.filter(this.getText());
            }
        };
    }

    private void initToolBar() {
        MButton mButton;
        MToolBar mToolBar = new MToolBar();
        mToolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        if (((Boolean)Kiosk.actionPrint.get()).booleanValue()) {
            mButton = new MButton(MActionInfo.PRINT){

                @Override
                protected MMenu onPopupMenu() {
                    return SummaryPanel.this.createPrintMenu();
                }
            };
            mButton.setPopupMenuEnabled(true);
            mToolBar.addButton(mButton);
        }
        if (((Boolean)Kiosk.actionSettings.get()).booleanValue()) {
            mButton = new MButton(MActionInfo.SETTINGS){

                @Override
                protected MMenu onPopupMenu() {
                    return SummaryPanel.this.createSettingsMenu();
                }
            };
            mButton.setPopupMenuEnabled(true);
            mToolBar.addButton(mButton);
        }
        mToolBar.readConfig("summary");
        mToolBar.addGap();
        mToolBar.add(this.searchPanel);
        this.addNorth(mToolBar);
    }

    private void initTree() {
        this.tree = new SummaryTree();
        this.addCenter(this.tree, 2);
    }

    private static final class SortAction
    extends MDataAction<Column> {
        @Override
        public void onAction() {
            Vars.summarySortMethod.set(this.getData());
            Config.getDefault().sync();
            SummaryData summaryData = SummaryData.getInstance();
            Comparator<MutableTreeNode> comparator = summaryData.getComparator();
            for (SummaryData.Node node : summaryData.getTaskStateMap().values()) {
                for (SummaryData.Node node2 : node.list(MV.MODEL)) {
                    summaryData.sort(node2, comparator);
                }
            }
        }

        private SortAction(Column column) {
            super(column, column.toString());
        }
    }
}

