/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.io.Serializable;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Item;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.commons.category.CategoryMenu;
import org.makagiga.commons.script.ScriptYourself;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSAction;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.FSNewFile;
import org.makagiga.fs.FSProperties;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.plugins.PluginAction;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.plugins.PluginOptions;
import org.makagiga.plugins.PluginSettings;
import org.makagiga.plugins.PluginType;
import org.makagiga.search.SearchBar;
import org.makagiga.search.SortMethod;
import org.makagiga.tools.Bookmarks;
import org.makagiga.tree.ImportExport;
import org.makagiga.tree.PropertiesPanel;
import org.makagiga.tree.Tree;
import org.makagiga.tree.TreeSettingsButton;

public final class TreePanel
extends MPanel {
    private final ActionGroup actionGroup;
    private final MButton newFileButton;
    private static MGuardedObject<TreePanel> _guardedInstance;
    private final MToolBar toolBar;
    final MActionInfo quickPasteActionInfo;

    public MMenu createTreeMenu(MMenu mMenu, boolean bl) {
        Serializable serializable;
        AbstractFS abstractFS;
        MetaInfo metaInfo;
        Object object;
        MetaInfo[] metaInfoArray = Tree.getInstance().getSelectedItems();
        MMenu mMenu2 = mMenu == null ? new MMenu() : mMenu;
        mMenu2.setSplitMenu(true);
        if (bl && (object = PropertiesPanel.createTitleForSelection(metaInfoArray)) != null) {
            mMenu2.addTitle((String)object);
        }
        mMenu2.add(this.createNewFileMenu());
        object = (Bookmarks.ToggleAction)this.actionGroup.getAction("toggle-bookmark");
        ((Bookmarks.ToggleAction)object).update(metaInfoArray);
        mMenu2.add((MAction)object);
        if (metaInfoArray.length == 1) {
            metaInfo = metaInfoArray[0];
            abstractFS = metaInfo.getFS();
            mMenu2.add(this.createSortMenu(metaInfo, !metaInfo.isSortable()));
            mMenu2.add(new MainWindow.ImportMenu());
            if ((metaInfo.isFile() || metaInfo.isFolder() || metaInfo.isFSRoot()) && ((Boolean)Kiosk.linkAllowOpen.get()).booleanValue()) {
                serializable = new MAction(UI._("Browse..."), "ui/open"){

                    @Override
                    public void onAction() {
                        Tabs tabs = Tabs.getInstance();
                        tabs.saveEditor(tabs.getTabAt(metaInfo), 1);
                        MMainWindow.openURI(metaInfo.getFile().toURI());
                    }
                };
                ((MAction)serializable).setLongDescription(UI._("Open in External Browser/Editor"));
                mMenu2.add((MAction)serializable);
            }
            if (abstractFS instanceof PluginMenu) {
                PluginManager.updateMenu((PluginMenu)((Object)abstractFS), mMenu2, "TREE_MENU", false);
            }
            if ((serializable = abstractFS.getInfo()) != null && ((PluginInfo)serializable).getPluggable() instanceof PluginOptions && metaInfo.isFSRoot()) {
                MApplication.SettingsAction settingsAction = new MApplication.SettingsAction(){

                    @Override
                    public void onAction() {
                        PluginSettings.showPluginOptionsDialog(TreePanel.this.getWindowAncestor(), abstractFS.getInfo());
                    }
                };
                settingsAction.setName(UI._("Settings: {0}", abstractFS.getName()));
                mMenu2.add(settingsAction);
            }
        } else {
            metaInfo = null;
        }
        mMenu2.addSeparator();
        mMenu2.add((Action)this.actionGroup.getAction("delete"));
        mMenu2.addSeparator();
        mMenu2.add((Action)this.actionGroup.getAction("rename"));
        abstractFS = this.actionGroup.getAction("properties");
        if (metaInfo != null && abstractFS.isEnabled()) {
            serializable = new CategoryMenu(CategoryManager.getSharedInstance(), metaInfo.getCategories()){

                @Override
                protected void onCategoryChange(Category category) {
                    PropertiesPanel.setProperty(32, this.getCategoryList(), metaInfo);
                }
            };
            ((JMenuItem)serializable).setEnabled(metaInfo.canModify());
        } else {
            serializable = new MMenu(UI._("Category"));
            ((JMenuItem)serializable).setEnabled(false);
        }
        mMenu2.add((JMenuItem)serializable);
        mMenu2.add((Action)((Object)abstractFS));
        return mMenu2;
    }

    public ActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public static synchronized TreePanel getInstance() {
        if (_guardedInstance == null) {
            new TreePanel();
        }
        return _guardedInstance.get();
    }

    public MButton getNewFileButton() {
        return this.newFileButton;
    }

    public List<LabelIcon> getStandardLabelIcons() {
        return new MArrayList<LabelIcon>(new LabelIcon(MActionInfo.ADD_STAR.getText(), MActionInfo.ADD_STAR.getIconName()), new LabelIcon(UI._("Valuable"), "labels/valuable"), new LabelIcon(UI._("Important"), "labels/important"), new LabelIcon(UI._("Todo"), "labels/todo"), new LabelIcon(UI._("Happy"), "labels/emotion/happy"));
    }

    public MToolBar getToolBar() {
        return this.toolBar;
    }

    public void updateActions() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        AbstractFS abstractFS = null;
        MetaInfo[] metaInfoArray = Tree.getInstance().getSelectedItems();
        boolean bl4 = bl3 = metaInfoArray.length == 1;
        if (metaInfoArray.length > 0) {
            bl2 = true;
            bl = true;
            for (MetaInfo metaInfo : metaInfoArray) {
                AbstractFS abstractFS2 = metaInfo.getFS();
                if (metaInfo.isFile()) {
                    if (bl3 && metaInfo.getParentFolder().canModify() && abstractFS2 instanceof FSNewFile) {
                        abstractFS = abstractFS2;
                    }
                } else if (metaInfo.isFolder()) {
                    if (metaInfo.canModify() && bl3 && abstractFS2 instanceof FSNewFile) {
                        abstractFS = abstractFS2;
                    }
                } else if (metaInfo.isFSRoot()) {
                    bl2 = false;
                    if (bl3 && abstractFS2 instanceof FSNewFile) {
                        abstractFS = abstractFS2;
                    }
                } else if (metaInfo.isVirtualFile()) {
                    Flags flags = abstractFS2 instanceof FSProperties ? ((FSProperties)FSProperties.class.cast(abstractFS2)).getMetaInfoCapabilities(metaInfo) : null;
                    bl2 = flags == null ? false : flags.isSet(16L);
                }
                if (!metaInfo.isPermission(FSAction.DELETE)) {
                    bl = false;
                }
                if (!bl3 || metaInfo.isPermission(FSAction.RENAME)) continue;
                bl4 = false;
            }
        } else {
            bl2 = false;
            bl = false;
        }
        boolean bl5 = (Boolean)Vars.treeReadOnly.get();
        MAction mAction = (MAction)this.actionGroup.getAction("new-file");
        if (abstractFS == null) {
            mAction.setEnabled(false);
            mAction.setIconName("ui/newfile");
            mAction.setName(UI._("New File"));
        } else {
            mAction.setEnabled(!bl5);
            Icon icon = abstractFS.getNewFileActionIcon(MIcon.Size.SMALL);
            if (icon != null) {
                mAction.setSmallIcon(icon);
            } else {
                mAction.setIconName("ui/newfile");
            }
            mAction.setName(((FSNewFile)FSNewFile.class.cast(abstractFS)).getNewFileActionText());
        }
        this.actionGroup.setEnabled("new-folder", !bl5);
        Bookmarks.ToggleAction toggleAction = (Bookmarks.ToggleAction)this.actionGroup.getAction("toggle-bookmark");
        toggleAction.update(metaInfoArray);
        this.actionGroup.setEnabled("delete", bl && !bl5);
        this.actionGroup.setEnabled("rename", bl4 && !bl5);
        this.actionGroup.setEnabled("properties", bl2 && !bl5);
        this.actionGroup.setEnabled("quick-paste", !bl5);
    }

    private TreePanel() {
        if (_guardedInstance != null) {
            throw new WTFError("org.makagiga.tree.TreePanel already created");
        }
        _guardedInstance = new MGuardedObject<TreePanel>(this, "org.makagiga.tree.TreePanel", PermissionInfo.ThreatLevel.HIGH, "Tree");
        this.newFileButton = new MButton(MActionInfo.NEW){

            @Override
            protected MMenu onPopupMenu() {
                return TreePanel.this.createNewFileMenu();
            }
        };
        this.newFileButton.setPopupMenuEnabled(true);
        this.toolBar = new MToolBar();
        this.toolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.toolBar.addButton(this.newFileButton, 1);
        this.toolBar.addButton(new TreeSettingsButton());
        ScriptYourself.install(this.toolBar, "tree");
        this.addNorth(this.toolBar);
        Tree tree = Tree.getInstance();
        this.addCenter(tree, 2);
        this.addSouth(SearchBar.getInstance());
        this.actionGroup = new ActionGroup();
        this.actionGroup.add("delete", new DeleteAction());
        this.actionGroup.connect("delete", (JComponent)tree, 0);
        this.actionGroup.add("new-file", new NewFileAction());
        this.actionGroup.connect("new-file", (JComponent)tree, 2);
        this.actionGroup.add("new-folder", new NewFolderAction());
        this.actionGroup.connect("new-folder", (JComponent)tree, 2);
        this.actionGroup.add("properties", new PropertiesAction());
        this.actionGroup.connect("properties", (JComponent)tree, 2);
        this.quickPasteActionInfo = new MActionInfo(UI._("Quick Paste"), "ui/paste", 86, MAction.getMenuMask() | 1);
        this.actionGroup.add("quick-paste", new QuickPasteAction(this.quickPasteActionInfo));
        this.actionGroup.connect("quick-paste", (JComponent)tree, 2);
        this.actionGroup.add("rename", new RenameAction());
        this.actionGroup.connect("rename", (JComponent)tree, 0);
        this.actionGroup.add("toggle-bookmark", new Bookmarks.ToggleAction());
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePanel.this.updateActions();
            }
        });
        this.updateActions();
    }

    private MMenu createNewFileMenu() {
        boolean bl;
        Tree tree = Tree.getInstance();
        MetaInfo metaInfo = tree.getCurrentFolder(false);
        AbstractFS abstractFS = metaInfo.getFS();
        MMenu mMenu = new MMenu(MActionInfo.NEW);
        mMenu.add((Action)this.actionGroup.getAction("new-folder"));
        mMenu.add((Action)this.actionGroup.getAction("quick-paste"));
        mMenu.addSeparator();
        if (abstractFS instanceof TreeFS) {
            mMenu.setEnabled((Boolean)Vars.treeReadOnly.get() == false);
            bl = true;
            for (PluginInfo object : PluginType.EDITOR.get()) {
                if (((EditorPlugin)EditorPlugin.class.cast(object.getPluggable())).isReadOnly()) continue;
                mMenu.add(new NewFileAction(object, bl));
                bl = false;
            }
        } else {
            mMenu.add((Action)this.actionGroup.getAction("new-file"));
        }
        PluginManager.updateMenu(mMenu, "NEW_MENU", false);
        bl = false;
        for (AbstractFS abstractFS2 : tree.getFileSystems().values()) {
            Action action;
            Flags flags;
            if (!(abstractFS2 instanceof FSNewFile) || abstractFS2 == abstractFS || !(flags = new Flags(((FSNewFile)FSNewFile.class.cast(abstractFS2)).getNewFileOptions())).isSet(1L) || (action = ((FSNewFile)FSNewFile.class.cast(abstractFS2)).getNewFileAction()) == null) continue;
            if (!bl) {
                bl = true;
                mMenu.addSeparator();
            }
            mMenu.add(action);
        }
        return mMenu;
    }

    private MMenu createSortMenu(MetaInfo metaInfo, boolean bl) {
        MMenu mMenu = new MMenu(UI._("Sort By"));
        if (bl) {
            mMenu.setEnabled(false);
        } else {
            SortMethod sortMethod = metaInfo.getSortMethod();
            mMenu.addRadioButton(new SortAction(metaInfo, sortMethod, SortMethod.NAME));
            mMenu.addRadioButton(new SortAction(metaInfo, sortMethod, SortMethod.DATE));
            mMenu.addRadioButton(new SortAction(metaInfo, sortMethod, SortMethod.LABEL));
            mMenu.addRadioButton(new SortAction(metaInfo, sortMethod, SortMethod.COLOR));
            mMenu.addRadioButton(new SortAction(metaInfo, sortMethod, SortMethod.RATING));
        }
        return mMenu;
    }

    private static final class SortAction
    extends MAction {
        private final MetaInfo folder;
        private final SortMethod newSortMethod;

        @Override
        public void onAction() {
            Tree tree = Tree.getInstance();
            tree.sort(this.folder, this.newSortMethod);
            Config config = this.folder.getConfig();
            config.write("sortMethod", this.newSortMethod);
            config.sync();
        }

        private SortAction(MetaInfo metaInfo, SortMethod sortMethod, SortMethod sortMethod2) {
            super(sortMethod2.toString());
            this.folder = metaInfo;
            this.newSortMethod = sortMethod2;
            this.setSelected(sortMethod == sortMethod2);
        }
    }

    private static final class RenameAction
    extends MAction {
        public RenameAction() {
            super(UI._("Rename..."), 113);
            this.setHTMLHelp(UI._("Change name of the selected item."));
        }

        @Override
        public void onAction() {
            if (((Boolean)Vars.treeReadOnly.get()).booleanValue()) {
                return;
            }
            FSHelper.renameUI(this.getSourceWindow(), Tree.getInstance().getSelectedItems()[0]);
        }
    }

    private static final class QuickPasteAction
    extends MAction {
        public QuickPasteAction(MActionInfo mActionInfo) {
            super(mActionInfo);
            this.setEnabled((Boolean)Vars.treeReadOnly.get() == false);
            this.setHTMLHelp(UI._("Pastes a clipboard content as a new file."));
        }

        @Override
        public void onAction() {
            ImportExport.importClipboard();
        }
    }

    private static final class PropertiesAction
    extends MAction {
        @Override
        public void onAction() {
            MainWindow.getInstance().showProperties(Tree.getInstance().getSelectedItems());
        }

        private PropertiesAction() {
            super(MActionInfo.PROPERTIES);
            this.setHTMLHelp(UI._("Properties of the selected items."));
        }
    }

    private static final class NewFolderAction
    extends MAction {
        public NewFolderAction() {
            super(MActionInfo.NEW_FOLDER);
            this.setHTMLHelp(UI._("Creates a new subfolder in the selected folder."));
        }

        @Override
        public void onAction() {
            MainWindow.showTree(null);
            MetaInfo metaInfo = Tree.getInstance().getCurrentFolder(false);
            metaInfo.getFS().newFolder(metaInfo);
        }
    }

    private static final class NewFileAction
    extends PluginAction {
        @Override
        public void onAction() {
            MainWindow.showTree(null);
            Tree tree = Tree.getInstance();
            MetaInfo metaInfo = tree.getCurrentFolder(false);
            AbstractFS abstractFS = metaInfo.getFS();
            if (abstractFS instanceof FSNewFile) {
                try {
                    PluginInfo pluginInfo = (PluginInfo)this.getData();
                    if (pluginInfo != null && abstractFS instanceof TreeFS) {
                        ((TreeFS)TreeFS.class.cast(abstractFS)).setDefaultFileType(pluginInfo.getID());
                    }
                    MetaInfo metaInfo2 = ((FSNewFile)FSNewFile.class.cast(abstractFS)).newFile(metaInfo);
                    tree.selectItem(metaInfo2, true);
                }
                catch (FSException fSException) {
                    MMessage.error(null, fSException);
                }
            }
        }

        private NewFileAction() {
            super(UI._("New File"), "ui/newfile");
            this.setAcceleratorKey(78, NewFileAction.getMenuMask());
            this.setEnabled((Boolean)Vars.treeReadOnly.get() == false);
            this.setHTMLHelp(UI._("Creates a new file in the selected folder."));
        }

        private NewFileAction(PluginInfo pluginInfo, boolean bl) {
            super(pluginInfo);
            if (bl) {
                this.setAcceleratorKey(78, NewFileAction.getMenuMask());
            }
            EditorPlugin editorPlugin = (EditorPlugin)pluginInfo.getPluggable();
            this.setName(editorPlugin.getDocumentDisplayName());
        }
    }

    private static final class DeleteAction
    extends MAction {
        public DeleteAction() {
            super(MActionInfo.DELETE_NO_KEY_STROKE);
            this.setAcceleratorKey(127, DeleteAction.getMenuMask());
            this.setHTMLHelp(UI._("Deletes the selected items.<br>Note: Locked items cannot be deleted."));
        }

        @Override
        public void onAction() {
            FSHelper.deleteUI(Tree.getInstance().getSelectedItems());
        }
    }

    public static final class LabelIcon
    extends Item<String> {
        private LabelIcon(String string, String string2) {
            super(string2, string);
        }
    }
}

