/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import org.makagiga.Vars;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.MSlider;
import org.makagiga.commons.MTreeModel;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.Tree;

@Deprecated
public final class TreeSettings
extends MSettingsPage {
    private int originalThumbnailSize;
    private MCheckBox showCategories;
    private MCheckBox showMetaInfo;
    private MCheckBox showRating;
    private MCheckBox showTags;
    private MCheckBox thumbnailPreview;
    private MSlider thumbnailSize;

    public TreeSettings() {
        super(UI._("Tree"), "ui/tree");
    }

    @Override
    protected void onInit() {
        this.addSeparator(UI._("Thumbnails"));
        this.thumbnailPreview = new MCheckBox(UI._("Enabled")){

            @Override
            protected void onClick() {
                TreeSettings.this.thumbnailSize.setEnabled(this.isSelected());
                TreeSettings.this.showMetaInfo.setEnabled(this.isSelected());
            }
        };
        this.thumbnailPreview.setAndRemember((Boolean)Vars.treePreview.get());
        this.add(this.thumbnailPreview);
        this.addGap();
        this.thumbnailSize = new MSlider();
        this.thumbnailSize.setEnabled(this.thumbnailPreview.isSelected());
        this.thumbnailSize.setMinimum(25);
        this.thumbnailSize.setMaximum(250);
        this.originalThumbnailSize = (Integer)Vars.treePreviewSize.get();
        this.thumbnailSize.setValue(this.originalThumbnailSize);
        this.thumbnailSize.showTicks(25, true, false);
        this.thumbnailSize.setEventsEnabled(true);
        MLabel mLabel = MLabel.createFor(this.thumbnailSize, "Thumbnail Size");
        this.add(mLabel);
        this.add(this.thumbnailSize);
        this.showMetaInfo = new MCheckBox("Meta Info (image size, etc)");
        this.showMetaInfo.setAndRemember((Boolean)Vars.treeShowMetaInfo.get());
        this.showMetaInfo.setEnabled(this.thumbnailPreview.isSelected());
        this.add(this.showMetaInfo);
        this.addSeparator(UI._("Show Properties"));
        this.showCategories = new MCheckBox(UI._("Categories"));
        this.showCategories.setAndRemember((Boolean)Vars.treeShowCategories.get());
        this.add(this.showCategories);
        this.showTags = new MCheckBox(UI._("Tags"));
        this.showTags.setAndRemember((Boolean)Vars.treeShowTags.get());
        this.add(this.showTags);
        this.showRating = new MCheckBox(UI._("Rating"));
        this.showRating.setAndRemember((Boolean)Vars.treeShowRating.get());
        this.add(this.showRating);
        this.thumbnailSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MSlider mSlider = (MSlider)changeEvent.getSource();
                TreeSettings.this.setImagePreview(mSlider.getValue(), null);
            }
        });
    }

    @Override
    protected void onOK() {
        Vars.treePreview.set(this.thumbnailPreview.isSelected());
        Vars.treePreviewSize.set(this.thumbnailSize.getValue());
        Vars.treeShowCategories.set(this.showCategories.isSelected());
        Vars.treeShowMetaInfo.set(this.showMetaInfo.isSelected());
        Vars.treeShowRating.set(this.showRating.isSelected());
        Vars.treeShowTags.set(this.showTags.isSelected());
        if (this.thumbnailPreview.isModified() || this.thumbnailSize.getValue() != this.originalThumbnailSize || this.showCategories.isModified() || this.showMetaInfo.isModified() || this.showRating.isModified() || this.showTags.isModified()) {
            TreeSettings.updateTreeView(true);
        }
    }

    static void updateTreeView(boolean bl) {
        final Tree tree = Tree.getInstance();
        if (bl) {
            FileCache.getInstance().removeItemByTag("preview");
            tree.invalidatePreview((MetaInfo)((MTreeModel)tree.getModel()).getRootItem());
        }
        final MArrayList mArrayList = new MArrayList();
        new Tree.Scanner(){

            @Override
            public void processItem(MetaInfo metaInfo) {
                if (tree.isExpanded(metaInfo)) {
                    mArrayList.add(metaInfo);
                }
            }
        };
        ((DefaultTreeModel)tree.getModel()).reload();
        for (MetaInfo metaInfo : mArrayList) {
            tree.setExpanded(metaInfo, true);
        }
    }

    public static final class Advanced
    extends MSettingsPage {
        public Advanced() {
            super(UI._("Tree"), "ui/tree");
            this.addSeparator(UI._("General"));
            this.bind(Vars.treeItemCount, UI._("Show number of items in folder"));
            this.bind(Vars.treeReopenFiles, UI._("Reopen recent documents on application startup"));
            this.addSeparator(UI._("System Tags"));
            this.add(new MLabel("Automatically insert file tags:"));
            for (TagsUtils.AutoTag autoTag : TagsUtils.AutoTag.values()) {
                this.bind(autoTag.getProperty(), autoTag.toString());
            }
        }
    }
}

