/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.web;

import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.web.WebException;
import org.makagiga.web.WebPanel;
import org.makagiga.web.WebService;

public class WebDialog<W extends WebService>
extends MDialog {
    private final WeakReference<WebPanel<W>> panelRef;

    public WebDialog(Window window, String string, Icon icon, WebPanel<W> webPanel) {
        super(window, string, icon, 7);
        this.changeButton((AbstractButton)this.getOKButton(), UI._("Submit"), "ui/upload");
        this.panelRef = new WeakReference<WebPanel<W>>(webPanel);
        this.addCenter(webPanel);
    }

    @Override
    protected boolean onAccept() {
        WebPanel webPanel = (WebPanel)this.panelRef.get();
        if (((WebService)webPanel.getSelectedService()).isActive()) {
            TK.beep();
            return false;
        }
        try {
            webPanel.submit();
        }
        catch (WebException webException) {
            MMessage.error((Window)this, webException);
        }
        return false;
    }

    @Override
    protected boolean onReject() {
        WebPanel webPanel = (WebPanel)this.panelRef.get();
        if (webPanel == null) {
            return true;
        }
        if (((WebService)webPanel.getSelectedService()).isActive()) {
            webPanel.cancel(true);
            return false;
        }
        return true;
    }
}

