/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import COM.objectspace.jgl.Pair;
import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.view.Res;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class CompositeItemPainter
implements ItemPainter {
    private ItemPainter firstPainter;
    private ItemPainter secondPainter;
    private Insets margins = new Insets(1, 1, 1, 1);
    private int orientation;
    private int alignment = 34;
    private int gap;
    private Color background;
    private boolean paintBackground = true;

    public CompositeItemPainter(ItemPainter itemPainter, ItemPainter itemPainter2) {
        this(itemPainter, itemPainter2, 0, 34, 4);
    }

    public CompositeItemPainter(ItemPainter itemPainter, ItemPainter itemPainter2, int n) {
        this(itemPainter, itemPainter2, n, 34, 4);
    }

    public CompositeItemPainter(ItemPainter itemPainter, ItemPainter itemPainter2, int n, int n2) {
        this(itemPainter, itemPainter2, n, n2, 4);
    }

    public CompositeItemPainter(ItemPainter itemPainter, ItemPainter itemPainter2, int n, int n2, int n3) {
        this.firstPainter = itemPainter;
        this.secondPainter = itemPainter2;
        this.orientation = n;
        this.alignment = n2;
        this.gap = n3;
    }

    public void setMargins(Insets insets) {
        this.margins = insets;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setPaintBackground(boolean bl) {
        this.paintBackground = bl;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        Dimension dimension;
        Dimension dimension2;
        if (object instanceof Pair) {
            dimension2 = this.firstPainter.getPreferredSize(((Pair)object).first, graphics, n, itemPaintSite);
            dimension = this.secondPainter.getPreferredSize(((Pair)object).second, graphics, n, itemPaintSite);
        } else {
            dimension2 = this.firstPainter.getPreferredSize(object, graphics, n, itemPaintSite);
            dimension = this.secondPainter.getPreferredSize(object, graphics, n, itemPaintSite);
        }
        if (this.orientation == 0) {
            return new Dimension(dimension2.width + this.gap + dimension.width + this.margins.left + this.margins.right, Math.max(dimension2.height, dimension.height) + this.margins.top + this.margins.bottom);
        }
        return new Dimension(Math.max(dimension2.width, dimension.width) + this.margins.left + this.margins.right, dimension2.height + this.gap + dimension.height + this.margins.top + this.margins.bottom);
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        this.calculateRects(object, graphics, rectangle, n, itemPaintSite, rectangle2, rectangle3);
        if (this.paintBackground) {
            Color color;
            Color color2 = graphics.getColor();
            Color color3 = color = itemPaintSite != null ? itemPaintSite.getBackground() : this.getBackground();
            if (color == null) {
                color = this.getBackground();
            }
            if (color == null) {
                color = graphics.getColor();
            }
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color2);
        }
        if (object instanceof Pair) {
            this.firstPainter.paint(((Pair)object).first, graphics, rectangle2, n, itemPaintSite);
            this.secondPainter.paint(((Pair)object).second, graphics, rectangle3, n, itemPaintSite);
        } else {
            this.firstPainter.paint(object, graphics, rectangle2, n, itemPaintSite);
            this.secondPainter.paint(object, graphics, rectangle3, n, itemPaintSite);
        }
    }

    public void calculateRects(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite, Rectangle rectangle2, Rectangle rectangle3) {
        int n2;
        int n3;
        int n4;
        Dimension dimension;
        Dimension dimension2;
        if (rectangle2 == null || rectangle3 == null) {
            throw new IllegalArgumentException(Res.getString(7));
        }
        if (object instanceof Pair) {
            dimension2 = this.firstPainter.getPreferredSize(((Pair)object).first, graphics, n, itemPaintSite);
            dimension = this.secondPainter.getPreferredSize(((Pair)object).second, graphics, n, itemPaintSite);
        } else {
            dimension2 = this.firstPainter.getPreferredSize(object, graphics, n, itemPaintSite);
            dimension = this.secondPainter.getPreferredSize(object, graphics, n, itemPaintSite);
        }
        int n5 = n4 = itemPaintSite != null ? itemPaintSite.getAlignment() : this.alignment;
        if (n4 == 0) {
            n4 = this.alignment;
        }
        int n6 = this.orientation == 1 ? Math.max(dimension2.width, dimension.width) : dimension2.width + dimension.width + this.gap + this.margins.left + this.margins.right;
        int n7 = this.orientation == 0 ? Math.max(dimension2.height, dimension.height) : dimension2.height + dimension.height + this.gap + this.margins.top + this.margins.bottom;
        switch (n4 & 0xF) {
            default: {
                n3 = this.margins.left;
                break;
            }
            case 2: {
                n3 = (rectangle.width - n6) / 2;
                break;
            }
            case 3: {
                n3 = rectangle.width - n6 - this.margins.right;
            }
        }
        switch (n4 & 0xF0) {
            default: {
                n2 = this.margins.top;
                break;
            }
            case 32: {
                n2 = (rectangle.height - n7) / 2;
                break;
            }
            case 48: {
                n2 = rectangle.height - n7 - this.margins.bottom;
            }
        }
        if (this.orientation == 0) {
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y + (rectangle.height - dimension2.height) / 2;
            rectangle2.width = dimension2.width;
            rectangle2.height = dimension2.height;
            rectangle3.x = rectangle.x + dimension2.width + this.gap;
            rectangle3.y = rectangle.y + (rectangle.height - dimension.height) / 2;
            rectangle3.width = dimension.width;
            rectangle3.height = dimension.height;
        } else {
            rectangle2.x = rectangle.x + (rectangle.width - dimension2.width) / 2;
            rectangle2.y = rectangle.y;
            rectangle2.width = dimension2.width;
            rectangle2.height = dimension2.height;
            rectangle3.x = rectangle.x + (rectangle.width - dimension.width) / 2;
            rectangle3.y = rectangle.y + dimension2.height + this.gap;
            rectangle3.width = dimension.width;
            rectangle3.height = dimension.height;
        }
        rectangle2.x += n3;
        rectangle2.y += n2;
        rectangle3.x += n3;
        rectangle3.y += n2;
    }
}

