/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.systeminfo;

import com.mayastudios.systeminfo.JavaInfo;
import com.mayastudios.systeminfo.LinuxInfo;
import com.mayastudios.systeminfo.MacOSInfo;
import com.mayastudios.systeminfo.SolarisInfo;
import com.mayastudios.systeminfo.UnknownSystemInfo;
import com.mayastudios.systeminfo.VersionInfo;
import com.mayastudios.systeminfo.WindowsInfo;

public abstract class SystemInfo {
    public static final String LIBRARY_VERSION = VersionInfo.LIBRARY_VERSION;
    public static final String LIBRARY_REVISION = VersionInfo.LIBRARY_REVISION;
    public static final String FILE_SEPERATOR = System.getProperty("file.separator");
    public static final String PATH_SEPERATOR = System.getProperty("path.separator");
    public static final String LINE_SEPERATOR = System.getProperty("line.separator");
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static final OperatationSystemType OSTYPE = SystemInfo.determineOsType();
    public static final SystemInfo INFO = SystemInfo.createSystemInfo();
    private final JavaArch m_arch;

    protected SystemInfo(JavaArch javaArch) {
        this.m_arch = javaArch;
    }

    public JavaArch getJavaArch() {
        return this.m_arch;
    }

    private static OperatationSystemType determineOsType() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            return OperatationSystemType.Windows;
        }
        if (string.equals("linux")) {
            return OperatationSystemType.Linux;
        }
        if (string.startsWith("mac os")) {
            return OperatationSystemType.MacOS;
        }
        if (string.equals("solaris") || string.equals("sunos")) {
            return OperatationSystemType.Solaris;
        }
        return OperatationSystemType.Unknown;
    }

    private static SystemInfo createSystemInfo() {
        switch (OSTYPE) {
            case Windows: {
                return new WindowsInfo();
            }
            case Linux: {
                return new LinuxInfo();
            }
            case MacOS: {
                return new MacOSInfo();
            }
            case Solaris: {
                return new SolarisInfo();
            }
        }
        return new UnknownSystemInfo();
    }

    public abstract String getOsName();

    public abstract String getSystemVersionNumber();

    public abstract String getSystemCodename();

    public abstract SystemArch getSystemArch();

    public abstract String getProcessorName();

    public abstract long getTotalPhysicalMemorySize();

    public String toString() {
        String string = this.getTotalPhysicalMemorySize() == 0L ? "unknown" : this.getTotalPhysicalMemorySize() / 1024L / 1024L + " MB";
        return "Operating System:    " + this.getOsName() + LINE_SEPERATOR + "Codename:            " + (this.getSystemCodename() != null ? this.getSystemCodename() : "unknown") + LINE_SEPERATOR + "OS Version:          " + this.getSystemVersionNumber() + LINE_SEPERATOR + "System Architecture: " + (Object)((Object)this.getSystemArch()) + (this.getProcessorName() != null ? " (" + this.getProcessorName() + ")" : "") + LINE_SEPERATOR + "Total Memory:        " + string + LINE_SEPERATOR + "Java Architecture:   " + (Object)((Object)this.getJavaArch());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(INFO);
            System.out.println();
            System.out.println(JavaInfo.getJavaInfo());
        } else if (stringArray.length == 1) {
            if ("--props".equals(stringArray[0])) {
                SystemInfo.printProps();
            } else if ("--version".equals(stringArray[0])) {
                SystemInfo.printVersion();
            } else {
                SystemInfo.printHelp();
            }
        } else {
            SystemInfo.printHelp();
        }
    }

    private static void printProps() {
        System.out.println("os.name:    " + System.getProperty("os.name"));
        System.out.println("os.arch:    " + System.getProperty("os.arch"));
        System.out.println("os.version: " + System.getProperty("os.version"));
    }

    private static void printVersion() {
        System.out.println("Version:       " + LIBRARY_VERSION);
        System.out.println("Build Date:    " + VersionInfo.LIBRARY_BUILD_DATE);
        System.out.println("Revision:      " + LIBRARY_REVISION);
        System.out.println("Revision:      " + VersionInfo.LIBRARY_REVISION_DATE);
    }

    private static void printHelp() {
        System.out.println("Usage: java -jar systeminfo.jar [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  --props    : Print the values of all Java system properties ");
        System.out.println("               starting with\"os.\"");
        System.out.println("  --help     : Print this page.");
        System.out.println("  --version  : Print the version.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavaArch {
        x86("32-bit architecture (x86-32)"),
        x64("64-bit architecture (x86-64)"),
        PowerPC("PowerPC processor 32-bit"),
        Sparc("SPARC processor 32-bit"),
        Unknown("Unknown architecture (" + System.getProperty("os.arch") + ")");

        private final String m_name;

        private JavaArch(String string2) {
            this.m_name = string2;
        }

        public String toString() {
            return this.m_name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SystemArch {
        x86("32-bit architecture (x86-32)"),
        x64("64-bit architecture (x86-64)"),
        PowerPC("PowerPC processor 32-bit"),
        Sparc("SPARC processor 32-bit"),
        Unknown("Unknown architecture");

        private final String m_name;

        private SystemArch(String string2) {
            this.m_name = string2;
        }

        public String toString() {
            return this.m_name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperatationSystemType {
        Windows,
        Linux,
        MacOS,
        Solaris,
        Unknown;

    }
}

