/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.systeminfo;

import com.mayastudios.systeminfo.Helpers;
import com.mayastudios.systeminfo.SystemInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsInfo
extends SystemInfo {
    private final WindowsVersion m_version;
    private final String m_versionNumber = System.getProperty("os.version");
    private final int m_servicePackNumber;
    private final SystemInfo.SystemArch m_systemArch;
    private final String m_processorName;
    private final long m_totalMemory;

    WindowsInfo() {
        super(WindowsInfo.determineJavaArch());
        String string = System.getProperty("os.name").toLowerCase();
        this.m_version = string.equals("windows 98") ? WindowsVersion.Windows98 : (string.equals("windows me") ? WindowsVersion.WindowsME : (string.equals("windows 2000") ? WindowsVersion.Windows2000 : (string.equals("windows xp") ? WindowsVersion.WindowsXP : (string.equals("windows vista") ? WindowsVersion.WindowsVista : (string.equals("windows 7") ? WindowsVersion.WindowsSeven : WindowsVersion.Unknown)))));
        this.m_servicePackNumber = WindowsInfo.determineServicePack();
        this.m_systemArch = WindowsInfo.determineSystemArch(this.m_version);
        this.m_processorName = RegUtil.queryStringValue("HKLM", "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "ProcessorNameString");
        this.m_totalMemory = WindowsInfo.determineTotalPhysicalMemorySize();
    }

    private static SystemInfo.JavaArch determineJavaArch() {
        String string = System.getProperty("os.arch");
        if ("x86".equals(string)) {
            return SystemInfo.JavaArch.x86;
        }
        if ("x64".equals(string)) {
            return SystemInfo.JavaArch.x64;
        }
        return SystemInfo.JavaArch.Unknown;
    }

    private static int determineServicePack() {
        Integer n = RegUtil.queryDwordValue("HKLM", "system\\CurrentControlSet\\control\\windows", "CSDVersion");
        if (n == null) {
            return -1;
        }
        int n2 = n;
        if (n2 < 0) {
            return -1;
        }
        return n2 /= 256;
    }

    private static SystemInfo.SystemArch determineSystemArch(WindowsVersion windowsVersion) {
        if (windowsVersion == WindowsVersion.Windows98 || windowsVersion == WindowsVersion.WindowsME) {
            return SystemInfo.SystemArch.x86;
        }
        try {
            String string = System.getenv("PROCESSOR_ARCHITECTURE");
            if ("x86".equals(string)) {
                return SystemInfo.SystemArch.x86;
            }
            if ("x64".equals(string)) {
                return SystemInfo.SystemArch.x64;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SystemInfo.SystemArch.Unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long determineTotalPhysicalMemorySize() {
        long l = Helpers.determineTotalPhysicalMemory();
        if (l != 0L) {
            return l;
        }
        File file = new File(TEMP_DIR, "freemem-" + Short.toString((short)new Random().nextInt()) + ".vbs");
        try {
            Matcher matcher;
            int n;
            FileWriter fileWriter = new FileWriter(file);
            InputStreamReader inputStreamReader = new InputStreamReader(WindowsInfo.class.getResourceAsStream("res/freemem.vbs"));
            while ((n = inputStreamReader.read()) != -1) {
                fileWriter.write(n);
            }
            fileWriter.close();
            Process process = Runtime.getRuntime().exec("cscript //nologo " + file.getAbsolutePath());
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!(matcher = Pattern.compile("^Total RAM: (\\d+)$").matcher(stringWriter.toString())).find()) {
                long l2 = 0L;
                return l2;
            }
            long l3 = Long.parseLong(matcher.group(1));
            return l3;
        }
        catch (Exception exception) {
            long l4 = 0L;
            return l4;
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    public String getOsName() {
        String string = this.m_servicePackNumber == -1 ? "sevice pack could not be determined" : (this.m_servicePackNumber == 0 ? "no service pack installed" : String.format("SP%d", this.m_servicePackNumber));
        return (Object)((Object)this.m_version) + " (" + string + ")";
    }

    public WindowsVersion getVersion() {
        return this.m_version;
    }

    public String getSystemCodename() {
        return this.m_version.getCodename();
    }

    public String getSystemVersionNumber() {
        return this.m_versionNumber;
    }

    public String getProcessorName() {
        return this.m_processorName;
    }

    public SystemInfo.SystemArch getSystemArch() {
        return this.m_systemArch;
    }

    public long getTotalPhysicalMemorySize() {
        return this.m_totalMemory;
    }

    public int getServicePackNumber() {
        return this.m_servicePackNumber;
    }

    public boolean isNTBased() {
        return this.m_version.isNTBased();
    }

    public String toString() {
        return super.toString() + "\r\n\r\n" + "Is NT based: " + this.isNTBased();
    }

    private static class RegUtil {
        public static final String HKEY_LOCAL_MACHINE = "HKLM";
        private static final String REGQUERY_UTIL = "reg query ";
        private static final String REGSTR_TOKEN = "REG_SZ";
        private static final String REGDWORD_TOKEN = "REG_DWORD";

        private RegUtil() {
        }

        public static Integer queryDwordValue(String string, String string2, String string3) {
            try {
                String string4 = RegUtil.queryRegValue(string, string2, string3);
                if (string4 == null) {
                    return null;
                }
                int n = string4.indexOf(REGDWORD_TOKEN);
                if (n == -1) {
                    return null;
                }
                String string5 = string4.substring(n + REGDWORD_TOKEN.length()).trim();
                return Integer.parseInt(string5.substring("0x".length()), 16);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static String queryStringValue(String string, String string2, String string3) {
            try {
                String string4 = RegUtil.queryRegValue(string, string2, string3);
                if (string4 == null) {
                    return null;
                }
                int n = string4.indexOf(REGSTR_TOKEN);
                if (n == -1) {
                    return null;
                }
                return string4.substring(n + REGSTR_TOKEN.length()).trim();
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static String queryRegValue(String string, String string2, String string3) {
            try {
                Process process = Runtime.getRuntime().exec(String.format("%s \"%s\\%s\" /v %s", REGQUERY_UTIL, string, string2, string3));
                InputStream inputStream = process.getInputStream();
                StringWriter stringWriter = new StringWriter();
                try {
                    int n;
                    while ((n = inputStream.read()) != -1) {
                        stringWriter.write(n);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return stringWriter.toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WindowsVersion {
        Windows98("Windows 98", "memphis", false),
        WindowsME("Windows Me", "georgia", false),
        Windows2000("Windows 2000", null, true),
        WindowsXP("Windows XP", "whistler", true),
        WindowsVista("Windows Vista", "longhorn", true),
        WindowsSeven("Windows 7", "vienna", true),
        Unknown("Unknown Windows Operating System", System.getProperty("os.name"), false);

        private final String m_osName;
        private final String m_codename;
        private final boolean m_isNTBased;

        private WindowsVersion(String string2, String string3, boolean bl) {
            this.m_osName = string2;
            this.m_codename = string3;
            this.m_isNTBased = bl;
        }

        public String getCodename() {
            return this.m_codename;
        }

        public String toString() {
            return this.m_osName;
        }

        public boolean isNTBased() {
            return this.m_isNTBased;
        }
    }
}

