/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.controller;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.AReplicateableObjectImpl;
import com.mayastudios.fred.client.model.CColumn;
import com.mayastudios.fred.client.model.CColumnModel;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CEffortSet;
import com.mayastudios.fred.client.model.CEffortTableModel;
import com.mayastudios.fred.client.model.CEffortVector;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CProjectTreeModel;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.DataMask;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import com.mayastudios.fred.client.view.CEffortTable;
import com.mayastudios.fred.client.view.CFilterPanel;
import com.mayastudios.fred.client.view.CProjectTree;
import com.mayastudios.fred.client.view.CView;
import com.mayastudios.fred.client.view.ContextMenuProvider;
import com.mayastudios.fred.client.view.FredStatusBar;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.CDlgViewCustomizeColumns;
import com.mayastudios.mscl.mwt.dockpane.ADockableTab;
import com.mayastudios.mscl.mwt.dockpane.ITabStateListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xml.sax.Attributes;

public class CViewController
implements IXMLizable,
TreeSelectionListener,
ListSelectionListener,
ITabStateListener {
    public static final String XML_TAG_NAME = "view";
    public static final int MAX_VIEW_NAME_LENGTH = 25;
    private static final String XML_ATT_VIEW_NAME = "viewname";
    private static final String XML_ATT_SECONDROW_NAME = "secondrow";
    public static final CProjectTree.ETreeType DEFAULT_TREE_TYPE = CProjectTree.ETreeType.ShowTasks;
    private CEffortVector m_oEffortVector;
    private final CProjectTreeModel m_oTreeModel;
    private final CProjectTree m_oProjectTree;
    private final DefaultListModel m_oListModelTasks;
    private final DefaultListModel m_oListModelCategories;
    private final DefaultListModel m_oListModelPersons;
    private final CFilterPanel m_oFilterDialog;
    private final CEffortTableModel m_oTableModel;
    private CColumnModel m_oColumns;
    private final DefaultListSelectionModel m_oTableSelectionModel;
    private final CEffortTable m_oEffortTable;
    private final CView m_oView;
    private final CEffortSet m_oSelectedEfforts;
    private final DataMask.MutableDataMask m_oCurrentStatusMask;
    private AFilter m_oCurrentlyUsedFilter;
    private CProjectTree.ETreeType m_eCurrentTreeType;
    private String m_strViewName;

    public CViewController() {
        this(null, null);
    }

    public CViewController(AFilter aFilter) {
        this(aFilter, null);
    }

    public CViewController(AFilter aFilter, String string) {
        this(aFilter, string, WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.ShowSecondRowPerDefault), null);
    }

    private CViewController(AFilter aFilter, String string, boolean bl, CColumnModel cColumnModel) {
        ProjectList projectList = ProjectList.getInstance();
        this.m_oCurrentlyUsedFilter = aFilter == null ? AFilter.createDefaultFilter(DEFAULT_TREE_TYPE) : aFilter;
        this.m_eCurrentTreeType = this.m_oCurrentlyUsedFilter instanceof AFilter.CTasksInTreeFilter ? CProjectTree.ETreeType.ShowTasks : CProjectTree.ETreeType.ShowCategories;
        this.m_oListModelTasks = ProjectList.getTasksListModel();
        this.m_oListModelCategories = CategoryList.getCategoriesListModel();
        this.m_oListModelPersons = ObjectFactoryImpl.getPersonsListModel();
        this.m_oFilterDialog = new CFilterPanel(this.m_oListModelTasks, this.m_oListModelCategories, this.m_oListModelPersons, this.m_oCurrentlyUsedFilter, this);
        this.m_oTreeModel = new CProjectTreeModel(projectList.getTree(this.m_eCurrentTreeType));
        this.m_oProjectTree = new CProjectTree(this, this.m_oTreeModel, this.m_oCurrentlyUsedFilter);
        this.m_oProjectTree.getProjectTree().addMouseListener(new CTreeMouseListener());
        this.m_oEffortVector = ProjectList.getInstance().getContainedEfforts(this.m_oCurrentlyUsedFilter);
        this.m_oTableModel = new CEffortTableModel(this.m_oEffortVector);
        this.m_oColumns = cColumnModel != null ? cColumnModel : CColumnModel.createDefaultColumns();
        this.m_oTableSelectionModel = new DefaultListSelectionModel();
        this.m_oEffortTable = new CEffortTable(this.m_oTableModel, this.m_oColumns, this.m_oTableSelectionModel);
        this.m_oEffortTable.setEnableSecondRow(bl);
        this.m_oTableSelectionModel.addListSelectionListener(this);
        this.m_oEffortTable.addMouseListener(new CTableMouseListener());
        this.m_oEffortTable.addKeyListener(new CTableKeyAdapter());
        this.m_oView = new CView(this.m_oFilterDialog, this.m_oProjectTree, this.m_oEffortTable, this);
        if (bl) {
            this.m_oView.activateSecondRowButton();
        }
        this.m_oSelectedEfforts = new CEffortSet();
        this.m_strViewName = string != null ? string : Labels.get("NEW_VIEW_NAME", new Object[0]);
        MainController.getInstance().getMainWindow().addView(this.m_oView, this.m_strViewName);
        this.m_oCurrentStatusMask = new DataMask.MutableDataMask();
        this._notifyMainController();
    }

    public String getName() {
        return this.m_strViewName;
    }

    public DataMask.MutableDataMask getStatusMask() {
        this._refreshStatusMaskTable();
        this._refreshStatusMaskTree();
        return this.m_oCurrentStatusMask;
    }

    public CEffortVector getEffortVector() {
        return this.m_oEffortVector;
    }

    public CColumnModel getColumns() {
        return this.m_oColumns;
    }

    public CView getView() {
        return this.m_oView;
    }

    public int[] getSelectedRows() {
        return this.m_oEffortTable.getSelectedRows();
    }

    public CProjectImpl getSelectedProject() {
        return this._castTreePath(CProjectImpl.class);
    }

    public CTaskImpl getSelectedTask() {
        return this._castTreePath(CTaskImpl.class);
    }

    public CategoryList.CCategory getSelectedCategory() {
        return this._castTreePath(CategoryList.CCategory.class);
    }

    public AFilter.CCategoryProjectMapper getSelectedCategoryMapped() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        AFilter.CCategoryProjectMapper cCategoryProjectMapper = null;
        TreePath[] treePathArray = this.m_oProjectTree.getProjectTree().getSelectionPaths();
        if (treePathArray != null && treePathArray.length == 1 && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent()).getUserObject()) instanceof CategoryList.CCategory) {
            CategoryList.CCategory cCategory = (CategoryList.CCategory)object;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            CProjectImpl cProjectImpl = (CProjectImpl)defaultMutableTreeNode2.getUserObject();
            cCategoryProjectMapper = new AFilter.CCategoryProjectMapper(cCategory, cProjectImpl);
        }
        return cCategoryProjectMapper;
    }

    private <T> T _castTreePath(Class<T> clazz) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        TreePath[] treePathArray = this.m_oProjectTree.getProjectTree().getSelectionPaths();
        if (treePathArray != null && treePathArray.length == 1 && clazz.isInstance(object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent()).getUserObject())) {
            return clazz.cast(object);
        }
        return null;
    }

    public CEffortImpl getSelectedEffort() {
        int n;
        if (this.m_oEffortTable.getSelectedRowCount() == 1 && (n = this.m_oEffortTable.getSelectedRow()) >= 0 && n < this.m_oEffortVector.size()) {
            return (CEffortImpl)this.m_oEffortVector.get(n);
        }
        return null;
    }

    public Collection<CEffortImpl> getSelectedEfforts() {
        return this.m_oSelectedEfforts;
    }

    public int getSelectedEffortCount() {
        return this.m_oSelectedEfforts.getEffortCount();
    }

    public int getEffectiveEffortCount() {
        if (this.m_oSelectedEfforts.size() == 0) {
            return this.m_oEffortVector.getEffortCount();
        }
        return this.m_oSelectedEfforts.getEffortCount();
    }

    public int getEffectiveEffortDuration() {
        if (this.m_oSelectedEfforts.size() == 0) {
            return this.m_oEffortVector.getDuration();
        }
        return this.m_oSelectedEfforts.getDuration();
    }

    private void _refreshStatusMaskTree() {
        CProjectImpl cProjectImpl = this.getSelectedProject();
        if (cProjectImpl != null) {
            this.m_oCurrentStatusMask.isProjectSelected = true;
            this.m_oCurrentStatusMask.isProjectClosed = cProjectImpl.isClosed();
            this.m_oCurrentStatusMask.isTeamSelection = cProjectImpl.isTeamProject();
            this.m_oCurrentStatusMask.isUserProjectLeader = cProjectImpl.isUserProjectLeader();
        } else {
            this.m_oCurrentStatusMask.isProjectSelected = false;
        }
        CTaskImpl cTaskImpl = this.getSelectedTask();
        if (cTaskImpl != null) {
            this.m_oCurrentStatusMask.isTaskSelected = true;
            this.m_oCurrentStatusMask.isProjectClosed = cTaskImpl.getProject().isClosed();
            this.m_oCurrentStatusMask.isTeamSelection = cTaskImpl.isTeamTask();
            this.m_oCurrentStatusMask.isUserProjectLeader = cTaskImpl.getProject().isUserProjectLeader();
        } else {
            this.m_oCurrentStatusMask.isTaskSelected = false;
        }
        AFilter.CCategoryProjectMapper cCategoryProjectMapper = this.getSelectedCategoryMapped();
        if (cCategoryProjectMapper != null) {
            this.m_oCurrentStatusMask.isCategorySelected = true;
            this.m_oCurrentStatusMask.isProjectClosed = cCategoryProjectMapper.getProject().isClosed();
            this.m_oCurrentStatusMask.isTeamSelection = cCategoryProjectMapper.getProject().isTeamProject();
            this.m_oCurrentStatusMask.isUserProjectLeader = cCategoryProjectMapper.getProject().isUserProjectLeader();
        } else {
            this.m_oCurrentStatusMask.isCategorySelected = false;
        }
    }

    private void _refreshStatusMaskTable() {
        this.m_oCurrentStatusMask.isEffortSelected = this.m_oSelectedEfforts.size() > 0;
        this.m_oCurrentStatusMask.areMultipleEffortsSelected = this.m_oSelectedEfforts.size() > 1;
        CEffortImpl cEffortImpl = this.getSelectedEffort();
        this.m_oCurrentStatusMask.isCollidingEffortSelected = cEffortImpl != null && cEffortImpl.isColliding();
    }

    private void _refreshTableByLastFilter() {
        this.m_oEffortVector = ProjectList.getInstance().getContainedEfforts(this.m_oCurrentlyUsedFilter);
        this.m_oSelectedEfforts.clear();
        this.m_oTableModel.setEffortVector(this.m_oEffortVector);
    }

    private void _refreshCurrentlyUsedFilter() {
        this.m_oCurrentlyUsedFilter = this.m_oFilterDialog.getFilter();
        this.m_oCurrentlyUsedFilter.addTreePaths(this.m_oProjectTree.getProjectTree().getSelectionPaths());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.m_oEffortTable.getSelectedRowCount() == 0) {
                this.m_oSelectedEfforts.clear();
            } else {
                int n = Math.max(listSelectionEvent.getFirstIndex(), 0);
                int n2 = Math.min(listSelectionEvent.getLastIndex(), this.m_oEffortVector.size() - 1);
                for (int i = n; i <= n2; ++i) {
                    if (this.m_oTableSelectionModel.isSelectedIndex(i)) {
                        this.m_oSelectedEfforts.add((CEffortImpl)this.m_oEffortVector.get(i));
                        continue;
                    }
                    this.m_oSelectedEfforts.remove((CEffortImpl)this.m_oEffortVector.get(i));
                }
            }
            this._notifyMainController();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.m_oCurrentlyUsedFilter.addTreePaths(this.m_oProjectTree.getProjectTree().getSelectionPaths());
        this._refreshTableByLastFilter();
        this._notifyMainController();
    }

    private void notifyDefaultTaskChanged(CTaskImpl cTaskImpl, CTaskImpl cTaskImpl2) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_oTreeModel.getRoot();
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.m_oTreeModel.findNode(defaultMutableTreeNode, cTaskImpl);
        if (defaultMutableTreeNode2 != null) {
            this.m_oTreeModel.nodeChanged(defaultMutableTreeNode2);
        }
        if ((defaultMutableTreeNode2 = this.m_oTreeModel.findNode(defaultMutableTreeNode, cTaskImpl2)) != null) {
            this.m_oTreeModel.nodeChanged(defaultMutableTreeNode2);
        }
    }

    private void _notifyMainController() {
        MainController.getInstance().publishStatusMask();
        FredStatusBar.refreshEffortData(this.getEffectiveEffortCount(), this.getEffectiveEffortDuration());
    }

    public void updateNotification(MainController.EUpdateMessage eUpdateMessage, Collection<?> collection, boolean bl) {
        HashSet<CEffortImpl> hashSet = new HashSet<CEffortImpl>(this.m_oSelectedEfforts);
        switch (eUpdateMessage) {
            case ProjectCreated: {
                Object object = (DefaultMutableTreeNode)this.m_oTreeModel.getRoot();
                for (AReplicateableObjectImpl aReplicateableObjectImpl : collection) {
                    Object object2;
                    int n;
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(aReplicateableObjectImpl);
                    if (this.m_eCurrentTreeType == CProjectTree.ETreeType.ShowCategories) {
                        for (n = 0; n < CategoryList.getCategoryCount(); ++n) {
                            object2 = new DefaultMutableTreeNode(CategoryList.getCategory(n));
                            defaultMutableTreeNode.add((MutableTreeNode)object2);
                        }
                    }
                    n = 0;
                    for (int i = 0; i < ((DefaultMutableTreeNode)object).getChildCount(); ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(i);
                        if (((CProjectImpl)aReplicateableObjectImpl).compareTo((CProjectImpl)defaultMutableTreeNode2.getUserObject()) >= 0) continue;
                        ((DefaultMutableTreeNode)object).insert(defaultMutableTreeNode, i);
                        n = 1;
                        break;
                    }
                    if (n == 0) {
                        ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
                    }
                    object2 = new int[]{((DefaultMutableTreeNode)object).getIndex(defaultMutableTreeNode)};
                    this.m_oTreeModel.nodesWereInserted((TreeNode)object, (int[])object2);
                }
                break;
            }
            case ProjectDeleted: {
                Object object = (DefaultMutableTreeNode)this.m_oTreeModel.getRoot();
                for (AReplicateableObjectImpl aReplicateableObjectImpl : collection) {
                    int n = this._findObjectInChilds((DefaultMutableTreeNode)object, aReplicateableObjectImpl);
                    if (n >= 0) {
                        ((DefaultMutableTreeNode)object).remove(n);
                        int[] nArray = new int[]{n};
                        Object[] objectArray = new Object[]{aReplicateableObjectImpl};
                        this.m_oTreeModel.nodesWereRemoved((TreeNode)object, nArray, objectArray);
                    }
                    this.m_oCurrentlyUsedFilter.removeProject((CProjectImpl)aReplicateableObjectImpl);
                }
                this._refreshTableByLastFilter();
                break;
            }
            case ProjectUpdated: {
                break;
            }
            case TasksCreated: {
                Object[] objectArray;
                Object object = (DefaultMutableTreeNode)this.m_oTreeModel.getRoot();
                for (AReplicateableObjectImpl aReplicateableObjectImpl : collection) {
                    if (this.m_eCurrentTreeType == CProjectTree.ETreeType.ShowTasks) {
                        int n = this._findObjectInChilds((DefaultMutableTreeNode)object, ((CTaskImpl)aReplicateableObjectImpl).getProject());
                        if (n >= 0) {
                            Serializable serializable;
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(n);
                            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(aReplicateableObjectImpl);
                            boolean bl2 = false;
                            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                                serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                                if (((CTaskImpl)aReplicateableObjectImpl).compareTo((CTaskImpl)serializable.getUserObject()) >= 0) continue;
                                defaultMutableTreeNode.insert(defaultMutableTreeNode3, i);
                                bl2 = true;
                                break;
                            }
                            if (!bl2) {
                                defaultMutableTreeNode.add(defaultMutableTreeNode3);
                            }
                            objectArray = new int[]{defaultMutableTreeNode.getIndex(defaultMutableTreeNode3)};
                            this.m_oTreeModel.nodesWereInserted(defaultMutableTreeNode, (int[])objectArray);
                            if (bl) {
                                serializable = new TreePath(defaultMutableTreeNode.getPath());
                                this.m_oProjectTree.getProjectTree().expandPath((TreePath)serializable);
                            }
                        }
                        if (this._isRootSelected() || this._isProjectSelected(((CTaskImpl)aReplicateableObjectImpl).getProject())) {
                            this.m_oCurrentlyUsedFilter.addTask((CTaskImpl)aReplicateableObjectImpl);
                        }
                    }
                    if (this.m_oListModelTasks.contains(aReplicateableObjectImpl)) continue;
                    this.m_oListModelTasks.addElement(aReplicateableObjectImpl);
                }
                break;
            }
            case TaskDeleted: {
                Object[] objectArray;
                Object object = (DefaultMutableTreeNode)this.m_oTreeModel.getRoot();
                for (AReplicateableObjectImpl aReplicateableObjectImpl : collection) {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    int n;
                    int n2;
                    if (this.m_eCurrentTreeType == CProjectTree.ETreeType.ShowTasks && (n2 = this._findObjectInChilds((DefaultMutableTreeNode)object, ((CTaskImpl)aReplicateableObjectImpl).getProject())) >= 0 && (n = this._findObjectInChilds(defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(n2), aReplicateableObjectImpl)) >= 0) {
                        defaultMutableTreeNode.remove(n);
                        int[] nArray = new int[]{n};
                        objectArray = new Object[]{aReplicateableObjectImpl};
                        this.m_oTreeModel.nodesWereRemoved(defaultMutableTreeNode, nArray, objectArray);
                    }
                    this.m_oCurrentlyUsedFilter.removeTask((CTaskImpl)aReplicateableObjectImpl);
                    this.m_oListModelTasks.removeElement(aReplicateableObjectImpl);
                }
                this._refreshTableByLastFilter();
                break;
            }
            case TaskUpdated: {
                break;
            }
            case DefaultTaskChanged: {
                Object object = (List)collection;
                this.notifyDefaultTaskChanged((CTaskImpl)object.get(0), (CTaskImpl)object.get(1));
                break;
            }
            case EffortsCreated: {
                if (collection.isEmpty()) break;
                this._refreshTableByLastFilter();
                break;
            }
            case EffortsUpdated: {
                if (collection.isEmpty()) break;
                this._refreshTableByLastFilter();
                break;
            }
            case EffortsDeleted: {
                for (Object object : collection) {
                    if (!((CEffortImpl)object).passesFilterFull(this.m_oCurrentlyUsedFilter)) continue;
                    this.m_oEffortVector.remove((CEffortImpl)object);
                    this.m_oSelectedEfforts.remove((CEffortImpl)object);
                }
                this.m_oTableModel.setEffortVector(this.m_oEffortVector);
                break;
            }
            case PersonsAdded: {
                for (Object object : collection) {
                    if (this.m_oListModelPersons.contains(object)) continue;
                    this.m_oListModelPersons.addElement(object);
                }
                break;
            }
            case PersonsDeleted: {
                for (Object object : collection) {
                    this.m_oListModelPersons.removeElement(object);
                    this.m_oCurrentlyUsedFilter.removePerson((CPersonImpl)object);
                }
                break;
            }
            case VisualUpdate: {
                this._notifyMainController();
                break;
            }
            case BecomesVisible: {
                this._notifyMainController();
            }
        }
        if (this.m_oSelectedEfforts.isEmpty() && !hashSet.isEmpty() && this.m_oTableSelectionModel.isSelectionEmpty()) {
            for (int i = 0; i < this.m_oEffortVector.size(); ++i) {
                if (!hashSet.contains(this.m_oEffortVector.get(i))) continue;
                this.m_oTableSelectionModel.addSelectionInterval(i, i);
            }
        }
    }

    private int _findObjectInChilds(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (object != defaultMutableTreeNode2.getUserObject()) continue;
            return i;
        }
        return -1;
    }

    private boolean _isRootSelected() {
        TreePath[] treePathArray = this.m_oProjectTree.getProjectTree().getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getUserObject() != CProjectTree.ROOT_NODE_NAME) continue;
            return true;
        }
        return false;
    }

    private boolean _isProjectSelected(CProjectImpl cProjectImpl) {
        TreePath[] treePathArray = this.m_oProjectTree.getProjectTree().getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getUserObject() != cProjectImpl) continue;
            return true;
        }
        return false;
    }

    private void openTreeContextMenu(MouseEvent mouseEvent) {
        int n = 0;
        int n2 = 0;
        JTree jTree = this.m_oProjectTree.getProjectTree();
        TreePath treePath = jTree.getPathForLocation(n = mouseEvent.getX(), n2 = mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null) {
            boolean bl = false;
            for (int i = 0; i < treePathArray.length; ++i) {
                if (treePathArray[i].getLastPathComponent() != defaultMutableTreeNode) continue;
                bl = true;
                break;
            }
            if (!bl) {
                jTree.setSelectionPath(treePath);
            }
        } else {
            jTree.setSelectionPath(treePath);
        }
        MainController mainController = MainController.getInstance();
        if (defaultMutableTreeNode.isRoot()) {
            ContextMenuProvider.provideProjectTreeRootMenu(mainController.getCurrentStatusMask()).show(jTree, n, n2);
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof CProjectImpl) {
            ContextMenuProvider.provideProjectTreeProjectMenu(mainController.getCurrentStatusMask()).show(jTree, n, n2);
        } else if (object instanceof CTaskImpl) {
            ContextMenuProvider.provideProjectTreeTaskMenu(mainController.getCurrentStatusMask()).show(jTree, n, n2);
        } else if (object instanceof CategoryList.CCategory) {
            ContextMenuProvider.provideProjectTreeCategoryMenu(mainController.getCurrentStatusMask()).show(jTree, n, n2);
        }
    }

    private void openTableContextMenu(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_oEffortTable.rowAtPoint(point);
        if (n != -1) {
            int[] nArray = this.m_oEffortTable.getSelectedRows();
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.m_oTableSelectionModel.setSelectionInterval(n, n);
            }
        } else {
            this.m_oTableSelectionModel.setSelectionInterval(n, n);
        }
        ContextMenuProvider.provideEffortTableEffortMenu(MainController.getInstance().getCurrentStatusMask()).show((Component)((Object)this.m_oEffortTable), point.x, point.y);
    }

    public void incomingFilterRequest() {
        this._refreshCurrentlyUsedFilter();
        this._refreshTableByLastFilter();
        this._notifyMainController();
    }

    public void incomingProjectTreeTypeChanged(CProjectTree.ETreeType eTreeType) {
        DefaultMutableTreeNode defaultMutableTreeNode = ProjectList.getInstance().getTree(eTreeType);
        this.m_oTreeModel.setRoot(defaultMutableTreeNode);
        this.m_oTreeModel.reload();
        this.m_oCurrentlyUsedFilter = AFilter.createDefaultFilter(eTreeType);
        this.m_eCurrentTreeType = this.m_oCurrentlyUsedFilter instanceof AFilter.CTasksInTreeFilter ? CProjectTree.ETreeType.ShowTasks : CProjectTree.ETreeType.ShowCategories;
        this.m_oProjectTree.setFilter(this.m_oCurrentlyUsedFilter);
        this.m_oFilterDialog.setFilter(this.m_oCurrentlyUsedFilter);
        this.m_oView.activateFilterButton(this.m_oCurrentlyUsedFilter.useThisFilter());
        this._refreshTableByLastFilter();
        this.updateNotification(MainController.EUpdateMessage.VisualUpdate, null, true);
    }

    public void incomingEffortEditEffort() {
        if (this.m_oEffortTable.getSelectedRowCount() == 1) {
            MainController.incomingEffortEditEffort();
        }
    }

    public void incomingEffortDeleteEfforts() {
        if (this.m_oEffortTable.getSelectedRowCount() > 0) {
            MainController.incomingEffortDeleteEfforts();
        }
    }

    public void incomingEffortShowColidings() {
        if (this.m_oEffortTable.getSelectedRowCount() == 1) {
            MainController.incomingEffortShowCollidators();
        }
    }

    public void incomingEffortReplicateEfforts() {
        if (this.m_oEffortTable.getSelectedRowCount() > 0) {
            MainController.incomingEffortReplicateEfforts();
        }
    }

    public void incomingEffortAcceptEfforts() {
        if (this.m_oEffortTable.getSelectedRowCount() > 0) {
            MainController.incomingEffortAcceptEfforts();
        }
    }

    public void incomingViewCustomizeColumns() {
        Vector<CColumn> vector;
        Vector<CColumn> vector2 = this.getColumns().getColums();
        CDlgViewCustomizeColumns cDlgViewCustomizeColumns = new CDlgViewCustomizeColumns(vector2, vector = this.getColumns().getUnusedColumnTypes(), this.m_strViewName);
        if (cDlgViewCustomizeColumns.showDialog() == ADialogEx.EReturnValue.OK) {
            if (!cDlgViewCustomizeColumns.getNewViewName().equals(this.m_strViewName)) {
                this.m_strViewName = cDlgViewCustomizeColumns.getNewViewName();
                this.m_oView.getAssociatedTab().setCaption(this.m_strViewName);
                this.m_oView.getAssociatedTab().signalPropertyChange();
            }
            this.getColumns().setColums(cDlgViewCustomizeColumns.getColumns());
        }
    }

    public void stateChanged(ADockableTab aDockableTab, ITabStateListener.EState eState) {
        MainController.incomingTabChange(eState);
    }

    public void tabClosed(ADockableTab aDockableTab) {
        MainController.getInstance().eventViewClosed(this);
    }

    public void duplicate() {
        AFilter aFilter = this.m_oCurrentlyUsedFilter.clone();
        String string = this.m_strViewName + " " + Labels.get("COPY", new Object[0]);
        CColumnModel cColumnModel = this.m_oColumns.clone();
        new CViewController(aFilter, string, this.m_oEffortTable.isSecondRowEnabled(), cColumnModel);
    }

    public String toString() {
        return this.m_strViewName;
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute(XML_ATT_VIEW_NAME, this.m_strViewName);
        cSimpleXMLStream.addAttribute(XML_ATT_SECONDROW_NAME, String.valueOf(this.m_oEffortTable.isSecondRowEnabled()));
        this.m_oCurrentlyUsedFilter.xmlize(cSimpleXMLStream);
        this.m_oColumns.xmlize(cSimpleXMLStream);
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public static class CViewStoreContainer
    extends AXMLObjectContainer<CViewController> {
        private static final AFilter.CFilterContainer FILTER_CONTAINER = new AFilter.CFilterContainer();
        private static final CColumnModel.CColumnModelStoreContainer COLUMN_MODEL_STORE_CONTAINER = new CColumnModel.CColumnModelStoreContainer();
        private String m_strViewName;
        private boolean m_bIsSecondRowEnabled;
        private AFilter m_oFilter;
        private CColumnModel m_oColumnModel;

        @Override
        protected CViewController createContainedObject(Attributes attributes, int n) {
            this.m_strViewName = attributes.getValue(CViewController.XML_ATT_VIEW_NAME);
            this.m_bIsSecondRowEnabled = n >= 2 ? Boolean.parseBoolean(attributes.getValue(CViewController.XML_ATT_SECONDROW_NAME)) : false;
            return null;
        }

        @Override
        protected void completeContainedObject(int n) {
            this.m_oObject = new CViewController(this.m_oFilter, this.m_strViewName, this.m_bIsSecondRowEnabled, this.m_oColumnModel);
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals("filter")) {
                return FILTER_CONTAINER;
            }
            if (string.equals("columns")) {
                return COLUMN_MODEL_STORE_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals("filter")) {
                this.m_oFilter = (AFilter)object;
            }
            if (string.equals("columns")) {
                this.m_oColumnModel = (CColumnModel)object;
            }
        }

        public void reset() {
            this.m_strViewName = null;
            this.m_bIsSecondRowEnabled = false;
            this.m_oFilter = null;
            this.m_oColumnModel = null;
        }
    }

    private class CTableKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                CViewController.this.incomingEffortDeleteEfforts();
            } else if (keyEvent.getKeyCode() == 10) {
                CViewController.this.incomingEffortEditEffort();
            }
        }
    }

    private class CTableMouseListener
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                CViewController.this.incomingEffortEditEffort();
            } else if (mouseEvent.isPopupTrigger()) {
                CViewController.this.openTableContextMenu(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                CViewController.this.openTableContextMenu(mouseEvent);
            }
        }
    }

    private class CTreeMouseListener
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                CViewController.this.openTreeContextMenu(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                CViewController.this.openTreeContextMenu(mouseEvent);
            }
        }
    }
}

