/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.controller.ShutdownHook;
import com.mayastudios.fred.client.exceptions.CFredAbortException;
import com.mayastudios.fred.client.exceptions.CModelException;
import com.mayastudios.fred.client.exceptions.CWorkfileVersionException;
import com.mayastudios.fred.client.exceptions.CXMLException;
import com.mayastudios.fred.client.filehandling.LastWorkFileInfo;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.ADummyXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.ARootXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleDefaultHandler;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.CVersionedXMLElement;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.filehandling.xml.XMLFileHandling;
import com.mayastudios.fred.client.model.CURLList;
import com.mayastudios.fred.client.model.DefaultTask;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import com.mayastudios.fred.client.view.QuickBar;
import com.mayastudios.fred.client.view.dialogs.FredMessageBox;
import com.mayastudios.mscl.CExecutionTime;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.MessageBox;
import com.mayastudios.mscl.mwt.widgets.DockedWindow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CWorkfile {
    private static final String XML_SCHEMA_FORMATTER = "schemas/Workfile.v%d.xsd";
    private static final int MAX_VERSION = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(CWorkfile.class);
    private Calendar m_oDateCreated = null;
    private Calendar m_oDateLastSaved = null;
    private File m_strPathToWorkFile = null;
    private boolean m_bHasChanged = false;
    private long m_lViewPosition = -1L;
    private final ShutdownHook mf_oShutdownHook = new ShutdownHook(this);

    private CWorkfile() {
    }

    public static CWorkfile load(File file) throws IOException, FileNotFoundException, CXMLException, CWorkfileVersionException {
        URL uRL;
        int n;
        File file2 = file.getAbsoluteFile();
        boolean bl = false;
        File file3 = ShutdownHook.doesRescueFileExist(file);
        if (file3 != null) {
            MessageBox.EButton eButton = FredMessageBox.showOptionDlg(Labels.get("MsgBox.Workfile.LoadingShutdownFile", new Object[0]), Labels.get("TITLE_OPENING_WORKFILE", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO_CANCEL);
            switch (eButton) {
                case YES: {
                    file2 = file3;
                    bl = true;
                    break;
                }
                case CANCEL: {
                    return null;
                }
            }
        }
        if ((n = CWorkfile.getVersionNumber(file2)) > 2) {
            throw new CWorkfileVersionException(String.format(Labels.get("INFORMATION_LOADING_ERROR_VERSION_TOOLARGE", new Object[0]), n));
        }
        if (!file2.canRead()) {
            throw new IOException("Datei ist nicht lesbar: " + file2.getAbsolutePath());
        }
        LOGGER.info("[Parsen][{}][Version] {}", (Object)file2.getName(), (Object)n);
        CWorkfileContainer cWorkfileContainer = new CWorkfileContainer(file2, n);
        try {
            uRL = MainController.getResLoader().getResourceUrlExcpt(String.format(XML_SCHEMA_FORMATTER, n));
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new IllegalStateException("Konnte XML Schema nicht finden.");
        }
        XMLFileHandling.processXML(file2, uRL, cWorkfileContainer.getHandler());
        if (!cWorkfileContainer.m_bLoadingSuccessful) {
            return null;
        }
        CWorkfile cWorkfile = (CWorkfile)cWorkfileContainer.getContainedObject();
        if (n < 2) {
            FredMessageBox.showInfoDlg(Labels.get("INFORMATION_LOADING_VERSION_TOOSMALL", new Object[0]) + (n == 0 ? Labels.get("INFORMATION_LOADING_VERSION_TOOSMALL_ORG_INFO", new Object[0]) : ""), Labels.get("TITLE_OPENING_WORKFILE", new Object[0]), MessageBox.EIcon.INFORMATION);
            cWorkfile.setChanged();
        } else if (bl) {
            cWorkfile.setChanged();
        }
        cWorkfile.m_strPathToWorkFile = n == 0 ? new File(file.getAbsolutePath().replaceFirst(".xml$", ".fred")) : file;
        cWorkfile.mf_oShutdownHook.onOpenWorkFile();
        return cWorkfile;
    }

    private static int getVersionNumber(File file) throws FileNotFoundException, IOException, CWorkfileVersionException {
        CVersionHandler cVersionHandler = new CVersionHandler();
        try {
            XMLFileHandling.processXML(file, cVersionHandler);
        }
        catch (CVersionHandler.FoundNotification foundNotification) {
        }
        catch (CXMLException cXMLException) {
            throw new CWorkfileVersionException(Labels.get("INFORMATION_LOADING_ERROR_VERSION", new Object[0]) + cXMLException.getMessage());
        }
        return cVersionHandler.getVersion();
    }

    public static CWorkfile createWorkfile(File file) {
        Exception exception;
        CWorkfile cWorkfile = new CWorkfile();
        cWorkfile.m_oDateCreated = Calendar.getInstance();
        cWorkfile.m_strPathToWorkFile = file;
        cWorkfile.m_bHasChanged = true;
        try {
            cWorkfile._save();
            return cWorkfile;
        }
        catch (CXMLException cXMLException) {
            exception = cXMLException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        FredMessageBox.showInfoDlg(Labels.get("Workfile.Create.MsgBox.Error", new Object[0]), Labels.get("Workfile.Create.MsgBoxTitle", new Object[0]), MessageBox.EIcon.ERROR, exception);
        return null;
    }

    public CWorkfile clone(File file) {
        CWorkfile cWorkfile = new CWorkfile();
        cWorkfile.m_strPathToWorkFile = file;
        cWorkfile.m_oDateCreated = this.m_oDateCreated;
        cWorkfile.m_bHasChanged = true;
        return cWorkfile;
    }

    public File getWorkFilePath() {
        return this.m_strPathToWorkFile;
    }

    public void setChanged() {
        this.m_bHasChanged = true;
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public boolean close() {
        boolean bl = this._close();
        if (bl) {
            this.mf_oShutdownHook.onCloseWorkFile();
        }
        return bl;
    }

    private boolean _close() {
        MessageBox.EButton eButton;
        if (this.m_bHasChanged) {
            MessageBox.EButton eButton2 = FredMessageBox.showOptionDlg(Labels.get("CONFIRM_FILE_CLOSE_ANYWAY", new Object[0]), Labels.get("TITLE_FILE_CLOSE", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO_CANCEL);
            switch (eButton2) {
                case YES: {
                    return this.save(false);
                }
                case NO: {
                    return true;
                }
            }
            return false;
        }
        if (!this._checkWorkfileDirForSaving(false)) {
            return true;
        }
        do {
            Exception exception;
            try {
                this._save();
                break;
            }
            catch (CXMLException cXMLException) {
                exception = cXMLException;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            LOGGER.warn("", (Throwable)exception);
            eButton = FredMessageBox.showOptionDlg(Labels.get("Workfile.Save.MsgBox.ErrorOnPartial", new Object[0]), Labels.get("Workfile.Save.MsgBoxTitle", new Object[0]), MessageBox.EIcon.ERROR, MessageBox.EOptionButtons.RETRY_IGNORE_CANCEL, exception);
            if (eButton != MessageBox.EButton.CANCEL) continue;
            return false;
        } while (eButton != MessageBox.EButton.IGNORE);
        return true;
    }

    private boolean _checkWorkfileDirForSaving(boolean bl) {
        File file = this.m_strPathToWorkFile.getParentFile();
        String string = null;
        if (!file.exists()) {
            string = Labels.get("Workfile.Save.MsgBox.DirNotExist", file.getAbsolutePath());
        } else if (!this.m_strPathToWorkFile.canWrite()) {
            string = Labels.get("Workfile.Save.MsgBox.WFNotWritable", this.m_strPathToWorkFile.getAbsolutePath());
        }
        if (string == null) {
            return true;
        }
        if (bl) {
            FredMessageBox.showInfoDlg(string, Labels.get("Workfile.Save.MsgBoxTitle", new Object[0]), MessageBox.EIcon.ERROR);
        }
        return false;
    }

    public boolean save(boolean bl) {
        Exception exception;
        if (!this.m_bHasChanged) {
            return false;
        }
        if (!bl && !this._checkWorkfileDirForSaving(true)) {
            return false;
        }
        try {
            this._save();
            return true;
        }
        catch (CXMLException cXMLException) {
            exception = cXMLException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        LOGGER.warn("", (Throwable)exception);
        FredMessageBox.showInfoDlg(Labels.get("Workfile.Save.MsgBox.ErrorOnComplete", new Object[0]), Labels.get("Workfile.Save.MsgBoxTitle", new Object[0]), MessageBox.EIcon.ERROR, exception);
        return false;
    }

    private void _save() throws IOException, CXMLException {
        CRootXMLizer cRootXMLizer = new CRootXMLizer(this.m_bHasChanged, this);
        if (this.m_bHasChanged) {
            XMLFileHandling.writeXMLComplete(this.m_strPathToWorkFile, cRootXMLizer, WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.MakeBackup));
            this.m_lViewPosition = cRootXMLizer.getVolatileDataPos();
        } else {
            XMLFileHandling.writeXMLPartial(this.m_strPathToWorkFile, cRootXMLizer, this.m_lViewPosition, 1);
        }
        this.m_oDateLastSaved = cRootXMLizer.getSaveDate();
        LastWorkFileInfo.setLastOpenedWorkFilePath(this.m_strPathToWorkFile);
        File file = ShutdownHook.doesRescueFileExist(this.m_strPathToWorkFile);
        if (file != null) {
            file.delete();
        }
        this.m_bHasChanged = false;
    }

    public IXMLizable getXMLizable() {
        return new CRootXMLizer(true, this);
    }

    public Calendar getCreatedAt() {
        return this.m_oDateCreated;
    }

    public Calendar getLastSaved() {
        return this.m_oDateLastSaved;
    }

    private static class CVersionHandler
    extends CSimpleDefaultHandler {
        private static final String WORKFILE_TAG = "fredworkfile";
        private static final String VERSION_NAME = "version";
        private int m_iVersion = 0;

        @Override
        public void startElement(String string, Attributes attributes) throws SAXException {
            if (!WORKFILE_TAG.equals(string)) {
                throw new SAXException("Ung\u00fcltige Arbeitsdatei.");
            }
            String string2 = attributes.getValue(VERSION_NAME);
            if (string2 != null && string2.length() > 0) {
                try {
                    this.m_iVersion = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
            throw new FoundNotification();
        }

        public int getVersion() {
            return this.m_iVersion;
        }

        public static class FoundNotification
        extends RuntimeException {
        }
    }

    public static class CVolatileDataContainer
    extends AChildlessXMLObjectContainer<Long> {
        public static final CVersionedXMLElement XML_TAG = new CVersionedXMLElement("location", 0).add("volatiledata", 1);
        public static final String XML_LOCATION_ATT_POS = "pos";
        private static final int MAX_FILE_SIZE_LENGTH = Long.toString(Long.MAX_VALUE).length();
        private static final String DIVIDER_COMMENT;
        private final File m_oWorkFile;

        CVolatileDataContainer(File file) {
            this.m_oWorkFile = file;
        }

        @Override
        protected Long createContainedObject(Attributes attributes, int n) throws CModelException {
            Long l = Long.valueOf(attributes.getValue(XML_LOCATION_ATT_POS));
            try {
                this._checkVolatileDataPos(l, n);
            }
            catch (IOException iOException) {
                throw new CModelException(iOException);
            }
            return l;
        }

        private static String _createFormatString(int n) throws CModelException {
            return String.format("<%s %s=\"%%0%dd\" />", XML_TAG.getName(n), XML_LOCATION_ATT_POS, new Integer(MAX_FILE_SIZE_LENGTH));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _checkVolatileDataPos(Long l, int n) throws IOException, CModelException {
            String string = CVolatileDataContainer._createFormatString(n);
            String string2 = XML_TAG.getName(n);
            String string3 = String.format("<%s %s=\"", string2, XML_LOCATION_ATT_POS);
            byte[] byArray = new byte[string3.length()];
            long l2 = l - (long)String.format(string, l).length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.m_oWorkFile, "r");
            try {
                randomAccessFile.seek(l2);
                randomAccessFile.readFully(byArray);
            }
            finally {
                randomAccessFile.close();
            }
            if (string3.compareToIgnoreCase(new String(byArray)) != 0) {
                LOGGER.error("<<volatiledata>>");
                LOGGER.error("Gespeicherte Position: {}", (Object)l2);
                LOGGER.error("Gelesen werden soll:   {}", (Object)string3);
                LOGGER.error("Gelesen wurde:         {}", (Object)new String(byArray));
                throw new CModelException("File position in the <" + string2 + ">-Tag does not match!");
            }
        }

        public static long calcAndWriteVolatileDataPos(CSimpleXMLStream cSimpleXMLStream) throws IOException, SAXException {
            String string = CVolatileDataContainer._createFormatString(2);
            cSimpleXMLStream.flushWriter();
            cSimpleXMLStream.getWriter().write("\r\n");
            cSimpleXMLStream.getWriter().write(DIVIDER_COMMENT);
            cSimpleXMLStream.getWriter().write("\r\n ");
            cSimpleXMLStream.flushWriter();
            long l = cSimpleXMLStream.getOutputFilePosition() + (long)String.format(string, new Long(0L)).length();
            cSimpleXMLStream.getWriter().write(String.format(string, new Long(l)));
            return l;
        }

        static {
            try {
                InputStream inputStream = MainController.getResLoader().getResourceStreamExcpt("cfg/VolatileBufferComment.xml");
                DIVIDER_COMMENT = ResourceLoader.convertToString((InputStream)inputStream, (String)"UTF-8", (boolean)true);
            }
            catch (ResourceLoader.ResourceLoadException resourceLoadException) {
                throw new ExceptionInInitializerError(resourceLoadException);
            }
            catch (IOException iOException) {
                throw new ExceptionInInitializerError(iOException);
            }
        }
    }

    private static class CRootXMLizer
    implements IXMLizable {
        public static final String XML_TAG_NAME = "fredworkfile";
        static final CVersionedXMLElement XML_ATT_CREATED = new CVersionedXMLElement("datecreated", 0).add("creationdate", 1);
        static final CVersionedXMLElement XML_ATT_LAST_SAVED = new CVersionedXMLElement("datelastsaved", 0).add("lastcompletesavedate", 1);
        private static final String XML_ATT_VERSION = "version";
        private final CWorkfile mf_oWorkfile;
        private Calendar m_oSaveDate;
        private final boolean mf_bCompleteXMLize;
        private long m_lVolatileDataPosition;

        CRootXMLizer(boolean bl, CWorkfile cWorkfile) {
            this.mf_bCompleteXMLize = bl;
            this.mf_oWorkfile = cWorkfile;
        }

        @Override
        public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
            CExecutionTime cExecutionTime = new CExecutionTime();
            if (this.mf_bCompleteXMLize) {
                cSimpleXMLStream.startElement(XML_TAG_NAME);
                cSimpleXMLStream.addAttribute(XML_ATT_VERSION, Integer.toString(2));
                cSimpleXMLStream.addAttribute(XML_ATT_CREATED.getNewestName(), DateTime.getXMLDateTime(this.mf_oWorkfile.m_oDateCreated));
                this.m_oSaveDate = Calendar.getInstance();
                cSimpleXMLStream.addAttribute(XML_ATT_LAST_SAVED.getNewestName(), DateTime.getXMLDateTime(this.m_oSaveDate));
                cExecutionTime.startTimer();
                new MainController.CXMLRootElementModel().xmlize(cSimpleXMLStream);
                cExecutionTime.stopTimer();
                try {
                    this.m_lVolatileDataPosition = CVolatileDataContainer.calcAndWriteVolatileDataPos(cSimpleXMLStream);
                }
                catch (SAXException sAXException) {
                    throw new CSimpleXMLStream.XmlWriteException(sAXException.getMessage(), sAXException);
                }
                catch (IOException iOException) {
                    throw new CSimpleXMLStream.XmlWriteException(iOException.getMessage(), iOException);
                }
            }
            cExecutionTime.startTimer();
            new MainController.CXMLRootElementView().xmlize(cSimpleXMLStream);
            cExecutionTime.stopTimer();
            cSimpleXMLStream.endElement(XML_TAG_NAME);
        }

        Calendar getSaveDate() {
            return this.m_oSaveDate;
        }

        long getVolatileDataPos() {
            assert (this.mf_bCompleteXMLize);
            return this.m_lVolatileDataPosition;
        }
    }

    private static class CWorkfileContainer
    extends ARootXMLObjectContainer<CWorkfile> {
        private static final String XML_TAG_NAME = "fredworkfile";
        private static final CGUIDataDummy GUIDATA_DUMMY = new CGUIDataDummy();
        boolean m_bLoadingSuccessful = false;
        private File m_oWorkFile = null;

        CWorkfileContainer(File file, int n) {
            super(XML_TAG_NAME, n);
            this.m_oWorkFile = file;
        }

        public boolean loadingSuccessful() {
            return this.m_bLoadingSuccessful;
        }

        @Override
        protected CWorkfile createContainedObject(Attributes attributes, int n) throws CModelException {
            CWorkfile cWorkfile = new CWorkfile();
            cWorkfile.m_oDateCreated = DateTime.parseXMLDateTime(attributes.getValue(CRootXMLizer.XML_ATT_CREATED.getName(n)));
            cWorkfile.m_oDateLastSaved = DateTime.parseXMLDateTime(attributes.getValue(CRootXMLizer.XML_ATT_LAST_SAVED.getName(n)));
            if (n > 0 && n != Integer.parseInt(attributes.getValue("version"))) {
                throw new IllegalStateException("Die zuvor bestimmte Dateiversion stimmt nicht \u00fcberein!");
            }
            return cWorkfile;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) throws CModelException {
            if (string.equals("configuration")) {
                return new WorkFileSettings.CConfigurationContainer();
            }
            if (string.equals("objectfactory")) {
                return new ObjectFactoryImpl.CObjectFactoryContainer();
            }
            if (string.equals("personlist")) {
                return new ObjectFactoryImpl.CPersonListContainer();
            }
            if (string.equals("user")) {
                return new MainController.CUserContainer();
            }
            if (string.equals("urllist")) {
                MainController.getInstance().createURLList();
                return new CURLList.CFactory();
            }
            if (string.equals("projectlist")) {
                return new ProjectList.CProjectListStoreContainer();
            }
            if (string.equals("defaulttask")) {
                return new MainController.CDefaultTaskContainer();
            }
            if (string.equals(CVolatileDataContainer.XML_TAG.getName(n))) {
                return new CVolatileDataContainer(this.m_oWorkFile);
            }
            if (n == 0) {
                return GUIDATA_DUMMY.newChildContainer(string, n);
            }
            if (string.equals("guidata")) {
                return GUIDATA_DUMMY;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void childContainerCompleted(String string, Object object, int n) throws CModelException {
            if (string.equals("objectfactory")) {
                if (ObjectFactoryImpl.getInstance() != null) return;
                throw new CFredAbortException("ObjectFactoryImpl.getInstance() == null");
            }
            if (string.equals("user")) {
                if (MainController.getInstance().getUser() == null) {
                    throw new CFredAbortException("getUser() == null");
                }
                if (MainController.getInstance().getUser() == object) return;
                throw new CFredAbortException("getUser() != oCreated");
            }
            if (string.equals("urllist")) {
                if (object == null) throw new CFredAbortException("m_oURLList == null");
                CURLList cURLList = (CURLList)object;
                MainController.getInstance().getURLList().addAll(cURLList);
                return;
            } else {
                if (string.equals("projectlist")) {
                    if (ProjectList.getInstance() != null) return;
                    throw new CFredAbortException("ProjectList == null");
                }
                if (string.equals("defaulttask")) {
                    if (!DefaultTask.isSet()) {
                        throw new CFredAbortException("DefaultTask.isSet() == false");
                    }
                    if (DefaultTask.get() == object) return;
                    throw new CFredAbortException("DefaultTask.get() != oCreated");
                }
                if (string.equals(CVolatileDataContainer.XML_TAG.getName(n))) {
                    ((CWorkfile)this.m_oObject).m_lViewPosition = (Long)object;
                    return;
                } else {
                    if (n != 0) return;
                    GUIDATA_DUMMY.childContainerCompleted(string, object, n);
                }
            }
        }

        @Override
        protected void completeContainedObject(int n) {
            MainController mainController = MainController.getInstance();
            this.m_bLoadingSuccessful = ProjectList.getInstance() != null && ObjectFactoryImpl.getInstance() != null && mainController.getURLList() != null && mainController.getUser() != null && ((CWorkfile)this.getContainedObject()).m_oDateCreated != null && ((CWorkfile)this.getContainedObject()).m_oDateLastSaved != null;
        }

        static class CGUIDataDummy
        extends ADummyXMLObjectContainer {
            static final String XML_TAG = "guidata";
            long m_lVolatileDataPos;

            CGUIDataDummy() {
            }

            @Override
            protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
                if (string.equals("quickbar")) {
                    return new MainController.CQuickbarContainer();
                }
                if (string.equals("views")) {
                    return new MainController.CViewsContainer();
                }
                return null;
            }

            @Override
            protected void childContainerCompleted(String string, Object object, int n) {
                if (string.equals("quickbar")) {
                    QuickBar.getInstance().setDockingBorder((DockedWindow.DockingBorder)object);
                }
            }
        }
    }
}

