/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling;

import com.mayastudios.fred.client.filehandling.UserMode;
import com.mayastudios.launcher.AppInfo;
import com.mayastudios.systeminfo.SystemInfo;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryUtil {
    private static final File INSTALL_DIR = new File(AppInfo.getAppPath()).getAbsoluteFile();
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryUtil.class);
    private static final File APP_CONFIG_PATH = new File(INSTALL_DIR, "config");
    private static final File USER_CONFIG_PATH;

    public static File getHomeDirectory() {
        return new File(System.getProperty("user.home")).getAbsoluteFile();
    }

    public static File getDocumentsDirectory() {
        switch (SystemInfo.OSTYPE) {
            case Windows: {
                return WindowsSpecialFolders.MyDocuments.getPath();
            }
        }
        File file = new File(DirectoryUtil.getHomeDirectory(), "Documents");
        if (file.isDirectory()) {
            return file;
        }
        return DirectoryUtil.getHomeDirectory();
    }

    public static File getInstallDirectory() {
        return INSTALL_DIR;
    }

    public static File getDefaultFileChooserDir() {
        return DirectoryUtil.getDocumentsDirectory();
    }

    public static File getAppConfigDir() {
        if (APP_CONFIG_PATH.exists() || APP_CONFIG_PATH.mkdirs()) {
            return APP_CONFIG_PATH;
        }
        LOGGER.warn("Could not create application config directory.");
        return null;
    }

    public static File getUserConfigDir() {
        if (USER_CONFIG_PATH.exists() || USER_CONFIG_PATH.mkdirs()) {
            return USER_CONFIG_PATH;
        }
        LOGGER.warn("Could not create user config directory.");
        return null;
    }

    static {
        if (!UserMode.isMultiUserMode()) {
            USER_CONFIG_PATH = APP_CONFIG_PATH;
        } else {
            switch (SystemInfo.OSTYPE) {
                case Windows: {
                    String string = System.getenv("APPDATA");
                    if (string != null) {
                        USER_CONFIG_PATH = new File(string, "Fred").getAbsoluteFile();
                        break;
                    }
                    USER_CONFIG_PATH = new File(DirectoryUtil.getHomeDirectory(), "Fred");
                    break;
                }
                case Linux: 
                case Solaris: {
                    USER_CONFIG_PATH = new File(DirectoryUtil.getHomeDirectory(), ".fred");
                    break;
                }
                case MacOS: {
                    USER_CONFIG_PATH = new File(DirectoryUtil.getHomeDirectory(), "/Library/Application Support/Fred");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected OS type: " + SystemInfo.OSTYPE);
                }
            }
            LOGGER.info("APP_CONFIG_PATH:   {}", (Object)APP_CONFIG_PATH);
            LOGGER.info("USER_CONFIG_PATH:  {}", (Object)USER_CONFIG_PATH);
        }
    }

    public static enum WindowsSpecialFolders {
        ApplicationData(26),
        LocalApplicationData(28),
        CommonAppData(35),
        MyDocuments(5),
        MyPictures(39),
        CommonDocuments(46),
        Windows(36),
        System(37),
        ProgramFiles(38),
        CommonProgramFiles(43),
        Fonts(20);

        private static final int MAX_PATH = 260;
        private final int m_csidl;

        private WindowsSpecialFolders(int n2) {
            this.m_csidl = n2;
        }

        public File getPath() {
            return new File(this.toString()).getAbsoluteFile();
        }

        public String toString() {
            char[] cArray = new char[260];
            WindowsSpecialFolders.SHGetFolderPathW(null, this.m_csidl, null, 0, cArray);
            return Native.toString((char[])cArray);
        }

        private static native int SHGetFolderPathW(Pointer var0, int var1, Pointer var2, int var3, char[] var4);

        static {
            Native.register((String)"shell32");
        }
    }
}

