/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.fred.client.resources.configfile.XmlConfigFile;
import java.io.File;
import java.io.IOException;

public class LastWorkFileInfo {
    private static final String INFO_FILE_NAME = "Recent.xml";
    private static final File INFO_FILE_PATH;
    private static final String RECENT_PATH_KEY = "recentPath";
    private static final LastWorkFileInfo INSTANCE;
    private final XmlConfigFile m_infoFile;
    private File m_lastOpenedWorkFilePath;

    private LastWorkFileInfo() {
        if (INFO_FILE_PATH != null) {
            this.m_infoFile = new XmlConfigFile(INFO_FILE_PATH);
            String string = this.m_infoFile.getAsString(RECENT_PATH_KEY);
            this.m_lastOpenedWorkFilePath = string == null || string.trim().length() == 0 ? null : new File(string).getAbsoluteFile();
        } else {
            this.m_infoFile = null;
            this.m_lastOpenedWorkFilePath = null;
        }
    }

    public static File getLastOpenedWorkFilePath() {
        return LastWorkFileInfo.INSTANCE.m_lastOpenedWorkFilePath;
    }

    public static void setLastOpenedWorkFilePath(File file) {
        LastWorkFileInfo.INSTANCE.m_lastOpenedWorkFilePath = file;
        if (LastWorkFileInfo.INSTANCE.m_infoFile == null) {
            MainController.LOGGER.warn("No access to info file.");
            return;
        }
        if (file != null) {
            LastWorkFileInfo.INSTANCE.m_infoFile.set(RECENT_PATH_KEY, file.getAbsolutePath());
        } else {
            LastWorkFileInfo.INSTANCE.m_infoFile.set(RECENT_PATH_KEY, null);
        }
        try {
            LastWorkFileInfo.INSTANCE.m_infoFile.storeToXML();
        }
        catch (IOException iOException) {
            MainController.LOGGER.warn("Could not write 'recent.xml'.", (Throwable)iOException);
        }
    }

    static {
        File file = DirectoryUtil.getUserConfigDir();
        INFO_FILE_PATH = file == null ? null : new File(file, INFO_FILE_NAME);
        INSTANCE = new LastWorkFileInfo();
    }
}

