/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CEffortVector;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import com.mayastudios.fred.client.util.avltree.AVLTree;
import java.util.Iterator;

public class CEffortTree
extends AVLTree<CEffortImpl>
implements IXMLizable {
    public CEffortTree() {
        super(CEffortImpl.class);
    }

    @Override
    public boolean add(CEffortImpl cEffortImpl) {
        return super.add(cEffortImpl);
    }

    public boolean remove(CEffortImpl cEffortImpl) {
        return super.remove(cEffortImpl);
    }

    public void getContainedEffortsFiltered(AFilter aFilter, CEffortVector cEffortVector, AFilter.EFilterMode eFilterMode) {
        switch (eFilterMode) {
            case FullFilter: {
                CEffortImpl cEffortImpl;
                CEffortImpl cEffortImpl2 = aFilter.getComparableLeft();
                if (cEffortImpl2 == null) {
                    cEffortImpl2 = (CEffortImpl)super.first();
                }
                if ((cEffortImpl = aFilter.getComparableRight()) == null) {
                    cEffortImpl = (CEffortImpl)super.last();
                }
                Iterator<CEffortImpl> iterator = super.iteratorUpBetween(cEffortImpl2, cEffortImpl);
                while (iterator.hasNext()) {
                    CEffortImpl cEffortImpl3 = iterator.next();
                    if (!cEffortImpl3.passesFilterFull(aFilter)) continue;
                    cEffortVector.add(cEffortImpl3);
                }
                break;
            }
            case CollidingFilter: {
                CEffortImpl cEffortImpl;
                CEffortImpl cEffortImpl4 = aFilter.getComparableLeft();
                if (cEffortImpl4 == null) {
                    cEffortImpl4 = (CEffortImpl)super.first();
                }
                if ((cEffortImpl = aFilter.getComparableRight()) == null) {
                    cEffortImpl = (CEffortImpl)super.last();
                }
                Iterator<CEffortImpl> iterator = super.iteratorUpBetween(cEffortImpl4, cEffortImpl);
                while (iterator.hasNext()) {
                    CEffortImpl cEffortImpl5 = iterator.next();
                    if (!cEffortImpl5.passesFilterColliding(aFilter)) continue;
                    cEffortVector.add(cEffortImpl5);
                }
                break;
            }
            case TaskFilter: {
                Iterator iterator = super.iteratorUpAll();
                while (iterator.hasNext()) {
                    CEffortImpl cEffortImpl = (CEffortImpl)iterator.next();
                    if (!cEffortImpl.passesFilterTasks(aFilter)) continue;
                    cEffortVector.add(cEffortImpl);
                }
                break;
            }
            case CategoryFilter: {
                Iterator iterator = super.iteratorUpAll();
                while (iterator.hasNext()) {
                    CEffortImpl cEffortImpl = (CEffortImpl)iterator.next();
                    if (!cEffortImpl.passesFilterCategories(aFilter)) continue;
                    cEffortVector.add(cEffortImpl);
                }
                break;
            }
            case NoFilter: {
                Iterator iterator = super.iteratorUpAll();
                while (iterator.hasNext()) {
                    cEffortVector.add((CEffortImpl)iterator.next());
                }
                break;
            }
        }
    }

    public void discoverSemanticConflicts(CEffortImpl cEffortImpl) {
        Object object;
        Iterator<CEffortImpl> iterator = super.iteratorUpLarger(cEffortImpl);
        while (iterator.hasNext() && ((object = iterator.next()) == cEffortImpl || cEffortImpl.isOverlapping((CEffortImpl)object))) {
        }
        object = super.iteratorDown(cEffortImpl);
        while (object.hasNext()) {
            CEffortImpl cEffortImpl2 = (CEffortImpl)object.next();
            cEffortImpl.isOverlapping(cEffortImpl2);
            if (cEffortImpl.getPerson() != cEffortImpl2.getPerson() || cEffortImpl2 == cEffortImpl || cEffortImpl2.isColliding() && cEffortImpl2.hasMoreOverlappers(cEffortImpl)) continue;
            break;
        }
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        Iterator iterator = super.iteratorUpAll();
        boolean bl = WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.SaveNotAcceptedEfforts);
        if (!bl) {
            while (iterator.hasNext()) {
                CEffortImpl cEffortImpl = (CEffortImpl)iterator.next();
                if (cEffortImpl.getAccepted() == CEffortImpl.EAccepted.NotAccepted) continue;
                cEffortImpl.xmlize(cSimpleXMLStream);
            }
        } else {
            while (iterator.hasNext()) {
                ((CEffortImpl)iterator.next()).xmlize(cSimpleXMLStream);
            }
        }
    }
}

