/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import com.mayastudios.fred.client.view.dialogs.textfields.CDateTextfield;
import com.mayastudios.fred.client.view.dialogs.textfields.CTimeTextfield;
import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.labels.LabelsCore;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class DateTime {
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final char DAY_SYMBOL = 'd';
    private static DateFormat ms_oDateFormatter;
    private static DateFormat ms_oTimeFormatter;
    private static DateFormat ms_oDateTimeFormatter;
    private static String ms_oDateFormatPattern;
    private static String ms_oTimeFormatPattern;
    private static String ms_oReadableDateFormatPattern;
    private static String ms_oReadableTimeFormatPattern;
    private static final String ms_oDurationFormatPattern = "hh:mm";
    private static String ms_oParseableDate;
    private static final SimpleDateFormat MONTH_YEAR_FORMAT;
    private static final SimpleDateFormat DAY_OF_WEEK_FORMAT;
    private static final String FORMAT_MILLISECOND_DURATION = "%02d:%02d.%03d";
    private static final Pattern DURATION_PATTERN;

    public static String getDateFormatPattern() {
        return ms_oDateFormatPattern;
    }

    public static String getReadableDateFormatPattern() {
        return ms_oReadableDateFormatPattern;
    }

    public static String getTimeFormatPattern() {
        return ms_oTimeFormatPattern;
    }

    public static String getReadableTimeFormatPattern() {
        return ms_oReadableTimeFormatPattern;
    }

    public static String getDurationFormatPattern() {
        return ms_oDurationFormatPattern;
    }

    public static String getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return ms_oDateFormatter.format(calendar.getTime());
    }

    public static String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        return ms_oTimeFormatter.format(calendar.getTime());
    }

    public static boolean isValidTimeFormat(String string) {
        return DateTime.getCalendar(ms_oParseableDate, string) != null;
    }

    public static boolean isValidDateFormat(String string) {
        return DateTime.getCalendar(string) != null;
    }

    public static Calendar getCalendar(String string, String string2) {
        ParsePosition parsePosition;
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = string + " " + string2;
        Date date = ms_oDateTimeFormatter.parse(string3, parsePosition = new ParsePosition(0));
        if (date == null || parsePosition.getIndex() != string3.length()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar getCalendar(String string) {
        Date date = null;
        Calendar calendar = null;
        if (string == null) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        date = ms_oDateFormatter.parse(string, parsePosition);
        if (date == null || parsePosition.getIndex() != string.length()) {
            return null;
        }
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int calculateDurationInt(Calendar calendar, Calendar calendar2) {
        long l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
        return (int)(l /= 60000L);
    }

    public static String getDateString(Calendar calendar) {
        return ms_oDateFormatter.format(calendar.getTime());
    }

    public static String getTimeString(Calendar calendar) {
        return ms_oTimeFormatter.format(calendar.getTime());
    }

    public static String getDateTimeString(Calendar calendar) {
        return ms_oDateTimeFormatter.format(calendar.getTime());
    }

    public static String getMonthYearString(Calendar calendar) {
        return MONTH_YEAR_FORMAT.format(calendar.getTime());
    }

    public static String getDayOfWeekString(Calendar calendar) {
        return DAY_OF_WEEK_FORMAT.format(calendar.getTime());
    }

    public static Calendar getEndDateByDuration(Calendar calendar, int n) {
        Calendar calendar2 = null;
        calendar2 = (Calendar)calendar.clone();
        calendar2.add(12, n);
        return calendar2;
    }

    public static Calendar getEndDateByDuration(long l, int n) {
        Calendar calendar = DateTime.createCalendar(l);
        calendar.add(12, n);
        return calendar;
    }

    public static String getDurationString(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n3 = n / 60;
        n2 = n % 60;
        n5 = n3 / 24;
        n4 = n3 % 24;
        if (n5 == 0) {
            bl = false;
        }
        if (bl) {
            return String.format("%d%c %02d:%02d", new Integer(n5), new Character('d'), new Integer(n4), new Integer(n2));
        }
        return String.format("%02d:%02d", new Integer(n3), new Integer(n2));
    }

    public static String getExactDurationString(long l) {
        long l2 = l / 60000L;
        long l3 = (l - l2 * 60000L) / 1000L;
        long l4 = l - l2 * 60000L - l3 * 1000L;
        return String.format(FORMAT_MILLISECOND_DURATION, new Long(l2), new Long(l3), new Long(l4));
    }

    public static int getDurationInt(String string) {
        int n;
        int n2;
        Matcher matcher = DURATION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return -1;
        }
        try {
            n2 = Integer.parseInt(matcher.group(1));
            n = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n2 * 60 + n;
    }

    public static Calendar createCalendar(long l) {
        if (l < 0L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return calendar;
    }

    public static Calendar getCalendar(CDateTextfield cDateTextfield, CTimeTextfield cTimeTextfield) {
        Calendar calendar = cDateTextfield.getAsCalendar();
        Calendar calendar2 = cTimeTextfield.getAsCalendar();
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.clear(13);
        calendar.clear(14);
        return calendar;
    }

    public static String getXMLDateTime(Calendar calendar) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(calendar.getTime());
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar).toXMLFormat();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
    }

    public static String getCurrentXMLDateTime() {
        return DateTime.getXMLDateTime(Calendar.getInstance());
    }

    public static Calendar parseXMLDateTime(String string) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(string).toGregorianCalendar();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            return null;
        }
    }

    static {
        FormatRefresher.recreateFormatter();
        LabelsCore.addLabelsChangeListener((LabelsCore.ILabelsChangeListener)new FormatRefresher(), (BaseEventManager.ERefType)BaseEventManager.ERefType.REGULAR);
        MONTH_YEAR_FORMAT = new SimpleDateFormat("MMMMM yy");
        DAY_OF_WEEK_FORMAT = new SimpleDateFormat("E");
        DURATION_PATTERN = Pattern.compile("(\\d+)\\:(\\d+)");
    }

    private static class FormatRefresher
    implements LabelsCore.ILabelsChangeListener {
        public void labelsChanged(boolean bl) {
            if (bl) {
                FormatRefresher.recreateFormatter();
            }
        }

        public static void recreateFormatter() {
            Locale locale = LabelsCore.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ms_oDateFormatter = DateFormat.getDateInstance(3, locale);
            ms_oTimeFormatter = DateFormat.getTimeInstance(3, locale);
            ms_oDateTimeFormatter = DateFormat.getDateTimeInstance(3, 3, locale);
            ms_oDateFormatter.setLenient(false);
            ms_oTimeFormatter.setLenient(false);
            ms_oDateTimeFormatter.setLenient(false);
            ms_oDateFormatPattern = ((SimpleDateFormat)ms_oDateFormatter).toPattern();
            ms_oReadableDateFormatPattern = ms_oDateFormatPattern.toLowerCase();
            ms_oTimeFormatPattern = ((SimpleDateFormat)ms_oTimeFormatter).toPattern();
            ms_oReadableTimeFormatPattern = ms_oTimeFormatPattern.toLowerCase();
            ms_oParseableDate = ms_oDateFormatter.format(new Date());
        }
    }
}

