/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.fred.client.filehandling.filefilter.CPDFFilter;
import com.mayastudios.fred.client.resources.GlobalSettings;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.ManualHelper;
import com.mayastudios.fred.client.view.dialogs.ADialogEx2;
import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.IXMLException;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.ixml.document.IXMLDocument;
import com.mayastudios.ixml.document.parser.IXMLParser;
import com.mayastudios.mscl.mwt.widgets.filechooser.CExecFileFilter;
import com.mayastudios.mscl.mwt.widgets.filechooser.FileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class CDlgExtrasGlobalSettings
extends ADialogEx2 {
    private static final IXMLDocument DIALOG;
    private static final String[] LINUX_PDFVIEWER_NAMES;
    private final JRadioButton mf_oUserGuideAutoButton;
    private final JRadioButton mf_oUserGuideManualButton;
    private final JTextField mf_oUserGuidePath;
    private final JButton mf_oUserGuidePathButton;
    private final JRadioButton mf_oPDFReaderAutoButton;
    private final JRadioButton mf_oPDFReaderChooseButton;
    private final JRadioButton mf_oPDFReaderManualButton;
    private final JComboBox mf_oPDFReaderComboBox;
    private final JTextField mf_oPDFReaderPath;
    private final JButton mf_oPDFReaderPathButton;

    public CDlgExtrasGlobalSettings() throws IXMLError, IXMLException {
        super(DIALOG, null);
        this.setTitleAreaSubTitle(String.format(this.getTitleAreaSubTitle(), System.getProperty("user.name")));
        CListener cListener = new CListener();
        this.mf_oUserGuideAutoButton = (JRadioButton)this.getComponentSafeByID("userguide-auto-radio");
        this.mf_oUserGuideManualButton = (JRadioButton)this.getComponentSafeByID("userguide-manual-radio");
        this.mf_oUserGuidePath = (JTextField)this.getComponentSafeByID("userguide-file");
        this.mf_oUserGuidePathButton = (JButton)this.getComponentSafeByID("userguide-browse");
        this.mf_oUserGuideAutoButton.addActionListener(cListener);
        this.mf_oUserGuideManualButton.addActionListener(cListener);
        this.mf_oUserGuidePathButton.addActionListener(cListener);
        this.mf_oPDFReaderAutoButton = (JRadioButton)this.getComponentSafeByID("pdfviewer-auto-radio");
        this.mf_oPDFReaderChooseButton = (JRadioButton)this.getComponentSafeByID("pdfviewer-choose-radio");
        this.mf_oPDFReaderManualButton = (JRadioButton)this.getComponentSafeByID("pdfviewer-manual-radio");
        this.mf_oPDFReaderComboBox = (JComboBox)this.getComponentSafeByID("pdfviewer-choose-combo");
        this.mf_oPDFReaderPath = (JTextField)this.getComponentSafeByID("pdfviewer-file");
        this.mf_oPDFReaderPathButton = (JButton)this.getComponentSafeByID("pdfviewer-browse");
        this.mf_oPDFReaderAutoButton.addActionListener(cListener);
        this.mf_oPDFReaderChooseButton.addActionListener(cListener);
        this.mf_oPDFReaderManualButton.addActionListener(cListener);
        this.mf_oPDFReaderPathButton.addActionListener(cListener);
        this.mf_oPDFReaderComboBox.setModel(new DefaultComboBoxModel<String>(LINUX_PDFVIEWER_NAMES));
        String string = GlobalSettings.getManualPath();
        if ("".equals(string)) {
            this.mf_oUserGuideAutoButton.setSelected(true);
        } else {
            this.mf_oUserGuideManualButton.setSelected(true);
            this.mf_oUserGuidePath.setText(string);
        }
        String string2 = GlobalSettings.getPDFReaderPath();
        if ("".equals(string2) && ManualHelper.isPDFReaderAutoDetectionSupported()) {
            this.mf_oPDFReaderAutoButton.setSelected(true);
        } else if (SystemInfo.OSTYPE == SystemInfo.EOSType.Linux) {
            int n = this._findLinuxPDFReader(string2);
            if (n != -1) {
                this.mf_oPDFReaderComboBox.setSelectedIndex(n);
                this.mf_oPDFReaderChooseButton.setSelected(true);
            } else {
                this.mf_oPDFReaderPath.setText(string2);
                this.mf_oPDFReaderManualButton.setSelected(true);
            }
        } else {
            this.mf_oPDFReaderPath.setText(string2);
            this.mf_oPDFReaderManualButton.setSelected(true);
        }
        this.mf_oPDFReaderAutoButton.setEnabled(ManualHelper.isPDFReaderAutoDetectionSupported());
        this.mf_oPDFReaderChooseButton.setEnabled(SystemInfo.OSTYPE == SystemInfo.EOSType.Linux);
        this.handleControlState();
    }

    protected boolean onOK() {
        if (this.mf_oUserGuideAutoButton.isSelected() || this.mf_oUserGuidePath.getText().length() == 0) {
            GlobalSettings.setManualPath("");
        } else {
            GlobalSettings.setManualPath(this.mf_oUserGuidePath.getText());
        }
        if (this.mf_oPDFReaderAutoButton.isSelected() || !this.mf_oPDFReaderChooseButton.isSelected() && this.mf_oPDFReaderPath.getText().length() == 0) {
            GlobalSettings.setPDFReaderPath("");
        } else if (this.mf_oPDFReaderChooseButton.isSelected()) {
            GlobalSettings.setPDFReaderPath(ManualHelper.LINUX_PDFVIEWER[this.mf_oPDFReaderComboBox.getSelectedIndex()][1]);
        } else {
            GlobalSettings.setPDFReaderPath(this.mf_oPDFReaderPath.getText());
        }
        GlobalSettings.saveGlobalSettings();
        return true;
    }

    private int _findLinuxPDFReader(String string) {
        for (int i = 0; i < ManualHelper.LINUX_PDFVIEWER.length; ++i) {
            if (!ManualHelper.LINUX_PDFVIEWER[i][1].equals(string)) continue;
            return i;
        }
        return -1;
    }

    void handleControlState() {
        if (this.mf_oUserGuideAutoButton.isSelected()) {
            this.mf_oUserGuidePath.setEnabled(false);
            this.mf_oUserGuidePathButton.setEnabled(false);
        } else {
            this.mf_oUserGuidePath.setEnabled(true);
            this.mf_oUserGuidePathButton.setEnabled(true);
        }
        if (this.mf_oPDFReaderAutoButton.isSelected()) {
            this.mf_oPDFReaderComboBox.setEnabled(false);
            this.mf_oPDFReaderPath.setEnabled(false);
            this.mf_oPDFReaderPathButton.setEnabled(false);
        } else if (this.mf_oPDFReaderChooseButton.isSelected()) {
            this.mf_oPDFReaderComboBox.setEnabled(true);
            this.mf_oPDFReaderPath.setEnabled(false);
            this.mf_oPDFReaderPathButton.setEnabled(false);
        } else {
            this.mf_oPDFReaderComboBox.setEnabled(false);
            this.mf_oPDFReaderPath.setEnabled(true);
            this.mf_oPDFReaderPathButton.setEnabled(true);
        }
    }

    static {
        try {
            DIALOG = IXMLParser.parseIXML((InputStream)MainController.getResLoader().getResourceStreamExcpt("ixml/global-options.xml"));
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        LINUX_PDFVIEWER_NAMES = new String[ManualHelper.LINUX_PDFVIEWER.length];
        for (int i = 0; i < ManualHelper.LINUX_PDFVIEWER.length; ++i) {
            CDlgExtrasGlobalSettings.LINUX_PDFVIEWER_NAMES[i] = ManualHelper.LINUX_PDFVIEWER[i][0];
        }
    }

    class CListener
    implements ActionListener {
        CListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CDlgExtrasGlobalSettings.this.mf_oUserGuidePathButton) {
                File file = FileChooser.showFileChooser((Component)((Object)CDlgExtrasGlobalSettings.this), (String)Labels.get("CHOOSE_USERGUIDE_DESTINATION", new Object[0]), (String)Labels.get("Text.OK", new Object[0]), (String)DirectoryUtil.getInstallDirectory().getAbsolutePath(), (FileFilter[])new FileFilter[]{new CPDFFilter()});
                if (file != null) {
                    String string = file.getAbsolutePath();
                    CDlgExtrasGlobalSettings.this.mf_oUserGuidePath.setText(string);
                }
            } else if (actionEvent.getSource() == CDlgExtrasGlobalSettings.this.mf_oPDFReaderPathButton) {
                File file = FileChooser.showFileChooser((Component)((Object)CDlgExtrasGlobalSettings.this), (String)Labels.get("CHOOSE_PDFVIEWER_DESTINATION", new Object[0]), (String)Labels.get("Text.OK", new Object[0]), (String)DirectoryUtil.getInstallDirectory().getAbsolutePath(), (FileFilter[])new FileFilter[]{new CExecFileFilter(Labels.get("EXEC_FILEFILTER_DESCRIPTION", new Object[0]), false)});
                if (file != null) {
                    String string = file.getAbsolutePath();
                    CDlgExtrasGlobalSettings.this.mf_oPDFReaderPath.setText(string);
                }
            } else {
                CDlgExtrasGlobalSettings.this.handleControlState();
            }
        }
    }
}

