/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.grafics;

import java.awt.Color;
import java.awt.color.ColorSpace;

public class CColorEx
extends Color
implements Cloneable {
    private static final long serialVersionUID = 1L;

    public CColorEx(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public CColorEx(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public CColorEx(int n) {
        super(n);
    }

    public CColorEx(int n, boolean bl) {
        super(n, bl);
    }

    public CColorEx(float f, float f2, float f3) {
        super(f, f2, f3);
    }

    public CColorEx(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    public CColorEx(ColorSpace colorSpace, float[] fArray, float f) {
        super(colorSpace, fArray, f);
    }

    public CColorEx(Color color) {
        super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public CColorEx(Color color, int n) {
        super(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public CColorEx brighter(int n) {
        if (n == 0) {
            return this.clone();
        }
        int n2 = CColorEx.correctComponent(this.getRed() + n);
        int n3 = CColorEx.correctComponent(this.getGreen() + n);
        int n4 = CColorEx.correctComponent(this.getBlue() + n);
        return new CColorEx(n2, n3, n4, this.getAlpha());
    }

    public CColorEx darker(int n) {
        return this.brighter(-n);
    }

    public CColorEx mix(Color color, int n) {
        return CColorEx.mix(this, color, n);
    }

    public CColorEx mix(Color color, float f, int n) {
        return CColorEx.mix(this, color, f, n);
    }

    public static CColorEx mix(Color color, Color color2, int n) {
        return CColorEx.mix(color, color2, 0.5f, n);
    }

    public static CColorEx mix(Color color, Color color2, float f, int n) {
        assert (n >= 0 && n <= 255);
        float f2 = 1.0f - f;
        int n2 = (int)((float)color.getRed() * f2 + (float)color2.getRed() * f);
        int n3 = (int)((float)color.getGreen() * f2 + (float)color2.getGreen() * f);
        int n4 = (int)((float)color.getBlue() * f2 + (float)color2.getBlue() * f);
        return new CColorEx(CColorEx.correctComponent(n2), CColorEx.correctComponent(n3), CColorEx.correctComponent(n4), n);
    }

    public final CColorEx invertColor() {
        return CColorEx.invertColor(this);
    }

    public static CColorEx invertColor(Color color) {
        return new CColorEx(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public CColorEx clone() {
        return new CColorEx(this);
    }

    public static final int correctComponent(int n) {
        if (n <= 0) {
            return 0;
        }
        if (n >= 255) {
            return 255;
        }
        return n;
    }

    public static final int assambleCorrectedRGBAValue(int n, int n2, int n3, int n4) {
        return CColorEx.assambleRGBAValue(CColorEx.correctComponent(n), CColorEx.correctComponent(n2), CColorEx.correctComponent(n3), CColorEx.correctComponent(n4));
    }

    public static final int assambleRGBAValue(int n, int n2, int n3, int n4) {
        assert (n >= 0 && n <= 255);
        assert (n2 >= 0 && n2 <= 255);
        assert (n3 >= 0 && n3 <= 255);
        assert (n4 >= 0 && n4 <= 255);
        return (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
    }

    public static final int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public static final int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public static final int getBlue(int n) {
        return n >> 0 & 0xFF;
    }

    public static final int getAlpha(int n) {
        return n >> 24 & 0xFF;
    }
}

