/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.tablelayout;

import com.mayastudios.mscl.mwt.tablelayout.ABaseCell;
import com.mayastudios.mscl.mwt.tablelayout.APreLayoutElement;
import com.mayastudios.mscl.mwt.tablelayout.ArrangeHelper;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellAutoGlue;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellAutoWidth;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellBind;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellFixedWidth;
import com.mayastudios.mscl.mwt.tablelayout.IArrangeInfo;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;

abstract class ABaseRow
extends APreLayoutElement {
    private final Vector<ABaseCell> m_oCellList = new Vector();
    private boolean m_bIsCellPreLayoutComplete = false;

    ABaseRow() {
    }

    abstract ERowType getType();

    final void addCell(ABaseCell aBaseCell) {
        assert (aBaseCell != null);
        aBaseCell.setContainingRow(this);
        assert (!(aBaseCell.getType() == ABaseCell.ECellType.BIND_CELL && ((CInternalCellBind)aBaseCell).getBoundCell().getContainingRow() == this)) : "You cannot bind a cell to another cell in the same row";
        this.m_oCellList.add(aBaseCell);
    }

    final void setFirstCellElement(Component component) {
        this.m_oCellList.firstElement().setAttachedElement(component);
    }

    final ABaseCell getFirstCell() {
        return this.m_oCellList.firstElement();
    }

    final boolean removeCell(Component component) {
        int n = 0;
        for (ABaseCell aBaseCell : this.m_oCellList) {
            if (aBaseCell.getAttachedElement() == component) {
                this.m_oCellList.removeElementAt(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    int getMinimumHeight() {
        int n = 0;
        for (ABaseCell aBaseCell : this.m_oCellList) {
            int n2 = aBaseCell.getMinimumCellHeight();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    int getPreferredHeight() {
        int n = 0;
        for (ABaseCell aBaseCell : this.m_oCellList) {
            int n2 = aBaseCell.getPreferredCellHeight();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    final void invalidateCellBoundaries() {
        Iterator<ABaseCell> iterator = this.m_oCellList.iterator();
        while (iterator.hasNext()) {
            iterator.next().invalidatePreLayout();
        }
        this.m_bIsCellPreLayoutComplete = false;
        this.invalidatePreLayout();
    }

    final void layoutCells(Rectangle rectangle) {
        this.preLayoutCellBoundaries(rectangle.x, rectangle.width, null);
        Iterator<ABaseCell> iterator = this.m_oCellList.iterator();
        Rectangle rectangle2 = new Rectangle();
        while (iterator.hasNext()) {
            ABaseCell aBaseCell = iterator.next();
            rectangle2.setBounds(aBaseCell.getPreLayoutPosition(), rectangle.y, aBaseCell.getPreLayoutSize(), rectangle.height);
            aBaseCell.layoutElement(rectangle2);
        }
    }

    final int preLayoutCellBoundaries(int n, int n2, ABaseCell aBaseCell) {
        int n3;
        ABaseCell aBaseCell2;
        int n4;
        Iterator<ABaseCell> iterator;
        Vector<IArrangeInfo> vector;
        Vector<IArrangeInfo> vector2;
        Vector<IArrangeInfo> vector3;
        block20: {
            if (this.m_bIsCellPreLayoutComplete) {
                return -1;
            }
            if (this.m_oCellList.size() == 0) {
                this.m_bIsCellPreLayoutComplete = true;
                return -1;
            }
            vector3 = new Vector<IArrangeInfo>();
            vector2 = new Vector<IArrangeInfo>();
            vector = new Vector<IArrangeInfo>();
            iterator = this.m_oCellList.iterator();
            n4 = n;
            do {
                assert (iterator.hasNext());
                aBaseCell2 = iterator.next();
                if (!aBaseCell2.isPreLayouted()) break block20;
                n4 += aBaseCell2.getPreLayoutSize();
            } while (aBaseCell2 != aBaseCell);
            return n4;
        }
        int n5 = n4 - n;
        while (true) {
            n3 = aBaseCell2.getPreferredCellWidth(n4, n, n2);
            aBaseCell2.setPreLayout(n4, n3);
            if (aBaseCell2 == aBaseCell) {
                return n4 + n3;
            }
            switch (aBaseCell2.getType()) {
                case AUTO_WIDTH_CELL: {
                    vector2.add((CInternalCellAutoWidth)aBaseCell2);
                    break;
                }
                case FIXED_WIDTH_CELL: {
                    vector.add((CInternalCellFixedWidth)aBaseCell2);
                    break;
                }
                case AUTO_GLUE_CELL: {
                    if (aBaseCell2.getAttachedElement() == null || !aBaseCell2.getAttachedElement().isVisible()) break;
                    vector3.add((CInternalCellAutoGlue)aBaseCell2);
                    break;
                }
                case BIND_CELL: 
                case AUTO_WIDTH_BIND_TARGET_CELL: {
                    vector3.clear();
                    vector.clear();
                    vector2.clear();
                }
            }
            n5 += n3;
            n4 += n3;
            if (!iterator.hasNext()) break;
            aBaseCell2 = iterator.next();
        }
        n3 = 0;
        if (n2 > n5 && vector3.size() > 0) {
            ArrangeHelper.expandElements(vector3, n2 - n5);
            n3 = 1;
        } else if (n2 < n5) {
            int n6 = n5 - n2;
            if (vector3.size() > 0) {
                n6 = ArrangeHelper.shrinkElements(vector3, n6);
                n3 = 1;
            }
            if (vector2.size() > 0) {
                n6 = ArrangeHelper.shrinkElements(vector2, n6);
                n3 = 1;
            }
            if (vector.size() > 0) {
                n6 = ArrangeHelper.shrinkElements(vector, n6);
                n3 = 1;
            }
        }
        if (n3 == 1) {
            n4 = n;
            for (ABaseCell aBaseCell3 : this.m_oCellList) {
                int n7 = aBaseCell3.getPreLayoutSize();
                aBaseCell3.setPreLayout(n4, n7);
                n4 += n7;
            }
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ERowType {
        AUTO_HEIGHT_ROW,
        AUTO_GLUE_ROW,
        FIXED_HEIGHT_ROW;

    }
}

