/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.IXMLException;
import com.mayastudios.ixml.document.IXMLPanel;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.EIXMLType;
import com.mayastudios.ixml.document.comp.base.IXMLBaseContainer;
import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.document.comp.base.IXMLComponentGridContainer;
import com.mayastudios.ixml.document.comp.impl.FlexPanel;
import com.mayastudios.ixml.document.parser.IXMLTagHandler;
import com.mayastudios.ixml.misc.IntVector;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.xml.sax.Attributes;

public class IXMLGridNode
extends IXMLBaseContainer {
    private boolean m_bColumnsAdded = false;
    private boolean m_bRowsAdded = false;

    public IXMLGridNode(String p_strID) {
        super(EIXMLType.GRID, p_strID);
    }

    protected JComponent createComponentImpl(IXMLBaseElement.InfoStack p_oInfoStack, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError, IXMLException {
        LinkedList<IXMLBaseElement> oChildElements = this.getChildElements();
        LinkedList<IXMLBaseElement> oColumns = null;
        LinkedList<IXMLBaseElement> oRows = null;
        int iIndex = 0;
        int iColumnCount = 0;
        for (IXMLBaseElement oElement : oChildElements) {
            if (oElement instanceof IXMLColumns) {
                oColumns = oElement.getChildElements();
                continue;
            }
            if (oElement instanceof IXMLRows) {
                oRows = oElement.getChildElements();
                continue;
            }
            throw new IllegalStateException("Unknown child element.");
        }
        if (oRows == null) {
            return new IXMLPanel();
        }
        IntVector oColumnsFlexValues = new IntVector(10);
        if (oColumns != null) {
            iIndex = 0;
            for (IXMLBaseElement oElement : oColumns) {
                Integer oFlexValue = oElement.getAttributeAsInt(EIXMLAttrib.FLEX);
                if (oFlexValue != null) {
                    oColumnsFlexValues.setElementAt(oFlexValue, iIndex);
                }
                ++iColumnCount;
                ++iIndex;
            }
        }
        LinkedList<RowContainer> oComponentRows = new LinkedList<RowContainer>();
        IntVector oColumnPrefWidths = new IntVector(10);
        for (IXMLBaseElement oElement : oRows) {
            LinkedList<IXMLBaseContainer.BoxComponent> oComponents = IXMLGridNode.createBoxComponents(oElement.getChildElements(), false, p_oInfoStack, p_oCreateInfo);
            iIndex = 0;
            for (IXMLBaseContainer.BoxComponent oComponent : oComponents) {
                oColumnPrefWidths.setElementAt(Math.max(oColumnPrefWidths.elementAt(iIndex), oComponent.mf_oComponent.getPreferredSize().width), iIndex);
                ++iIndex;
            }
            oComponentRows.add(new RowContainer(oComponents, (IXMLRow)oElement));
            iColumnCount = Math.max(iColumnCount, oComponents.size());
        }
        if (oColumns != null) {
            iIndex = 0;
            for (IXMLBaseElement oElement : oColumns) {
                Integer oSpacingValue = oElement.getAttributeAsInt(EIXMLAttrib.SPACING);
                if (oSpacingValue != null) {
                    oColumnPrefWidths.setElementAt(oColumnPrefWidths.elementAt(iIndex) + oSpacingValue, iIndex);
                }
                ++iIndex;
            }
        }
        FlexPanel oPanel = new FlexPanel(true);
        for (RowContainer oGridRow : oComponentRows) {
            FlexPanel oRowPanel = new FlexPanel(false);
            int iColumnIndex = 0;
            IXMLBaseContainer.setComponentOpaque(oRowPanel, p_oInfoStack);
            for (IXMLBaseContainer.BoxComponent oComponent : oGridRow.mf_oComponentList) {
                IXMLComponentGridContainer oContainer = new IXMLComponentGridContainer(oComponent.mf_oComponent);
                oContainer.setPreferredContainerSize(oColumnPrefWidths.elementAt(iColumnIndex), -1);
                oRowPanel.add((Component)oContainer, (Object)oColumnsFlexValues.elementAt(iColumnIndex), oComponent.mf_oElement.getID());
                ++iColumnIndex;
            }
            oPanel.add((Component)oRowPanel, (Object)oGridRow.mf_oRow.getAttributeAsInt(EIXMLAttrib.FLEX), oGridRow.mf_oRow.getID());
        }
        return oPanel;
    }

    protected boolean allowToAddChildElement(IXMLBaseElement p_oElement) {
        switch (p_oElement.getType()) {
            case COLUMNS: {
                if (this.m_bColumnsAdded) break;
                this.m_bColumnsAdded = true;
                return true;
            }
            case ROWS: {
                if (this.m_bRowsAdded) break;
                this.m_bRowsAdded = true;
                return true;
            }
        }
        return false;
    }

    public static void registerTags() {
        IXMLTagHandler.registerTag(new IXMLTagHandler("grid"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLGridNode(p_oAttributes.getValue("id"));
            }
        });
        IXMLTagHandler.registerTag(new IXMLTagHandler("columns"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLColumns();
            }
        });
        IXMLTagHandler.registerTag(new IXMLTagHandler("column"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLColumn();
            }
        });
        IXMLTagHandler.registerTag(new IXMLTagHandler("rows"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLRows();
            }
        });
        IXMLTagHandler.registerTag(new IXMLTagHandler("row"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLRow(p_oAttributes.getValue("id"));
            }
        });
    }

    public static class IXMLRow
    extends IXMLBaseElement {
        public IXMLRow(String p_strID) {
            super(EIXMLType.ROW, p_strID, true);
        }

        protected JComponent createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) {
            return null;
        }
    }

    public static class IXMLRows
    extends IXMLBaseElement {
        public IXMLRows() {
            super(EIXMLType.ROWS, null, true);
        }

        protected JComponent createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) {
            return null;
        }
    }

    public static class IXMLColumn
    extends IXMLBaseElement {
        public IXMLColumn() {
            super(EIXMLType.COLUMN, null, false);
        }

        protected JComponent createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) {
            return null;
        }
    }

    public static class IXMLColumns
    extends IXMLBaseElement {
        public IXMLColumns() {
            super(EIXMLType.COLUMNS, null, true);
        }

        protected JComponent createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RowContainer {
        public final LinkedList<IXMLBaseContainer.BoxComponent> mf_oComponentList;
        public final IXMLRow mf_oRow;

        public RowContainer(LinkedList<IXMLBaseContainer.BoxComponent> p_oComponentList, IXMLRow p_oRow) {
            this.mf_oComponentList = p_oComponentList;
            this.mf_oRow = p_oRow;
        }
    }
}

