/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.IXMLException;
import com.mayastudios.ixml.document.IXMLPanel;
import com.mayastudios.ixml.document.comp.AttributeParser;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.EIXMLType;
import com.mayastudios.ixml.document.comp.base.IXMLBaseContainer;
import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.document.comp.impl.RadioGroupPanel;
import com.mayastudios.ixml.document.parser.IXMLTagHandler;
import javax.swing.JRadioButton;
import org.xml.sax.Attributes;

public class IXMLRadioGroupNode
extends IXMLBaseContainer {
    public IXMLRadioGroupNode(String p_strID) {
        super(EIXMLType.RADIOGROUP, p_strID);
    }

    protected IXMLPanel createComponentImpl(IXMLBaseElement.InfoStack p_oInfoStack, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError, IXMLException {
        boolean bIsVerticalBox = this.getAttributeAsOption(EIXMLAttrib.ORIENT) != EIXMLAttrib.ORIENT_VALUE_HORIZONTAL;
        RadioGroupPanel oPanel = new RadioGroupPanel(bIsVerticalBox);
        this.fillBox(oPanel, bIsVerticalBox, new IXMLBaseElement.InfoStack(this, p_oInfoStack, oPanel, null), p_oCreateInfo);
        oPanel.setSelectedRadioButton(this.getAttributeAsInt(EIXMLAttrib.SELECTED, -1));
        return oPanel;
    }

    public static void registerTags() {
        IXMLTagHandler.registerTag(new IXMLTagHandler("radiogroup"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLRadioGroupNode(p_oAttributes.getValue("id"));
            }
        });
        IXMLTagHandler.registerTag(new IXMLTagHandler("radiobutton"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLRadioButton(p_oAttributes.getValue("id"));
            }
        });
    }

    public static class IXMLRadioButton
    extends IXMLBaseElement {
        private final IXMLBaseElement.NodeCompFactory<JRadioButton> mf_oNodeFactory = new IXMLBaseElement.NodeCompFactory<JRadioButton>(this, JRadioButton.class, "createRadioButton");

        public IXMLRadioButton(String p_strID) {
            super(EIXMLType.RADIOBUTTON, p_strID, false);
        }

        protected JRadioButton createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError {
            JRadioButton oRadioButton = this.mf_oNodeFactory.create(p_oCreateInfo, new Object[0]);
            RadioGroupPanel oRadioPanel = null;
            while (p_oParentComponent != null) {
                if (p_oParentComponent.mf_oElement.getType() == EIXMLType.RADIOGROUP) {
                    oRadioPanel = (RadioGroupPanel)p_oParentComponent.mf_oCreatedComponent;
                    oRadioPanel.addButtonToGroup(oRadioButton);
                    break;
                }
                p_oParentComponent = p_oParentComponent.getNext();
            }
            if (oRadioPanel == null) {
                throw new IXMLError("The radio button \"" + this.getAttributeAsString(EIXMLAttrib.CAPTION) + "\" doesn't belong to a radio group.", new Object[0]);
            }
            AttributeParser.MnemonicCaption oMnemonic = new AttributeParser.MnemonicCaption(this.getAttributeAsString(EIXMLAttrib.CAPTION));
            oMnemonic.applyTo(oRadioButton);
            return oRadioButton;
        }
    }
}

