/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.misc;

public class IntVector
implements Cloneable {
    protected int m_iIncreaseSize;
    protected int[] m_aiMap;
    protected int m_iFirstFree = 0;
    protected int m_iMapCapacity;

    public IntVector() {
        this.m_iMapCapacity = this.m_iIncreaseSize = 32;
        this.m_aiMap = new int[this.m_iIncreaseSize];
    }

    public IntVector(int blocksize) {
        this.m_iIncreaseSize = blocksize;
        this.m_iMapCapacity = blocksize;
        this.m_aiMap = new int[blocksize];
    }

    public IntVector(int blocksize, int increaseSize) {
        this.m_iIncreaseSize = increaseSize;
        this.m_iMapCapacity = blocksize;
        this.m_aiMap = new int[blocksize];
    }

    public IntVector(IntVector v) {
        this.m_aiMap = new int[v.m_iMapCapacity];
        this.m_iMapCapacity = v.m_iMapCapacity;
        this.m_iFirstFree = v.m_iFirstFree;
        this.m_iIncreaseSize = v.m_iIncreaseSize;
        System.arraycopy(v.m_aiMap, 0, this.m_aiMap, 0, this.m_iFirstFree);
    }

    public final int size() {
        return this.m_iFirstFree;
    }

    public final void setSize(int sz) {
        this.m_iFirstFree = sz;
    }

    public final void addElement(int value) {
        if (this.m_iFirstFree + 1 >= this.m_iMapCapacity) {
            this.growBy(this.m_iIncreaseSize);
        }
        this.m_aiMap[this.m_iFirstFree] = value;
        ++this.m_iFirstFree;
    }

    public final void addElements(int value, int numberOfElements) {
        if (this.m_iFirstFree + numberOfElements >= this.m_iMapCapacity) {
            this.growBy(this.m_iIncreaseSize + numberOfElements);
        }
        for (int i = 0; i < numberOfElements; ++i) {
            this.m_aiMap[this.m_iFirstFree] = value;
            ++this.m_iFirstFree;
        }
    }

    public final void addElements(int numberOfElements) {
        if (this.m_iFirstFree + numberOfElements >= this.m_iMapCapacity) {
            this.growBy(this.m_iIncreaseSize + numberOfElements);
        }
        this.m_iFirstFree += numberOfElements;
    }

    protected void growBy(int p_iIncreaseSize) {
        this.m_iMapCapacity += p_iIncreaseSize;
        int[] aiNewMap = new int[this.m_iMapCapacity];
        System.arraycopy(this.m_aiMap, 0, aiNewMap, 0, this.m_iFirstFree + 1);
        this.m_aiMap = aiNewMap;
    }

    public final void insertElementAt(int value, int at) {
        if (this.m_iFirstFree + 1 >= this.m_iMapCapacity) {
            this.growBy(this.m_iIncreaseSize);
        }
        if (at <= this.m_iFirstFree - 1) {
            System.arraycopy(this.m_aiMap, at, this.m_aiMap, at + 1, this.m_iFirstFree - at);
        }
        this.m_aiMap[at] = value;
        ++this.m_iFirstFree;
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.m_iFirstFree; ++i) {
            this.m_aiMap[i] = Integer.MIN_VALUE;
        }
        this.m_iFirstFree = 0;
    }

    public final boolean removeElement(int s) {
        for (int i = 0; i < this.m_iFirstFree; ++i) {
            if (this.m_aiMap[i] != s) continue;
            if (i + 1 < this.m_iFirstFree) {
                System.arraycopy(this.m_aiMap, i + 1, this.m_aiMap, i - 1, this.m_iFirstFree - i);
            } else {
                this.m_aiMap[i] = Integer.MIN_VALUE;
            }
            --this.m_iFirstFree;
            return true;
        }
        return false;
    }

    public final void removeElementAt(int i) {
        if (i > this.m_iFirstFree) {
            System.arraycopy(this.m_aiMap, i + 1, this.m_aiMap, i, this.m_iFirstFree);
        } else {
            this.m_aiMap[i] = Integer.MIN_VALUE;
        }
        --this.m_iFirstFree;
    }

    public final void setElementAt(int value, int index) {
        if (index >= this.m_iMapCapacity) {
            this.growBy(this.m_iIncreaseSize + (index - this.m_iMapCapacity));
        }
        if (index >= this.m_iFirstFree) {
            this.m_iFirstFree = index + 1;
        }
        this.m_aiMap[index] = value;
    }

    public final int elementAt(int i) {
        if (i >= this.m_iFirstFree) {
            return 0;
        }
        return this.m_aiMap[i];
    }

    public final boolean contains(int s) {
        for (int i = 0; i < this.m_iFirstFree; ++i) {
            if (this.m_aiMap[i] != s) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(int elem, int index) {
        for (int i = index; i < this.m_iFirstFree; ++i) {
            if (this.m_aiMap[i] != elem) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final int indexOf(int elem) {
        for (int i = 0; i < this.m_iFirstFree; ++i) {
            if (this.m_aiMap[i] != elem) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(int elem) {
        for (int i = this.m_iFirstFree - 1; i >= 0; --i) {
            if (this.m_aiMap[i] != elem) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public Object clone() {
        return new IntVector(this);
    }
}

