/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.util.Base64Decoder;
import org.castor.util.Base64Encoder;
import org.exolab.castor.jdo.engine.ClobImpl;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.types.Duration;
import org.exolab.castor.util.LocalConfiguration;

public final class SQLTypes {
    private static Log log = LogFactory.getFactory().getInstance(class$java$lang$Class == null ? (class$java$lang$Class = SQLTypes.class$("java.lang.Class")) : class$java$lang$Class);
    private static final char SQLWordSeparator = '_';
    private static final char LeftParamSeparator = '[';
    private static final char RightParamSeparator = ']';
    private static final TimeZone dbTimeZone;
    private static final ThreadLocal threadSafeCalendar;
    static TypeInfo[] _typeInfos;
    private static DateFormat _dateFormat;
    private static SimpleDateFormat _paramDateFormat;
    private static DecimalFormat _decimalFormat;
    static TypeConvertorInfo[] _typeConvertors;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$org$exolab$castor$types$Date;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$exolab$castor$types$Duration;

    private static Calendar getCalendar() {
        Calendar c = (Calendar)threadSafeCalendar.get();
        c.setTimeZone(dbTimeZone);
        return c;
    }

    private static int loadLobBufferSize() {
        int lobSize;
        String lobBufferSizeProperty = "org.exolab.castor.jdo.lobBufferSize";
        String lobSizeProp = LocalConfiguration.getInstance().getProperty(lobBufferSizeProperty, "");
        try {
            lobSize = Integer.parseInt(lobSizeProp.trim());
        }
        catch (NumberFormatException nfe) {
            lobSize = 256;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using lobSize: " + lobSize));
        }
        return lobSize;
    }

    public static Class typeFromName(String sqlTypeName) throws MappingException {
        int sep = sqlTypeName.indexOf(91);
        if (sep >= 0) {
            sqlTypeName = sqlTypeName.substring(0, sep);
        }
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (!sqlTypeName.equals(SQLTypes._typeInfos[i].sqlTypeName)) continue;
            return SQLTypes._typeInfos[i].javaType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", sqlTypeName);
    }

    public static int sqlTypeFromName(String sqlTypeName) throws MappingException {
        int sep = sqlTypeName.indexOf(91);
        if (sep >= 0) {
            sqlTypeName = sqlTypeName.substring(0, sep);
        }
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (!sqlTypeName.equals(SQLTypes._typeInfos[i].sqlTypeName)) continue;
            return SQLTypes._typeInfos[i].sqlType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", sqlTypeName);
    }

    public static String paramFromName(String sqlTypeName) {
        int left = sqlTypeName.indexOf(91);
        int right = sqlTypeName.indexOf(93);
        if (right < 0) {
            right = sqlTypeName.length();
        }
        if (left >= 0) {
            return sqlTypeName.substring(left + 1, right);
        }
        return null;
    }

    public static Class typeFromSQLType(int sqlType) throws MappingException {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (sqlType != SQLTypes._typeInfos[i].sqlType) continue;
            return SQLTypes._typeInfos[i].javaType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", new Integer(sqlType));
    }

    public static int getSQLType(Class javaType) {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (!javaType.isAssignableFrom(SQLTypes._typeInfos[i].javaType)) continue;
            return SQLTypes._typeInfos[i].sqlType;
        }
        return 1111;
    }

    public static String javaToSqlName(String javaName) {
        if (javaName.indexOf(46) > 0) {
            javaName = javaName.substring(javaName.lastIndexOf(46) + 1);
        }
        StringBuffer sql = new StringBuffer(javaName.length());
        boolean wasLower = false;
        for (int i = 0; i < javaName.length(); ++i) {
            char ch = javaName.charAt(i);
            if (i > 0 && Character.isUpperCase(ch)) {
                if (wasLower) {
                    sql.append('_');
                } else if (i < javaName.length() - 1 && Character.isLowerCase(javaName.charAt(i + 1))) {
                    sql.append('_');
                }
            }
            wasLower = Character.isLowerCase(ch);
            sql.append(Character.toLowerCase(ch));
        }
        return sql.toString();
    }

    public static String sqlToJavaName(String sqlName, boolean className, String scope) {
        StringBuffer java = new StringBuffer(sqlName.length());
        if (scope != null) {
            java.append(scope).append('.');
        }
        for (int i = 0; i < sqlName.length(); ++i) {
            if (i == 0 && className) {
                java.append(Character.toUpperCase(sqlName.charAt(i)));
                continue;
            }
            if (sqlName.charAt(i) == '_') {
                if (++i >= sqlName.length()) continue;
                java.append(Character.toUpperCase(sqlName.charAt(i)));
                continue;
            }
            java.append(Character.toLowerCase(sqlName.charAt(i)));
        }
        return java.toString();
    }

    public static Object getObject(ResultSet rs, int index, int sqlType) throws SQLException {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return rs.getString(index);
            }
            case 2: 
            case 3: {
                return rs.getBigDecimal(index);
            }
            case 4: {
                int intVal = rs.getInt(index);
                return rs.wasNull() ? null : new Integer(intVal);
            }
            case 92: {
                return rs.getTime(index, SQLTypes.getCalendar());
            }
            case 91: {
                return rs.getDate(index, SQLTypes.getCalendar());
            }
            case 93: {
                return rs.getTimestamp(index, SQLTypes.getCalendar());
            }
            case 6: 
            case 8: {
                double doubleVal = rs.getDouble(index);
                return rs.wasNull() ? null : new Double(doubleVal);
            }
            case 7: {
                float floatVal = rs.getFloat(index);
                return rs.wasNull() ? null : new Float(floatVal);
            }
            case 5: {
                short shortVal = rs.getShort(index);
                return rs.wasNull() ? null : new Short(shortVal);
            }
            case -6: {
                byte byteVal = rs.getByte(index);
                return rs.wasNull() ? null : new Byte(byteVal);
            }
            case -4: 
            case -3: 
            case -2: {
                return rs.getBytes(index);
            }
            case 2004: {
                Blob blob = rs.getBlob(index);
                return blob == null ? null : blob.getBinaryStream();
            }
            case 2005: {
                return rs.getClob(index);
            }
            case -5: {
                long longVal = rs.getLong(index);
                return rs.wasNull() ? null : new Long(longVal);
            }
            case -7: {
                boolean boolVal = rs.getBoolean(index);
                return rs.wasNull() ? null : new Boolean(boolVal);
            }
        }
        Object value = rs.getObject(index);
        return rs.wasNull() ? null : value;
    }

    public static void setObject(PreparedStatement stmt, int index, Object value, int sqlType) throws SQLException {
        try {
            if (value == null) {
                stmt.setNull(index, sqlType);
            } else {
                switch (sqlType) {
                    case 6: 
                    case 8: {
                        stmt.setDouble(index, (Double)value);
                        break;
                    }
                    case 7: {
                        stmt.setFloat(index, ((Float)value).floatValue());
                        break;
                    }
                    case 2004: {
                        try {
                            InputStream stream = (InputStream)value;
                            stmt.setBinaryStream(index, stream, stream.available());
                            break;
                        }
                        catch (IOException ex) {
                            throw new SQLException(ex.toString());
                        }
                    }
                    case 2005: {
                        Clob clob = (Clob)value;
                        stmt.setCharacterStream(index, clob.getCharacterStream(), (int)Math.min(clob.length(), Integer.MAX_VALUE));
                        break;
                    }
                    default: {
                        stmt.setObject(index, value, sqlType);
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Unexpected SQL exception: ", (Throwable)e);
        }
    }

    public static TypeConvertor getConvertor(Class fromType, Class toType) throws MappingException {
        int i;
        for (i = 0; i < _typeConvertors.length; ++i) {
            if (!SQLTypes._typeConvertors[i].fromType.equals(fromType) || !toType.equals(SQLTypes._typeConvertors[i].toType)) continue;
            return SQLTypes._typeConvertors[i].convertor;
        }
        for (i = 0; i < _typeConvertors.length; ++i) {
            if (!SQLTypes._typeConvertors[i].fromType.isAssignableFrom(fromType) || !toType.isAssignableFrom(SQLTypes._typeConvertors[i].toType)) continue;
            return SQLTypes._typeConvertors[i].convertor;
        }
        throw new MappingException("mapping.noConvertor", fromType.getName(), toType.getName());
    }

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat clone = (SimpleDateFormat)_dateFormat.clone();
        return clone;
    }

    private static SimpleDateFormat getParamDateFormat() {
        SimpleDateFormat clone = (SimpleDateFormat)_paramDateFormat.clone();
        return clone;
    }

    private static DecimalFormat getDecimalFormat() {
        DecimalFormat clone = (DecimalFormat)_decimalFormat.clone();
        return clone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String zone = LocalConfiguration.getInstance().getProperty("org.exolab.castor.jdo.defaultTimeZone", "");
        dbTimeZone = zone.length() == 0 ? TimeZone.getDefault() : TimeZone.getTimeZone(zone);
        threadSafeCalendar = new ThreadLocal(){

            public Object initialValue() {
                return new GregorianCalendar();
            }
        };
        _typeInfos = new TypeInfo[]{new TypeInfo(-7, "bit", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean), new TypeInfo(-6, "tinyint", class$java$lang$Byte == null ? (class$java$lang$Byte = SQLTypes.class$("java.lang.Byte")) : class$java$lang$Byte), new TypeInfo(5, "smallint", class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short), new TypeInfo(4, "integer", class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer), new TypeInfo(-5, "bigint", class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long), new TypeInfo(6, "float", class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double), new TypeInfo(8, "double", class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double), new TypeInfo(7, "real", class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float), new TypeInfo(2, "numeric", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal), new TypeInfo(3, "decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal), new TypeInfo(1, "char", class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String), new TypeInfo(12, "varchar", class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String), new TypeInfo(-1, "longvarchar", class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String), new TypeInfo(91, "date", class$java$sql$Date == null ? (class$java$sql$Date = SQLTypes.class$("java.sql.Date")) : class$java$sql$Date), new TypeInfo(92, "time", class$java$sql$Time == null ? (class$java$sql$Time = SQLTypes.class$("java.sql.Time")) : class$java$sql$Time), new TypeInfo(93, "timestamp", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp), new TypeInfo(-2, "binary", array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B), new TypeInfo(-3, "varbinary", array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B), new TypeInfo(-4, "longvarbinary", array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B), new TypeInfo(1111, "other", class$java$lang$Object == null ? (class$java$lang$Object = SQLTypes.class$("java.lang.Object")) : class$java$lang$Object), new TypeInfo(2000, "javaobject", class$java$lang$Object == null ? (class$java$lang$Object = SQLTypes.class$("java.lang.Object")) : class$java$lang$Object), new TypeInfo(2004, "blob", class$java$io$InputStream == null ? (class$java$io$InputStream = SQLTypes.class$("java.io.InputStream")) : class$java$io$InputStream), new TypeInfo(2005, "clob", class$java$sql$Clob == null ? (class$java$sql$Clob = SQLTypes.class$("java.sql.Clob")) : class$java$sql$Clob)};
        _dateFormat = new SimpleDateFormat();
        _paramDateFormat = new SimpleDateFormat();
        _decimalFormat = new DecimalFormat("#################0");
        _typeConvertors = new TypeConvertorInfo[]{new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean){

            public Object convert(Object obj, String param) {
                return (Short)obj == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short){

            public Object convert(Object obj, String param) {
                if (param == null || param.length() != 1 || param.charAt(0) != '-') {
                    return new Short((Boolean)obj != false ? (short)1 : 0);
                }
                return new Short((Boolean)obj != false ? (short)-1 : 0);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean){

            public Object convert(Object obj, String param) {
                return (Integer)obj == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                if (param == null || param.length() != 1 || param.charAt(0) != '-') {
                    return new Integer((Boolean)obj != false ? 1 : 0);
                }
                return new Integer((Boolean)obj != false ? -1 : 0);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean){

            public Object convert(Object obj, String param) {
                char t = 'T';
                char f = 'F';
                if (param != null && param.length() == 2) {
                    t = Character.toUpperCase(param.charAt(1));
                    f = Character.toUpperCase(param.charAt(0));
                }
                if (((String)obj).length() == 1) {
                    char c = Character.toUpperCase(((String)obj).charAt(0));
                    if (c == t) {
                        return Boolean.TRUE;
                    }
                    if (c == f) {
                        return Boolean.FALSE;
                    }
                }
                throw new ClassCastException("Failed to convert string '" + obj + "' to boolean because it didn't match the expected values '" + t + "'/'" + f + "' (true/false).");
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean){

            public Object convert(Object obj, String param) {
                return new Boolean(((BigDecimal)obj).intValue() != 0);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Byte == null ? (class$java$lang$Byte = SQLTypes.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                return new Integer(((Byte)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                return new Integer(((Short)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                return new Integer(((Long)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                return new Integer(((Float)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                return new Integer(((Double)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                return new Integer(((BigDecimal)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                return Integer.valueOf((String)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object convert(Object obj, String param) {
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                return new Integer(paramDateFormat.format((java.util.Date)obj));
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long){

            public Object convert(Object obj, String param) {
                return new Long(((Integer)obj).longValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long){

            public Object convert(Object obj, String param) {
                return new Long(((Short)obj).longValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long){

            public Object convert(Object obj, String param) {
                return new Long(((Float)obj).longValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long){

            public Object convert(Object obj, String param) {
                return new Long(((Double)obj).longValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long){

            public Object convert(Object obj, String param) {
                return new Long(((BigDecimal)obj).longValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long){

            public Object convert(Object obj, String param) {
                return Long.valueOf((String)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long){

            public Object convert(Object obj, String param) {
                return new Long(((java.util.Date)obj).getTime());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Byte == null ? (class$java$lang$Byte = SQLTypes.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short){

            public Object convert(Object obj, String param) {
                return new Short(((Byte)obj).shortValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short){

            public Object convert(Object obj, String param) {
                return new Short(((Integer)obj).shortValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short){

            public Object convert(Object obj, String param) {
                return new Short(((Long)obj).shortValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short){

            public Object convert(Object obj, String param) {
                return new Short((short)((BigDecimal)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short){

            public Object convert(Object obj, String param) {
                return Short.valueOf((String)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Byte == null ? (class$java$lang$Byte = SQLTypes.class$("java.lang.Byte")) : class$java$lang$Byte){

            public Object convert(Object obj, String param) {
                return new Byte(((Short)obj).byteValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Byte == null ? (class$java$lang$Byte = SQLTypes.class$("java.lang.Byte")) : class$java$lang$Byte){

            public Object convert(Object obj, String param) {
                return new Byte(((Integer)obj).byteValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Byte == null ? (class$java$lang$Byte = SQLTypes.class$("java.lang.Byte")) : class$java$lang$Byte){

            public Object convert(Object obj, String param) {
                return new Byte((byte)((BigDecimal)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double){

            public Object convert(Object obj, String param) {
                return new Double(((Float)obj).floatValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double){

            public Object convert(Object obj, String param) {
                return new Double(((Integer)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double){

            public Object convert(Object obj, String param) {
                return new Double(((Long)obj).longValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double){

            public Object convert(Object obj, String param) {
                return new Double(((BigDecimal)obj).doubleValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double){

            public Object convert(Object obj, String param) {
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                return new Double(paramDateFormat.format((java.util.Date)obj));
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double){

            public Object convert(Object obj, String param) {
                return Double.valueOf((String)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float){

            public Object convert(Object obj, String param) {
                return new Float(((Double)obj).floatValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float){

            public Object convert(Object obj, String param) {
                return new Float(((Integer)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float){

            public Object convert(Object obj, String param) {
                return new Float(((Long)obj).longValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float){

            public Object convert(Object obj, String param) {
                return new Float(((BigDecimal)obj).floatValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float){

            public Object convert(Object obj, String param) {
                return Float.valueOf((String)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                return new BigDecimal(((Double)obj).toString());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                return new BigDecimal(((Float)obj).toString());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                return BigDecimal.valueOf(((Integer)obj).intValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Byte == null ? (class$java$lang$Byte = SQLTypes.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                return BigDecimal.valueOf(((Byte)obj).byteValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                return BigDecimal.valueOf(((Short)obj).shortValue());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                return BigDecimal.valueOf((Long)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                return new BigDecimal((String)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                return new BigDecimal(new BigInteger(paramDateFormat.format((java.util.Date)obj)));
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal){

            public Object convert(Object obj, String param) {
                if (param == null || param.length() != 1 || param.charAt(0) != '-') {
                    return BigDecimal.valueOf((Boolean)obj != false ? 1L : 0L);
                }
                return BigDecimal.valueOf((Boolean)obj != false ? -1L : 0L);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Short == null ? (class$java$lang$Short = SQLTypes.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return obj.toString();
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return obj.toString();
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return obj.toString();
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Float == null ? (class$java$lang$Float = SQLTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return obj.toString();
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return obj.toString();
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Object == null ? (class$java$lang$Object = SQLTypes.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return obj.toString();
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                if (param == null || param.length() == 0) {
                    return obj.toString();
                }
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(param);
                return paramDateFormat.format((java.util.Date)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Character == null ? (class$java$lang$Character = SQLTypes.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return obj.toString();
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(array$C == null ? (array$C = SQLTypes.class$("[C")) : array$C, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return new String((char[])obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                return new String(Base64Encoder.encode((byte[])obj));
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                if (param == null || param.length() != 2) {
                    return (Boolean)obj != false ? "T" : "F";
                }
                return (Boolean)obj != false ? param.substring(1, 2) : param.substring(0, 1);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Character == null ? (class$java$lang$Character = SQLTypes.class$("java.lang.Character")) : class$java$lang$Character){

            public Object convert(Object obj, String param) {
                String str = (String)obj;
                return new Character(str.length() == 0 ? (char)'\u0000' : str.charAt(0));
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, array$C == null ? (array$C = SQLTypes.class$("[C")) : array$C){

            public Object convert(Object obj, String param) {
                return ((String)obj).toCharArray();
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B){

            public Object convert(Object obj, String param) {
                return Base64Decoder.decode((String)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                return new java.util.Date((Long)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                try {
                    if (param == null || param.length() == 0) {
                        return SQLTypes.getDateFormat().parse((String)obj);
                    }
                    SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                    paramDateFormat.applyPattern(param);
                    return paramDateFormat.parse((String)obj);
                }
                catch (ParseException except) {
                    throw new IllegalArgumentException(except.toString());
                }
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                try {
                    SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                    paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                    return paramDateFormat.parse(obj.toString());
                }
                catch (ParseException except) {
                    throw new IllegalArgumentException(except.toString());
                }
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                try {
                    SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                    paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                    return paramDateFormat.parse(obj.toString());
                }
                catch (ParseException except) {
                    throw new IllegalArgumentException(except.toString());
                }
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Double == null ? (class$java$lang$Double = SQLTypes.class$("java.lang.Double")) : class$java$lang$Double, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                try {
                    SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                    paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                    return paramDateFormat.parse(SQLTypes.getDecimalFormat().format(obj).trim());
                }
                catch (ParseException except) {
                    throw new IllegalArgumentException(except.toString());
                }
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$java$sql$Date == null ? (class$java$sql$Date = SQLTypes.class$("java.sql.Date")) : class$java$sql$Date){

            public Object convert(Object obj, String param) {
                return new Date(((java.util.Date)obj).getTime());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$sql$Date == null ? (class$java$sql$Date = SQLTypes.class$("java.sql.Date")) : class$java$sql$Date, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                return obj;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$java$sql$Time == null ? (class$java$sql$Time = SQLTypes.class$("java.sql.Time")) : class$java$sql$Time){

            public Object convert(Object obj, String param) {
                return new Time(((java.util.Date)obj).getTime());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$sql$Time == null ? (class$java$sql$Time = SQLTypes.class$("java.sql.Time")) : class$java$sql$Time, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                return obj;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp){

            public Object convert(Object obj, String param) {
                long time = ((java.util.Date)obj).getTime();
                Timestamp timestamp = new Timestamp(time);
                return timestamp;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                Timestamp timestamp = (Timestamp)obj;
                return new java.util.Date(timestamp.getTime());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp){

            public Object convert(Object obj, String param) {
                long time;
                if (param == null || param.length() == 0) {
                    param = "yyyy-MM-dd HH:mm:ss.SSS";
                }
                try {
                    SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                    paramDateFormat.applyPattern(param);
                    time = paramDateFormat.parse((String)obj).getTime();
                }
                catch (ParseException except) {
                    throw new IllegalArgumentException(except.toString());
                }
                Timestamp timestamp = new Timestamp(time);
                timestamp.setNanos((int)(time % 1000L * 1000000L));
                return timestamp;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                if (param == null || param.length() == 0) {
                    param = "yyyy-MM-dd HH:mm:ss.SSS";
                }
                Timestamp timestamp = (Timestamp)obj;
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(param);
                return paramDateFormat.format(new java.util.Date(timestamp.getTime() + (long)(timestamp.getNanos() / 1000000)));
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B, class$java$io$InputStream == null ? (class$java$io$InputStream = SQLTypes.class$("java.io.InputStream")) : class$java$io$InputStream){

            public Object convert(Object obj, String param) {
                return new ByteArrayInputStream((byte[])obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$io$InputStream == null ? (class$java$io$InputStream = SQLTypes.class$("java.io.InputStream")) : class$java$io$InputStream, array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B){

            public Object convert(Object obj, String param) {
                try {
                    InputStream is = (InputStream)obj;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[SQLTypes.loadLobBufferSize()];
                    int len = 0;
                    while ((len = is.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                    return bos.toByteArray();
                }
                catch (IOException except) {
                    throw new IllegalArgumentException(except.toString());
                }
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String, class$java$sql$Clob == null ? (class$java$sql$Clob = SQLTypes.class$("java.sql.Clob")) : class$java$sql$Clob){

            public Object convert(Object obj, String param) {
                String str = (String)obj;
                return new ClobImpl(new StringReader(str), str.length());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(array$C == null ? (array$C = SQLTypes.class$("[C")) : array$C, class$java$sql$Clob == null ? (class$java$sql$Clob = SQLTypes.class$("java.sql.Clob")) : class$java$sql$Clob){

            public Object convert(Object obj, String param) {
                char[] chars = (char[])obj;
                return new ClobImpl(new CharArrayReader(chars), chars.length);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$sql$Clob == null ? (class$java$sql$Clob = SQLTypes.class$("java.sql.Clob")) : class$java$sql$Clob, class$java$lang$String == null ? (class$java$lang$String = SQLTypes.class$("java.lang.String")) : class$java$lang$String){

            public Object convert(Object obj, String param) {
                try {
                    Reader reader = ((Clob)obj).getCharacterStream();
                    CharArrayWriter writer = new CharArrayWriter();
                    char[] buffer = new char[SQLTypes.loadLobBufferSize()];
                    int len = 0;
                    while ((len = reader.read(buffer)) > 0) {
                        writer.write(buffer, 0, len);
                    }
                    return writer.toString();
                }
                catch (Exception except) {
                    throw new IllegalArgumentException(except.toString());
                }
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$sql$Clob == null ? (class$java$sql$Clob = SQLTypes.class$("java.sql.Clob")) : class$java$sql$Clob, array$C == null ? (array$C = SQLTypes.class$("[C")) : array$C){

            public Object convert(Object obj, String param) {
                try {
                    Reader reader = ((Clob)obj).getCharacterStream();
                    CharArrayWriter writer = new CharArrayWriter();
                    char[] buffer = new char[SQLTypes.loadLobBufferSize()];
                    int len = 0;
                    while ((len = reader.read(buffer)) > 0) {
                        writer.write(buffer, 0, len);
                    }
                    return writer.toCharArray();
                }
                catch (Exception except) {
                    throw new IllegalArgumentException(except.toString());
                }
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date, class$org$exolab$castor$types$Date == null ? (class$org$exolab$castor$types$Date = SQLTypes.class$("org.exolab.castor.types.Date")) : class$org$exolab$castor$types$Date){

            public Object convert(Object obj, String param) {
                return new org.exolab.castor.types.Date((java.util.Date)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$org$exolab$castor$types$Date == null ? (class$org$exolab$castor$types$Date = SQLTypes.class$("org.exolab.castor.types.Date")) : class$org$exolab$castor$types$Date, class$java$util$Date == null ? (class$java$util$Date = SQLTypes.class$("java.util.Date")) : class$java$util$Date){

            public Object convert(Object obj, String param) {
                java.util.Date result = null;
                result = ((org.exolab.castor.types.Date)obj).toDate();
                return result;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$sql$Date == null ? (class$java$sql$Date = SQLTypes.class$("java.sql.Date")) : class$java$sql$Date, class$org$exolab$castor$types$Date == null ? (class$org$exolab$castor$types$Date = SQLTypes.class$("org.exolab.castor.types.Date")) : class$org$exolab$castor$types$Date){

            public Object convert(Object obj, String param) {
                return new org.exolab.castor.types.Date((java.util.Date)obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$org$exolab$castor$types$Date == null ? (class$org$exolab$castor$types$Date = SQLTypes.class$("org.exolab.castor.types.Date")) : class$org$exolab$castor$types$Date, class$java$sql$Date == null ? (class$java$sql$Date = SQLTypes.class$("java.sql.Date")) : class$java$sql$Date){

            public Object convert(Object obj, String param) {
                Date result = null;
                result = new Date(((org.exolab.castor.types.Date)obj).toDate().getTime());
                return result;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$io$Serializable == null ? (class$java$io$Serializable = SQLTypes.class$("java.io.Serializable")) : class$java$io$Serializable, class$java$io$InputStream == null ? (class$java$io$InputStream = SQLTypes.class$("java.io.InputStream")) : class$java$io$InputStream){

            public Object convert(Object obj, String param) {
                return new ByteArrayInputStream((byte[])obj);
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$io$InputStream == null ? (class$java$io$InputStream = SQLTypes.class$("java.io.InputStream")) : class$java$io$InputStream, class$java$io$Serializable == null ? (class$java$io$Serializable = SQLTypes.class$("java.io.Serializable")) : class$java$io$Serializable){

            public Object convert(Object obj, String param) {
                try {
                    InputStream is = (InputStream)obj;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[SQLTypes.loadLobBufferSize()];
                    int len = 0;
                    while ((len = is.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                    return bos.toByteArray();
                }
                catch (IOException except) {
                    throw new IllegalArgumentException(except.toString());
                }
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$io$Serializable == null ? (class$java$io$Serializable = SQLTypes.class$("java.io.Serializable")) : class$java$io$Serializable, array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B){

            public Object convert(Object obj, String param) {
                return obj;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(array$B == null ? (array$B = SQLTypes.class$("[B")) : array$B, class$java$io$Serializable == null ? (class$java$io$Serializable = SQLTypes.class$("java.io.Serializable")) : class$java$io$Serializable){

            public Object convert(Object obj, String param) {
                return obj;
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$org$exolab$castor$types$Duration == null ? (class$org$exolab$castor$types$Duration = SQLTypes.class$("org.exolab.castor.types.Duration")) : class$org$exolab$castor$types$Duration, class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long){

            public Object convert(Object obj, String param) {
                return new Long(((Duration)obj).toLong());
            }
        }), new TypeConvertorInfo(new SQLTypeConvertor(class$java$lang$Long == null ? (class$java$lang$Long = SQLTypes.class$("java.lang.Long")) : class$java$lang$Long, class$org$exolab$castor$types$Duration == null ? (class$org$exolab$castor$types$Duration = SQLTypes.class$("org.exolab.castor.types.Duration")) : class$org$exolab$castor$types$Duration){

            public Object convert(Object obj, String param) {
                return new Duration((Long)obj);
            }
        })};
    }

    public static abstract class SQLTypeConvertor
    implements TypeConvertor {
        Class fromType;
        Class toType;

        SQLTypeConvertor(Class fromType, Class toType) {
            this.fromType = fromType;
            this.toType = toType;
        }

        public abstract Object convert(Object var1, String var2);

        public String toString() {
            return this.fromType.getName() + "-->" + this.toType.getName();
        }
    }

    static class TypeConvertorInfo {
        final Class toType;
        final Class fromType;
        final SQLTypeConvertor convertor;

        TypeConvertorInfo(SQLTypeConvertor convertor) {
            this.convertor = convertor;
            this.fromType = convertor.fromType;
            this.toType = convertor.toType;
        }
    }

    static class TypeInfo {
        final int sqlType;
        final String sqlTypeName;
        final Class javaType;

        TypeInfo(int sqlType, String sqlTypeName, Class javaType) {
            this.sqlType = sqlType;
            this.sqlTypeName = sqlTypeName;
            this.javaType = javaType;
        }
    }
}

