/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXDate;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.NumericBoolean;
import com.tapsterrock.mpx.Record;
import java.util.Date;

public final class MPXCalendarException
extends MPXRecord {
    private MPXCalendar m_parentCalendar;
    private static final int FROM_DATE = 0;
    private static final int TO_DATE = 1;
    private static final int WORKING = 2;
    private static final int FROM_TIME_1 = 3;
    private static final int TO_TIME_1 = 4;
    private static final int FROM_TIME_2 = 5;
    private static final int TO_TIME_2 = 6;
    private static final int FROM_TIME_3 = 7;
    private static final int TO_TIME_3 = 8;
    private static final int MAX_FIELDS = 9;
    static final int BASE_CALENDAR_EXCEPTION_RECORD_NUMBER = 26;
    static final int RESOURCE_CALENDAR_EXCEPTION_RECORD_NUMBER = 57;

    MPXCalendarException(MPXFile file, MPXCalendar calendar) throws MPXException {
        this(file, calendar, Record.EMPTY_RECORD);
    }

    MPXCalendarException(MPXFile file, MPXCalendar calendar, Record record) throws MPXException {
        super(file, 9);
        this.m_parentCalendar = calendar;
        this.setFromDate(record.getDate(0));
        this.setToDate(record.getDate(1));
        this.setWorking(record.getNumericBoolean(2));
        this.setFromTime1(record.getTime(3));
        this.setToTime1(record.getTime(4));
        this.setFromTime2(record.getTime(5));
        this.setToTime2(record.getTime(6));
        this.setFromTime3(record.getTime(7));
        this.setToTime3(record.getTime(8));
    }

    public Date getFromDate() {
        return (Date)this.get(0);
    }

    public void setFromDate(Date from) {
        MPXDate date = null;
        if (from != null) {
            date = from instanceof MPXDate ? (MPXDate)from : new MPXDate(this.getParentFile().getDateTimeFormat(), from);
            date = date.getDayStartDate();
        }
        this.putDate(0, date);
    }

    public Date getToDate() {
        return (Date)this.get(1);
    }

    public void setToDate(Date to) {
        MPXDate date = null;
        if (to != null) {
            date = to instanceof MPXDate ? (MPXDate)to : new MPXDate(this.getParentFile().getDateTimeFormat(), to);
            date = date.getDayEndDate();
        }
        this.putDate(1, to);
    }

    public boolean getWorkingValue() {
        return this.getNumericBooleanValue(2);
    }

    public NumericBoolean getWorking() {
        return (NumericBoolean)this.get(2);
    }

    public void setWorking(boolean flag) {
        this.put(2, NumericBoolean.getInstance(flag));
    }

    public void setWorking(NumericBoolean flag) {
        this.put(2, flag);
    }

    public Date getFromTime1() {
        return (Date)this.get(3);
    }

    public void setFromTime1(Date from) {
        this.putTime(3, from);
    }

    public Date getToTime1() {
        return (Date)this.get(4);
    }

    public void setToTime1(Date to) {
        this.putTime(4, to);
    }

    public Date getFromTime2() {
        return (Date)this.get(5);
    }

    public void setFromTime2(Date from) {
        this.putTime(5, from);
    }

    public Date getToTime2() {
        return (Date)this.get(6);
    }

    public void setToTime2(Date to) {
        this.putTime(6, to);
    }

    public Date getFromTime3() {
        return (Date)this.get(7);
    }

    public void setFromTime3(Date from) {
        this.putTime(7, from);
    }

    public Date getToTime3() {
        return (Date)this.get(8);
    }

    public void setToTime3(Date to) {
        this.putTime(8, to);
    }

    public boolean contains(Date date) {
        long time;
        boolean result = false;
        if (date != null && (time = date.getTime()) >= this.getFromDate().getTime() && time <= this.getToDate().getTime()) {
            result = true;
        }
        return result;
    }

    public String toString() {
        int recordNumber = this.m_parentCalendar.isBaseCalendar() ? 26 : 57;
        return this.toString(recordNumber);
    }
}

