/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXNumberFormat;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mpx.ToStringRequiresFile;
import java.util.Locale;

public final class MPXDuration
implements ToStringRequiresFile {
    private double m_duration;
    private TimeUnit m_units;
    static final String DECIMAL_FORMAT_STRING = "#.#";
    private static final MPXNumberFormat DEFAULT_DECIMAL_FORMAT = new MPXNumberFormat("#.#", '.', ',');
    private static final double MINUTES_PER_DAY = 1440.0;
    private static final double HOURS_PER_DAY = 24.0;
    private static final double DAYS_PER_WEEK = 7.0;
    private static final double DAYS_PER_MONTH = 28.0;
    private static final double DAYS_PER_YEAR = 365.0;
    private static final MPXDuration[] ZERO_DURATIONS = new MPXDuration[]{new MPXDuration(0, TimeUnit.MINUTES), new MPXDuration(0, TimeUnit.HOURS), new MPXDuration(0, TimeUnit.DAYS), new MPXDuration(0, TimeUnit.WEEKS), new MPXDuration(0, TimeUnit.MONTHS), new MPXDuration(0, TimeUnit.YEARS), new MPXDuration(0, TimeUnit.PERCENT), new MPXDuration(0, TimeUnit.ELAPSED_MINUTES), new MPXDuration(0, TimeUnit.ELAPSED_HOURS), new MPXDuration(0, TimeUnit.ELAPSED_DAYS), new MPXDuration(0, TimeUnit.ELAPSED_WEEKS), new MPXDuration(0, TimeUnit.ELAPSED_MONTHS), new MPXDuration(0, TimeUnit.ELAPSED_YEARS), new MPXDuration(0, TimeUnit.ELAPSED_PERCENT)};

    private MPXDuration(String dur) throws MPXException {
        this(dur, DEFAULT_DECIMAL_FORMAT, Locale.ENGLISH);
    }

    private MPXDuration(String dur, MPXNumberFormat format, Locale locale) throws MPXException {
        int lastIndex;
        int index;
        for (index = lastIndex = dur.length() - 1; index > 0 && !Character.isDigit(dur.charAt(index)); --index) {
        }
        if (index == lastIndex) {
            this.m_duration = format.parse(dur).doubleValue();
            this.m_units = TimeUnit.DAYS;
        } else {
            this.m_duration = format.parse(dur.substring(0, ++index)).doubleValue();
            this.m_units = TimeUnit.parse(dur.substring(index), locale);
        }
    }

    private MPXDuration(double duration, TimeUnit type) {
        this.m_duration = duration;
        this.m_units = type;
    }

    private MPXDuration(int duration, TimeUnit type) {
        this.m_duration = duration;
        this.m_units = type;
    }

    public String toString() {
        return this.toString(DEFAULT_DECIMAL_FORMAT, Locale.ENGLISH);
    }

    public String toString(MPXFile mpx) {
        return this.toString(mpx.getDurationDecimalFormat(), mpx.getLocale());
    }

    private String toString(MPXNumberFormat format, Locale locale) {
        return format.format(this.m_duration) + TimeUnit.format(this.m_units, locale);
    }

    public double getDuration() {
        return this.m_duration;
    }

    public TimeUnit getUnits() {
        return this.m_units;
    }

    public MPXDuration convertUnits(TimeUnit type) {
        MPXDuration result;
        if (type.getValue() == this.m_units.getValue()) {
            result = this;
        } else {
            double duration = this.m_duration;
            switch (this.m_units.getValue()) {
                case 0: 
                case 7: {
                    duration /= 1440.0;
                    break;
                }
                case 1: 
                case 8: {
                    duration /= 24.0;
                    break;
                }
                case 3: 
                case 10: {
                    duration *= 7.0;
                    break;
                }
                case 4: 
                case 11: {
                    duration *= 28.0;
                    break;
                }
                case 5: 
                case 12: {
                    duration *= 365.0;
                }
            }
            switch (type.getValue()) {
                case 0: 
                case 7: {
                    duration *= 1440.0;
                    break;
                }
                case 1: 
                case 8: {
                    duration *= 24.0;
                    break;
                }
                case 3: 
                case 10: {
                    duration /= 7.0;
                    break;
                }
                case 4: 
                case 11: {
                    duration /= 28.0;
                    break;
                }
                case 5: 
                case 12: {
                    duration /= 365.0;
                }
            }
            result = new MPXDuration(duration, type);
        }
        return result;
    }

    public static MPXDuration getInstance(double duration, TimeUnit type) {
        MPXDuration result = duration == 0.0 ? ZERO_DURATIONS[type.getValue()] : new MPXDuration(duration, type);
        return result;
    }

    public static MPXDuration getInstance(int duration, TimeUnit type) {
        MPXDuration result = duration == 0 ? ZERO_DURATIONS[type.getValue()] : new MPXDuration(duration, type);
        return result;
    }

    public static MPXDuration getInstance(String dur, MPXNumberFormat format, Locale locale) throws MPXException {
        TimeUnit units;
        double duration;
        int lastIndex;
        int index;
        for (index = lastIndex = dur.length() - 1; index > 0 && !Character.isDigit(dur.charAt(index)); --index) {
        }
        if (index == lastIndex) {
            duration = format.parse(dur).doubleValue();
            units = TimeUnit.DAYS;
        } else {
            duration = format.parse(dur.substring(0, ++index)).doubleValue();
            units = TimeUnit.parse(dur.substring(index), locale);
        }
        return MPXDuration.getInstance(duration, units);
    }

    public static MPXDuration getInstance(String dur) throws MPXException {
        return MPXDuration.getInstance(dur, DEFAULT_DECIMAL_FORMAT, Locale.ENGLISH);
    }
}

