/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.utility;

import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.ProjectHeader;
import com.tapsterrock.mpx.Relation;
import com.tapsterrock.mpx.RelationType;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mspdi.MSPDIFile;
import java.text.SimpleDateFormat;

public class MpxjCreate {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxCreate <output file name>");
            } else {
                MpxjCreate.create(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static MPXFile createFile(String filename) {
        String suffix = filename.length() < 4 ? ".MPX" : filename.substring(filename.length() - 4).toUpperCase();
        MPXFile result = suffix.equals(".XML") ? new MSPDIFile() : new MPXFile();
        return result;
    }

    private static void create(String filename) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        MPXFile file = MpxjCreate.createFile(filename);
        file.setAutoTaskID(true);
        file.setAutoTaskUniqueID(true);
        file.setAutoResourceID(true);
        file.setAutoResourceUniqueID(true);
        file.setAutoOutlineLevel(true);
        file.setAutoOutlineNumber(true);
        file.setAutoWBS(true);
        file.setAutoCalendarUniqueID(true);
        file.addDefaultBaseCalendar();
        ProjectHeader header = file.getProjectHeader();
        header.setStartDate(df.parse("01/01/2003"));
        Resource resource1 = file.addResource();
        resource1.setName("Resource1");
        Resource resource2 = file.addResource();
        resource2.setName("Resource2");
        resource2.setMaxUnits(new Double(50.0));
        Task task1 = file.addTask();
        task1.setName("Summary Task");
        Task task2 = task1.addTask();
        task2.setName("First Sub Task");
        task2.setDuration(MPXDuration.getInstance(10.5, TimeUnit.DAYS));
        task2.setStart(df.parse("01/01/2003"));
        task2.setPercentageComplete(50.0);
        task2.setActualStart(df.parse("01/01/2003"));
        Task task3 = task1.addTask();
        task3.setName("Second Sub Task");
        task3.setStart(df.parse("11/01/2003"));
        task3.setDuration(MPXDuration.getInstance(10, TimeUnit.DAYS));
        Relation rel1 = task3.addPredecessor(task2);
        rel1.setType(RelationType.FINISH_START);
        Task milestone1 = task1.addTask();
        milestone1.setName("Milestone");
        milestone1.setStart(df.parse("21/01/2003"));
        milestone1.setDuration(MPXDuration.getInstance(0, TimeUnit.DAYS));
        Relation rel2 = milestone1.addPredecessor(task3);
        rel2.setType(RelationType.FINISH_START);
        ResourceAssignment assignment1 = task2.addResourceAssignment(resource1);
        ResourceAssignment assignment2 = task3.addResourceAssignment(resource2);
        assignment1.setWork(MPXDuration.getInstance(80, TimeUnit.HOURS));
        assignment1.setActualWork(MPXDuration.getInstance(40, TimeUnit.HOURS));
        assignment1.setRemainingWork(MPXDuration.getInstance(40, TimeUnit.HOURS));
        assignment2.setRemainingWork(MPXDuration.getInstance(80, TimeUnit.HOURS));
        assignment1.setStart(df.parse("01/01/2003"));
        assignment2.setStart(df.parse("11/01/2003"));
        file.write(filename);
    }
}

