/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.GanttImagePanel;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.font.Fonts;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.task.BlankLineNode;
import net.sourceforge.ganttproject.task.Task;

class TaskTreeImageGenerator {
    private GanttTree2 myTreeView;
    private UIConfiguration myUIConfiguration;
    private int myWidth;
    private static final int HEADER_OFFSET = 44;

    TaskTreeImageGenerator(GanttTree2 treeView, UIConfiguration uiConfiguration) {
        this.myTreeView = treeView;
        this.myUIConfiguration = uiConfiguration;
    }

    private GanttTree2 getTree() {
        return this.myTreeView;
    }

    List getPrintableNodes(GanttExportSettings settings) {
        List<DefaultMutableTreeNode> myItemsToConsider = settings.isOnlySelectedItem() ? Arrays.asList(this.getTree().getSelectedNodes()) : this.getTree().getAllVisibleNodes();
        System.out.println("TaskToConsider.size = " + myItemsToConsider.size());
        for (int i = 0; i < myItemsToConsider.size(); ++i) {
            if (!myItemsToConsider.get(i).isRoot()) continue;
            myItemsToConsider.remove(i);
            break;
        }
        return myItemsToConsider;
    }

    Image createImage(List myItemsToConsider) {
        BufferedImage tmpImage = new BufferedImage(10, 10, 1);
        FontMetrics fmetric = tmpImage.getGraphics().getFontMetrics(this.myUIConfiguration.getChartMainFont().deriveFont(12.0f));
        int width = 0;
        int height = this.getTree().getTreeTable().getRowHeight() * 3 + 44;
        Iterator tasks = myItemsToConsider.iterator();
        while (tasks.hasNext()) {
            DefaultMutableTreeNode nextTreeNode = (DefaultMutableTreeNode)tasks.next();
            if (nextTreeNode instanceof BlankLineNode) {
                height += this.getTree().getTreeTable().getRowHeight();
                continue;
            }
            Task next = (Task)nextTreeNode.getUserObject();
            if ("None".equals(next.toString()) || !this.isVisible(next)) continue;
            height += this.getTree().getTreeTable().getRowHeight();
            int nbchar = fmetric.stringWidth(next.getName());
            if (nbchar <= width) continue;
            width = nbchar;
        }
        this.myWidth = width += 50;
        BufferedImage image2 = new BufferedImage(width, height, 1);
        Graphics g2 = image2.getGraphics();
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        this.printTasks(g2, myItemsToConsider);
        GanttImagePanel but = new GanttImagePanel("big.png", 300, 47);
        g2.setColor(new Color(102, 153, 153));
        g2.fillRect(0, 0, width, but.getHeight());
        but.paintComponent(g2);
        return image2;
    }

    private int getWidth() {
        return this.myWidth;
    }

    private void printTasks(Graphics g, List taskNodes) {
        g.setColor(Color.black);
        g.setFont(Fonts.PRINT_CHART_FONT);
        this.printTask(g, taskNodes);
    }

    private int printTask(Graphics g, List child) {
        int rowCount = 0;
        int h = this.getTree().getTreeTable().getRowHeight();
        Stack<DefaultMutableTreeNode> nestingStack = new Stack<DefaultMutableTreeNode>();
        int y = this.getTree().getTable().getTableHeader().getHeight() + 44;
        Iterator tasks = child.iterator();
        while (tasks.hasNext()) {
            DefaultMutableTreeNode nextTreeNode = (DefaultMutableTreeNode)tasks.next();
            boolean blankline = nextTreeNode instanceof BlankLineNode;
            Task next = null;
            if (!blankline) {
                next = (Task)nextTreeNode.getUserObject();
                while (!nestingStack.isEmpty()) {
                    DefaultMutableTreeNode topStackNode = (DefaultMutableTreeNode)nestingStack.pop();
                    if (nextTreeNode.getParent() != topStackNode) continue;
                    nestingStack.push(topStackNode);
                    break;
                }
                nestingStack.push(nextTreeNode);
            }
            if (!blankline && !this.isVisible(next)) continue;
            if (rowCount % 2 == 1) {
                g.setColor(new Color(0.933f, 0.933f, 0.933f));
                g.fillRect(0, y, this.getWidth() - h / 2, h);
            }
            g.setColor(Color.black);
            g.drawRect(0, y, this.getWidth() - h / 2, h);
            if (!blankline) {
                int charH = (int)g.getFontMetrics().getLineMetrics(next.getName(), g).getAscent();
                int x = nestingStack.size() * 5;
                g.drawString(next.getName(), x, y + charH + (h - charH) / 2);
            }
            g.setColor(new Color(0.807f, 0.807f, 0.807f));
            g.drawLine(1, y + 19, this.getWidth() - 11, y + 19);
            y += h;
            ++rowCount;
        }
        return y;
    }

    private boolean isVisible(Task thetask) {
        boolean res = true;
        DefaultMutableTreeNode father = this.getTree().getFatherNode(thetask);
        if (father == null) {
            return false;
        }
        while (father != null) {
            Task taskFather = (Task)father.getUserObject();
            if (!taskFather.getExpand()) {
                res = false;
            }
            father = (DefaultMutableTreeNode)father.getParent();
        }
        return res;
    }
}

