/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.action;

import java.awt.event.ActionEvent;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.resource.AssignmentContext;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.task.ResourceAssignment;

public class DeleteAssignmentAction
extends GPAction {
    private final AssignmentContext myContext;
    private GanttProject myProjectFrame;

    public DeleteAssignmentAction(ResourceManager hrManager, AssignmentContext context, GanttProject projectFrame) {
        this.myProjectFrame = projectFrame;
        this.myContext = context;
    }

    public void actionPerformed(ActionEvent e) {
        this.myProjectFrame.getTabs().setSelectedIndex(1);
        Object[] context = this.myContext.getResourceAssignments();
        if (context != null && context.length > 0) {
            UIFacade.Choice choice = this.myProjectFrame.getUIFacade().showConfirmationDialog(this.getI18n("msg23") + " " + DeleteAssignmentAction.getDisplayName(context) + "?", this.getI18n("warning"));
            if (choice == UIFacade.Choice.YES) {
                this.myProjectFrame.getUIFacade().getUndoManager().undoableEdit("Resource removed", new Runnable((ResourceAssignment[])context){
                    private final /* synthetic */ ResourceAssignment[] val$context;
                    {
                        this.val$context = val$context;
                    }

                    public void run() {
                        DeleteAssignmentAction.this.deleteAssignments(this.val$context);
                        DeleteAssignmentAction.this.myProjectFrame.setAskForSave(true);
                        DeleteAssignmentAction.this.myProjectFrame.refreshProjectInfos();
                        DeleteAssignmentAction.this.myProjectFrame.repaint2();
                    }
                });
            }
        } else {
            this.myProjectFrame.deleteResources();
        }
    }

    private void deleteAssignments(ResourceAssignment[] context) {
        for (int i = 0; i < context.length; ++i) {
            ResourceAssignment ra = context[i];
            ra.delete();
            ra.getTask().getAssignmentCollection().deleteAssignment(ra.getResource());
        }
    }

    private static String getDisplayName(Object[] objs) {
        if (objs.length == 1) {
            return objs[0].toString();
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < objs.length; ++i) {
            result.append(objs[i].toString());
            if (i >= objs.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    protected String getIconFilePrefix() {
        return "delete_";
    }

    protected String getLocalizedName() {
        return this.getI18n("deleteAssignment");
    }
}

