/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.export;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.export.ExportFileWizardImpl;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.filter.ExtensionBasedFileFilter;
import net.sourceforge.ganttproject.gui.FileChooserPageBase;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;

class FileChooserPage
extends FileChooserPageBase {
    private ExportFileWizardImpl.State myState;
    private IGanttProject myProject;
    private GPOptionGroup myWebPublishingGroup;

    FileChooserPage(ExportFileWizardImpl.State state, IGanttProject project) {
        this.myState = state;
        this.myProject = project;
        this.myWebPublishingGroup = new GPOptionGroup("exporter.webPublishing", new GPOption[]{state.getPublishInWebOption()});
        this.myWebPublishingGroup.setTitled(false);
    }

    protected String getFileChooserTitle() {
        return GanttLanguage.getInstance().getText("selectFileToExport");
    }

    public String getTitle() {
        return GanttLanguage.getInstance().getText("selectFileToExport");
    }

    protected void onFileChosen(File file) {
        String proposedExtension = this.myState.getExporter().proposeFileExtension();
        if (proposedExtension != null && !file.getName().toLowerCase().endsWith(proposedExtension)) {
            file = new File(file.getAbsolutePath() + "." + proposedExtension);
        }
        this.myState.setFile(file);
    }

    public void setActive(boolean b) {
        if (!b) {
            this.myState.setFile(this.getSelectedFile());
            super.setActive(b);
        } else {
            super.setActive(b);
            File proposedFile = this.proposeOutputFile(this.myProject);
            if (proposedFile == null) {
                this.setSelectedFile(this.myState.getFile());
                return;
            }
            if (!proposedFile.equals(this.getSelectedFile())) {
                this.setSelectedFile(proposedFile);
                this.myState.setFile(proposedFile);
            }
        }
    }

    public File proposeOutputFile(IGanttProject project) {
        return FileChooserPage.proposeOutputFile(project, this.myState.getExporter());
    }

    static File proposeOutputFile(IGanttProject project, Exporter exporter) {
        String proposedExtension = exporter.proposeFileExtension();
        if (proposedExtension == null) {
            return null;
        }
        File userHome = new File(System.getProperty("user.home"));
        File result = new File(userHome, project.getProjectName() + "." + proposedExtension);
        Document projectDocument = project.getDocument();
        if (projectDocument != null) {
            File localFile = new File(projectDocument.getFilePath());
            if (localFile.exists()) {
                String name = localFile.getAbsolutePath();
                int lastDot = name.lastIndexOf(46);
                name = name.substring(0, lastDot) + "." + proposedExtension;
                result = new File(name);
            } else {
                File directory = localFile.getParentFile();
                if (directory.exists()) {
                    result = new File(directory, project.getProjectName() + "." + proposedExtension);
                }
            }
        }
        return result;
    }

    protected FileFilter createFileFilter() {
        return new ExtensionBasedFileFilter(this.myState.getExporter().getFileNamePattern(), this.myState.getExporter().getFileTypeDescription());
    }

    protected GPOptionGroup[] getOptionGroups() {
        GPOptionGroup[] exporterOptions = null;
        if (this.myState.getExporter() != null) {
            exporterOptions = this.myState.getExporter().getSecondaryOptions();
        }
        if (exporterOptions == null) {
            return new GPOptionGroup[]{this.myWebPublishingGroup};
        }
        GPOptionGroup[] result = new GPOptionGroup[exporterOptions.length + 1];
        result[0] = this.myWebPublishingGroup;
        System.arraycopy(exporterOptions, 0, result, 1, exporterOptions.length);
        return result;
    }
}

