/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.JPanel;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.language.GanttLanguage;

public abstract class GeneralOptionPanel
extends JPanel {
    protected GanttLanguage language = GanttLanguage.getInstance();
    protected Box vb = Box.createVerticalBox();
    protected boolean bHasChange = false;
    private Frame appli;
    private String myTitle;
    private String myComment;

    public GeneralOptionPanel(String title, String comment) {
        this(title, comment, null);
    }

    public GeneralOptionPanel(String title, String comment, Frame parent) {
        this.appli = parent;
        this.setLayout(new BorderLayout());
        this.add((Component)this.vb, "Center");
        this.myTitle = title;
        this.myComment = comment;
    }

    public Component getComponent() {
        return this;
    }

    public abstract boolean applyChanges(boolean var1);

    public abstract void initialize();

    public boolean askForApplyChanges() {
        return UIFacade.Choice.YES == this.getUIFacade().showConfirmationDialog(this.language.getText("msg20"), this.language.getText("question"));
    }

    public String getTitle() {
        return this.myTitle;
    }

    public String getComment() {
        return this.myComment;
    }

    private UIFacade getUIFacade() {
        return Mediator.getGanttProjectSingleton().getUIFacade();
    }

    public void rollback() {
        this.initialize();
    }
}

