/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.ganttproject.GPToolBar;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.gui.GanttLookAndFeelInfo;
import net.sourceforge.ganttproject.gui.GanttLookAndFeels;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class LnFSettingsPanel
extends GeneralOptionPanel
implements ItemListener {
    private JComboBox cbLnf;
    private JCheckBox cbSmallIcon;
    private JComboBox cbButtonType;
    private JList list;
    private DefaultListModel iconList;
    private DefaultListModel buttonList;
    private JList listDeleted;
    private DefaultListModel deletedIconList;
    private DefaultListModel deletedButtonList;
    private boolean bIconMoved = false;
    private JScrollPane scrollPane;
    private GanttProject appli;
    static /* synthetic */ Class class$java$lang$String;

    public LnFSettingsPanel(GanttProject parent) {
        super(GanttLanguage.getInstance().getText("looknfeel"), GanttLanguage.getInstance().getText("settingsLooknFeel"), parent);
        this.appli = parent;
        this.cbLnf = new JComboBox();
        this.cbLnf.setName("comboLnf");
        GanttLookAndFeelInfo[] lookAndFeels = GanttLookAndFeels.getGanttLookAndFeels().getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeels.length; ++i) {
            this.cbLnf.addItem(lookAndFeels[i]);
        }
        this.cbLnf.addItemListener(this);
        JPanel languagePanel = new JPanel(new BorderLayout());
        languagePanel.add((Component)this.cbLnf, "North");
        this.vb.add(languagePanel);
        this.vb.add(new JPanel());
        JPanel iconTextPanel = new JPanel(new FlowLayout());
        iconTextPanel.add(new JLabel(this.language.getText("show")));
        this.cbButtonType = new JComboBox();
        iconTextPanel.add(this.cbButtonType);
        this.cbButtonType.addItem(this.language.getText("buttonIcon"));
        this.cbButtonType.addItem(this.language.getText("buttonIconText"));
        this.cbButtonType.addItem(this.language.getText("buttonText"));
        iconTextPanel.add(new JLabel("  "));
        this.cbSmallIcon = new JCheckBox();
        iconTextPanel.add(this.cbSmallIcon);
        iconTextPanel.add(new JLabel(this.language.getText("useSmalIcons")));
        JPanel iconTextPanel2 = new JPanel(new BorderLayout());
        iconTextPanel2.add((Component)iconTextPanel, "West");
        this.vb.add(iconTextPanel2);
        this.vb.add(new JPanel());
        JPanel positionPanel = new JPanel(new FlowLayout());
        JPanel currentPanel = new JPanel(new BorderLayout());
        JPanel deletedPanel = new JPanel(new BorderLayout());
        currentPanel.add((Component)new JLabel(this.language.getText("currentToolBar")), "North");
        deletedPanel.add((Component)new JLabel(this.language.getText("availableToolBar")), "North");
        this.list = new JList();
        this.listDeleted = new JList();
        this.listDeleted.setName("listDeleted");
        this.scrollPane = new JScrollPane(this.listDeleted);
        this.scrollPane.setPreferredSize(new Dimension(110, 200));
        deletedPanel.add((Component)this.scrollPane, "East");
        this.list.setName("list");
        this.scrollPane = new JScrollPane(this.list);
        this.scrollPane.setPreferredSize(new Dimension(110, 200));
        currentPanel.add((Component)this.scrollPane, "East");
        Box currentButtonBox = Box.createVerticalBox();
        Box deletedButtonBox = Box.createVerticalBox();
        JButton bUp = new JButton();
        bUp.setIcon(new ImageIcon(this.getClass().getResource("/icons/up_16.gif")));
        bUp.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("upTask"))));
        bUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LnFSettingsPanel.this.upButtonActionPerformed(evt);
            }
        });
        JButton bDown = new JButton();
        bDown.setIcon(new ImageIcon(this.getClass().getResource("/icons/down_16.gif")));
        bDown.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("downTask"))));
        bDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LnFSettingsPanel.this.downButtonActionPerformed(evt);
            }
        });
        JButton bSeparator = new JButton();
        bSeparator.setIcon(new ImageIcon(this.getClass().getResource("/icons/separator_16.gif")));
        bSeparator.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("separator"))));
        bSeparator.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LnFSettingsPanel.this.separatorButtonActionPerformed(evt);
            }
        });
        JButton bDelete = new JButton();
        bDelete.setIcon(new ImageIcon(this.getClass().getResource("/icons/indent_16.gif")));
        bDelete.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("delete"))));
        bDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LnFSettingsPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        JButton bAdd = new JButton();
        bAdd.setIcon(new ImageIcon(this.getClass().getResource("/icons/unindent_16.gif")));
        bAdd.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("add"))));
        bAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LnFSettingsPanel.this.addButtonActionPerformed(evt);
            }
        });
        currentButtonBox.add(new JPanel());
        currentButtonBox.add(new JPanel());
        currentButtonBox.add(bUp);
        currentButtonBox.add(new JPanel());
        currentButtonBox.add(bDown);
        currentButtonBox.add(new JPanel());
        currentButtonBox.add(new JPanel());
        deletedButtonBox.add(new JPanel());
        deletedButtonBox.add(new JPanel());
        deletedButtonBox.add(bAdd);
        deletedButtonBox.add(new JPanel());
        deletedButtonBox.add(bDelete);
        deletedButtonBox.add(new JPanel());
        deletedButtonBox.add(new JPanel());
        positionPanel.add(currentButtonBox);
        positionPanel.add(currentPanel);
        positionPanel.add(new JPanel());
        positionPanel.add(deletedButtonBox);
        positionPanel.add(new JPanel());
        positionPanel.add(deletedPanel);
        positionPanel.add(new JPanel());
        this.vb.add(positionPanel);
        this.vb.add(new JPanel());
        this.applyComponentOrientation(this.language.getComponentOrientation());
    }

    public boolean applyChanges(boolean askForApply) {
        if (this.cbSmallIcon.isSelected() != this.appli.getOptions().getIconSize().equals("16")) {
            this.bHasChange = true;
        }
        if (this.cbButtonType.getSelectedIndex() != this.appli.getOptions().getButtonShow()) {
            this.bHasChange = true;
        }
        if (this.bIconMoved) {
            this.bHasChange = true;
        }
        if (this.bHasChange && (!askForApply || askForApply && this.askForApplyChanges())) {
            this.appli.changeLookAndFeel(this.getLookAndFeel());
            this.appli.changeOrder(this.buttonList, this.deletedButtonList);
            this.appli.getOptions().setIconSize(this.cbSmallIcon.isSelected() ? "16" : "24");
            this.appli.getOptions().setButtonShow(this.cbButtonType.getSelectedIndex());
            this.appli.applyButtonOptions();
        }
        return this.bHasChange;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.bHasChange = true;
        }
    }

    public GanttLookAndFeelInfo getLookAndFeel() {
        return (GanttLookAndFeelInfo)this.cbLnf.getSelectedItem();
    }

    public void initialize() {
        int i;
        this.cbLnf.setSelectedItem(this.appli.lookAndFeel);
        this.cbSmallIcon.setSelected(this.appli.getOptions().getIconSize().equals("16"));
        this.cbButtonType.setSelectedIndex(this.appli.getOptions().getButtonShow());
        this.deletedIconList = new DefaultListModel();
        this.deletedIconList.addElement(GPToolBar.SEPARATOR_OBJECT);
        this.deletedButtonList = new DefaultListModel();
        this.deletedButtonList.addElement(GPToolBar.SEPARATOR_OBJECT);
        for (i = 0; i < this.appli.getDeletedButtonList().size(); ++i) {
            if (GPToolBar.SEPARATOR_OBJECT == this.appli.getDeletedButtonList().getElementAt(i)) continue;
            this.deletedButtonList.addElement(this.appli.getDeletedButtonList().getElementAt(i));
        }
        for (i = 1; i < this.deletedButtonList.size(); ++i) {
            if (((TestGanttRolloverButton)this.deletedButtonList.getElementAt(i)).getIcon() == null) {
                this.deletedIconList.addElement(((TestGanttRolloverButton)this.deletedButtonList.getElementAt(i)).getText());
                continue;
            }
            this.deletedIconList.addElement(((TestGanttRolloverButton)this.deletedButtonList.getElementAt(i)).getIcon());
        }
        this.iconList = new DefaultListModel();
        this.buttonList = new DefaultListModel();
        for (i = 0; i < this.appli.getButtonList().size(); ++i) {
            this.buttonList.addElement(this.appli.getButtonList().getElementAt(i));
        }
        for (i = 0; i < this.buttonList.size(); ++i) {
            if (this.buttonList.elementAt(i).equals(GPToolBar.SEPARATOR_OBJECT)) {
                this.iconList.addElement(this.buttonList.getElementAt(i));
                continue;
            }
            if (((TestGanttRolloverButton)this.buttonList.getElementAt(i)).getIcon() == null) {
                this.iconList.addElement(((TestGanttRolloverButton)this.buttonList.getElementAt(i)).getText());
                continue;
            }
            this.iconList.addElement(((TestGanttRolloverButton)this.buttonList.getElementAt(i)).getIcon());
        }
        this.list.setModel(this.iconList);
        this.listDeleted.setModel(this.deletedIconList);
        this.bHasChange = false;
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        Object[] objects = this.list.getSelectedValues();
        int[] selection = this.list.getSelectedIndices();
        if (objects.length > 0) {
            if (selection[0] != 0) {
                this.list.ensureIndexIsVisible(selection[0]);
                for (int i = 0; i < objects.length; ++i) {
                    int index = selection[i];
                    this.iconList.setElementAt(this.iconList.getElementAt(index - 1), index);
                    this.iconList.setElementAt(objects[i], index - 1);
                    Object object = this.buttonList.getElementAt(index);
                    this.buttonList.setElementAt(this.buttonList.getElementAt(index - 1), index);
                    this.buttonList.setElementAt(object, index - 1);
                    selection[i] = index - 1;
                }
                this.list.setSelectedIndices(selection);
            }
            this.bIconMoved = true;
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        Object[] objects = this.list.getSelectedValues();
        int[] selection = this.list.getSelectedIndices();
        if (objects.length > 0) {
            if (selection[selection.length - 1] != this.iconList.size() - 1) {
                this.list.ensureIndexIsVisible(selection[selection.length - 1]);
                for (int i = objects.length - 1; i > -1; --i) {
                    int index = selection[i];
                    this.iconList.setElementAt(this.iconList.getElementAt(index + 1), index);
                    this.iconList.setElementAt(objects[i], index + 1);
                    Object object = this.buttonList.getElementAt(index);
                    this.buttonList.setElementAt(this.buttonList.getElementAt(index + 1), index);
                    this.buttonList.setElementAt(object, index + 1);
                    selection[i] = index + 1;
                }
                this.list.setSelectedIndices(selection);
            }
            this.bIconMoved = true;
        }
    }

    private void separatorButtonActionPerformed(ActionEvent evt) {
        int index = 0;
        if (this.list.getSelectedIndex() != -1) {
            index = this.list.getSelectedIndex();
        }
        this.iconList.add(index, GPToolBar.SEPARATOR_OBJECT);
        this.buttonList.add(index, GPToolBar.SEPARATOR_OBJECT);
        this.list.setSelectedIndex(index);
        this.bIconMoved = true;
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int[] indexes = this.list.getSelectedIndices();
        int[] indexesDeleted = new int[indexes.length];
        if (indexes.length != 0) {
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = indexes[i] - i;
                Object icon = this.iconList.remove(indexes[i]);
                Object button = this.buttonList.remove(indexes[i]);
                if (icon.getClass() == (class$java$lang$String == null ? LnFSettingsPanel.class$("java.lang.String") : class$java$lang$String)) continue;
                this.deletedIconList.addElement(icon);
                this.deletedButtonList.addElement(button);
            }
            this.listDeleted.setSelectedIndex(this.deletedIconList.getSize() - 1);
            if (this.iconList.getSize() > 0) {
                this.list.setSelectedIndex(indexes[0]);
            }
            this.bHasChange = true;
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int[] indexesDeleted;
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            index = 0;
        }
        if ((indexesDeleted = this.listDeleted.getSelectedIndices()).length != 0) {
            int j = 0;
            for (int i = 0; i < indexesDeleted.length; ++i) {
                if (indexesDeleted[i] == 0) {
                    j = 1;
                    indexesDeleted[i] = indexesDeleted[i];
                } else {
                    indexesDeleted[i] = indexesDeleted[i] - i + j;
                }
                Object icon = GPToolBar.SEPARATOR_OBJECT;
                Object button = GPToolBar.SEPARATOR_OBJECT;
                if (this.deletedIconList.getElementAt(indexesDeleted[i]).getClass() != (class$java$lang$String == null ? LnFSettingsPanel.class$("java.lang.String") : class$java$lang$String)) {
                    icon = this.deletedIconList.remove(indexesDeleted[i]);
                    button = this.deletedButtonList.remove(indexesDeleted[i]);
                }
                if (this.iconList.getSize() != index + i) {
                    this.iconList.add(index + i + 1, icon);
                    this.buttonList.add(index + i + 1, button);
                    continue;
                }
                this.iconList.add(index + i, icon);
                this.buttonList.add(index + i, button);
            }
            if (this.iconList.getSize() != index + 1) {
                this.list.setSelectedIndex(index + 1);
            } else {
                this.list.setSelectedIndex(index);
            }
            if (this.deletedIconList.getSize() <= indexesDeleted[0]) {
                this.listDeleted.setSelectedIndex(0);
            } else {
                this.listDeleted.setSelectedIndex(indexesDeleted[0]);
            }
            this.bHasChange = true;
        }
    }
}

