/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.projectwizard;

import java.text.MessageFormat;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleSet;

public class I18N {
    final String[] myDayNames = new String[7];

    public I18N() {
        for (int i = 0; i < 7; ++i) {
            this.myDayNames[i] = GanttLanguage.getInstance().getDay(i);
        }
    }

    public String getNewProjectWizardWindowTitle() {
        return GanttLanguage.getInstance().getText("createNewProject");
    }

    public String getProjectDomainPageTitle() {
        return GanttLanguage.getInstance().getText("selectProjectDomain");
    }

    public String getProjectWeekendPageTitle() {
        return GanttLanguage.getInstance().getText("selectProjectWeekend");
    }

    public String getRolesetTooltipHeader(String roleSetName) {
        return MessageFormat.format("<html><body><h3>{0}</h3><ul>", roleSetName);
    }

    public String getRolesetTooltipFooter() {
        return "</ul></body></html>";
    }

    public String formatRoleForTooltip(Role role) {
        return MessageFormat.format("<li>{0}</li>", role.getName());
    }

    String[] getDayNames() {
        return this.myDayNames;
    }

    public String getRoleSetDisplayName(RoleSet roleSet) {
        return GanttLanguage.getInstance().getText("roleSet." + roleSet.getName() + ".displayName");
    }
}

