/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.projectwizard;

import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.projectwizard.I18N;
import net.sourceforge.ganttproject.gui.projectwizard.ProjectNamePage;
import net.sourceforge.ganttproject.gui.projectwizard.RoleSetPage;
import net.sourceforge.ganttproject.gui.projectwizard.WeekendConfigurationPage;
import net.sourceforge.ganttproject.gui.projectwizard.WizardImpl;
import net.sourceforge.ganttproject.roles.RoleSet;

public class NewProjectWizardWindow
extends WizardImpl {
    private I18N myI18n;

    public NewProjectWizardWindow(UIFacade uiFacade, I18N i18n) {
        super(uiFacade, i18n.getNewProjectWizardWindowTitle());
        this.myI18n = i18n;
    }

    public void addRoleSetPage(RoleSet[] roleSets) {
        RoleSetPage roleSetPage = new RoleSetPage(roleSets, this.myI18n);
        this.addPage(roleSetPage);
    }

    public void addProjectNamePage(IGanttProject project) {
        ProjectNamePage projectNamePage = new ProjectNamePage(null, project, this.myI18n);
        this.addPage(projectNamePage);
    }

    public void addWeekendConfigurationPage(GPCalendar calendar, IGanttProject project) {
        try {
            WeekendConfigurationPage weekendPage = new WeekendConfigurationPage(calendar, this.myI18n, project);
            this.addPage(weekendPage);
        }
        catch (Exception e) {
            this.getUIFacade().showErrorDialog(e);
        }
    }
}

