/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import java.util.Date;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskActivity;
import net.sourceforge.ganttproject.task.TaskImpl;
import net.sourceforge.ganttproject.task.TaskLength;

class TaskActivityImpl
implements TaskActivity {
    private final Date myEndDate;
    private final Date myStartDate;
    private final TaskLength myDuration;
    private float myIntensity;
    private final TaskImpl myTask;

    TaskActivityImpl(TaskImpl task, Date startDate, Date endDate) {
        this(task, startDate, endDate, 1.0f);
    }

    TaskActivityImpl(TaskImpl task, Date startDate, Date endDate, float intensity) {
        this.myStartDate = startDate;
        this.myEndDate = endDate;
        this.myDuration = task.getManager().createLength(task.getDuration().getTimeUnit(), startDate, endDate);
        this.myIntensity = intensity;
        this.myTask = task;
    }

    public Date getStart() {
        return this.myStartDate;
    }

    public Date getEnd() {
        return this.myEndDate;
    }

    public TaskLength getDuration() {
        return this.myDuration;
    }

    public float getIntensity() {
        return this.myIntensity;
    }

    public String toString() {
        return this.myTask.toString() + "[" + this.getStart() + ", " + this.getEnd() + "]";
    }

    public Task getTask() {
        return this.myTask;
    }

    public boolean isFirst() {
        return this == this.getTask().getActivities()[0];
    }

    public boolean isLast() {
        TaskActivity[] all = this.getTask().getActivities();
        return this == all[all.length - 1];
    }
}

