/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.time.TimeUnit;

public class TaskLengthImpl
implements TaskLength {
    private final TimeUnit myUnit;
    private float myCount;

    public TaskLengthImpl(TimeUnit unit, long count) {
        this.myUnit = unit;
        this.myCount = count;
    }

    public TaskLengthImpl(TimeUnit unit, float length) {
        this.myUnit = unit;
        this.myCount = length;
    }

    public float getValue() {
        return this.myCount;
    }

    public long getLength() {
        return (long)this.myCount;
    }

    public TimeUnit getTimeUnit() {
        return this.myUnit;
    }

    public void setLength(TimeUnit unit, long length) {
        if (!unit.equals(this.myUnit)) {
            throw new IllegalArgumentException("Can't convert unit=" + unit + " to my unit=" + this.myUnit);
        }
        this.myCount = length;
    }

    public float getLength(TimeUnit unit) {
        if (this.myUnit.isConstructedFrom(unit)) {
            return this.myCount * (float)this.myUnit.getAtomCount(unit);
        }
        if (unit.isConstructedFrom(this.myUnit)) {
            return this.myCount / (float)unit.getAtomCount(this.myUnit);
        }
        if (!unit.equals(this.myUnit)) {
            throw new IllegalArgumentException("Can't convert unit=" + unit + " to my unit=" + this.myUnit);
        }
        return this.myCount;
    }

    public String toString() {
        return "" + this.myCount + " " + this.myUnit.getName();
    }
}

