/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.AbsolutePositionProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;

public class BlockContainer
extends FObj {
    int position;
    int top;
    int bottom;
    int left;
    int right;
    int width;
    int height;
    int span;
    AreaContainer areaContainer;
    PageSequence pageSequence;

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected BlockContainer(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        this.span = this.properties.get("span").getEnum();
    }

    public String getName() {
        return "fo:block-container";
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1000) {
            AbsolutePositionProps mAbsProps = this.propMgr.getAbsolutePositionProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            MarginProps mProps = this.propMgr.getMarginProps();
            this.marker = 0;
            this.position = this.properties.get("position").getEnum();
            this.top = this.properties.get("top").getLength().mvalue();
            this.bottom = this.properties.get("bottom").getLength().mvalue();
            this.left = this.properties.get("left").getLength().mvalue();
            this.right = this.properties.get("right").getLength().mvalue();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.span = this.properties.get("span").getEnum();
            String id = this.properties.get("id").getString();
            try {
                area.getIDReferences().initializeID(id, area);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
        }
        boolean prevChildMustKeepWithNext = false;
        AreaContainer container = (AreaContainer)area;
        if (this.width == 0 && this.height == 0) {
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
        }
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(container.getFontInfo()), container.getXPosition() + this.left, container.getYPosition() - this.top, this.width, this.height, this.position);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackground(this.propMgr.getBackgroundProps());
        this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(0);
        this.areaContainer.setIDReferences(area.getIDReferences());
        int numChildren = this.children.size();
        int i = this.marker;
        while (i < numChildren) {
            FObj fo = (FObj)this.children.get(i);
            int status = fo.layout(this.areaContainer);
            if (Status.isIncomplete(status)) {
                // empty if block
            }
            if (status == 8) {
                prevChildMustKeepWithNext = true;
            }
            ++i;
        }
        this.areaContainer.end();
        if (this.position == 1) {
            this.areaContainer.setHeight(this.height);
        }
        area.addChild(this.areaContainer);
        return 1;
    }

    public int getContentWidth() {
        if (this.areaContainer != null) {
            return this.areaContainer.getContentWidth();
        }
        return 0;
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public int getSpan() {
        return this.span;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new BlockContainer(parent, propertyList, systemId, line, column);
        }
    }
}

