/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.msproject;

import com.tapsterrock.mpx.MPXException;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.FileDocument;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.importer.Importer;
import net.sourceforge.ganttproject.importer.ImporterBase;
import net.sourceforge.ganttproject.language.GanttLanguage;
import org.ganttproject.impex.msproject.GanttMPPOpen;
import org.ganttproject.impex.msproject.GanttMPXJOpen;
import org.ganttproject.impex.msproject.GanttMPXOpen;
import org.ganttproject.impex.msproject.GanttMSPDIOpen;
import org.ganttproject.impex.msproject.LocaleOption;

public class ImporterFromMsProjectFile
extends ImporterBase
implements Importer {
    private LocaleOption myLanguageOption = new LocaleOption();
    private GPOptionGroup myMPXOptions = new GPOptionGroup("importer.msproject.mpx", new GPOption[]{this.myLanguageOption});
    GanttMPXJOpen open;

    public String getFileNamePattern() {
        return "mpp|mpx|xml";
    }

    public GPOptionGroup[] getSecondaryOptions() {
        return new GPOptionGroup[]{this.myMPXOptions};
    }

    public String getFileTypeDescription() {
        return GanttLanguage.getInstance().getText("impex.msproject.description");
    }

    public void run(GanttProject project, UIFacade uiFacade, File selectedFile) {
        if (this.acceptImport(project)) {
            Document document = this.getDocument(selectedFile);
            this.openDocument(project, uiFacade, document);
        }
    }

    protected Document getDocument(File selectedFile) {
        return new FileDocument(selectedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openDocument(GanttProject project, UIFacade uiFacade, Document document) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            if (document.getPath().toLowerCase().endsWith(".mpp")) {
                this.open = new GanttMPPOpen(project.getTree(), project);
            } else if (document.getPath().toLowerCase().endsWith(".mpx")) {
                this.open = null;
                Locale importlocale = this.myLanguageOption.getSelectedLocale();
                this.open = new GanttMPXOpen(project.getTree(), project, importlocale);
            } else {
                this.open = document.getPath().toLowerCase().endsWith(".xml") ? new GanttMSPDIOpen(project.getTree(), project) : null;
            }
            this.open.load(document.getInputStream());
        }
        catch (IOException e) {
            uiFacade.showErrorDialog((Throwable)e);
        }
        catch (MPXException e) {
            uiFacade.showErrorDialog((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

