/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.Local;

public class AddResourceDialog
extends JDialog {
    JPanel dialogTitlePanel = new JPanel(new FlowLayout(0));
    JLabel header = new JLabel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JPanel areaPanel = new JPanel(new GridBagLayout());
    GridBagConstraints gbc;
    public JRadioButton localFileRB = new JRadioButton();
    public JCheckBox projectFileCB = new JCheckBox("Copy file to memoranda", false);
    JLabel jLabel1 = new JLabel();
    public JTextField pathField = new JTextField();
    JButton browseB = new JButton();
    JLabel jLabel2 = new JLabel();
    public JRadioButton inetShortcutRB = new JRadioButton();
    public JTextField urlField = new JTextField();
    JPanel buttonsPanel = new JPanel(new FlowLayout(2, 15, 15));
    JButton okB = new JButton();
    JButton cancelB = new JButton();
    public boolean CANCELLED = true;

    public AddResourceDialog(Frame frame, String string) {
        super(frame, string, true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.dialogTitlePanel.setBackground(Color.WHITE);
        this.dialogTitlePanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.header.setFont(new Font("Dialog", 0, 20));
        this.header.setForeground(new Color(0, 0, 124));
        this.header.setText(Local.getString("New resource"));
        this.header.setIcon(new ImageIcon(AddResourceDialog.class.getResource("resources/icons/resource48.png")));
        this.dialogTitlePanel.add(this.header);
        this.getContentPane().add((Component)this.dialogTitlePanel, "North");
        this.buttonGroup1.add(this.localFileRB);
        this.buttonGroup1.add(this.inetShortcutRB);
        this.localFileRB.setSelected(true);
        this.localFileRB.setText(Local.getString("Local file"));
        this.localFileRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddResourceDialog.this.localFileRB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 2;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 15, 5, 15);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.areaPanel.add((Component)this.localFileRB, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 2;
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 15, 5, 15);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.areaPanel.add((Component)this.projectFileCB, this.gbc);
        this.jLabel1.setText(Local.getString("Path") + ": ");
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 20, 5, 5);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.areaPanel.add((Component)this.jLabel1, this.gbc);
        this.pathField.setMinimumSize(new Dimension(4, 24));
        this.pathField.setPreferredSize(new Dimension(250, 24));
        this.pathField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                AddResourceDialog.this.pathField_caretUpdate(caretEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.areaPanel.add((Component)this.pathField, this.gbc);
        this.browseB.setText(Local.getString("Browse"));
        this.browseB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddResourceDialog.this.browseB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 10, 5, 15);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.browseB, this.gbc);
        this.inetShortcutRB.setText(Local.getString("Internet shortcut"));
        this.inetShortcutRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddResourceDialog.this.inetShortcutRB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 15, 5, 15);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.inetShortcutRB, this.gbc);
        this.jLabel2.setText(Local.getString("URL") + ":  ");
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 20, 5, 15);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel2, this.gbc);
        this.urlField.setMinimumSize(new Dimension(4, 24));
        this.urlField.setPreferredSize(new Dimension(335, 24));
        this.urlField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                AddResourceDialog.this.urlField_caretUpdate(caretEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 5, 0, 15);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.areaPanel.add((Component)this.urlField, this.gbc);
        this.getContentPane().add((Component)this.areaPanel, "Center");
        this.okB.setEnabled(false);
        this.okB.setMaximumSize(new Dimension(100, 26));
        this.okB.setMinimumSize(new Dimension(100, 26));
        this.okB.setPreferredSize(new Dimension(100, 26));
        this.okB.setText(Local.getString("Ok"));
        this.okB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddResourceDialog.this.okB_actionPerformed(actionEvent);
            }
        });
        this.getRootPane().setDefaultButton(this.okB);
        this.cancelB.setMaximumSize(new Dimension(100, 26));
        this.cancelB.setMinimumSize(new Dimension(100, 26));
        this.cancelB.setPreferredSize(new Dimension(100, 26));
        this.cancelB.setText(Local.getString("Cancel"));
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddResourceDialog.this.cancelB_actionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.okB);
        this.buttonsPanel.add(this.cancelB);
        this.enableFields();
        this.getContentPane().add((Component)this.buttonsPanel, "South");
    }

    void okB_actionPerformed(ActionEvent actionEvent) {
        this.CANCELLED = false;
        this.dispose();
    }

    void cancelB_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void localFileRB_actionPerformed(ActionEvent actionEvent) {
        this.enableFields();
        this.checkOkEnabled();
        this.urlField.select(0, 0);
        this.pathField.select(0, this.pathField.getText().length());
        this.pathField.requestFocus();
    }

    void inetShortcutRB_actionPerformed(ActionEvent actionEvent) {
        this.enableFields();
        this.checkOkEnabled();
        this.pathField.select(0, 0);
        this.urlField.select(0, this.urlField.getText().length());
        this.urlField.requestFocus();
    }

    void browseB_actionPerformed(ActionEvent actionEvent) {
        UIManager.put("FileChooser.lookInLabelText", Local.getString("Look in:"));
        UIManager.put("FileChooser.upFolderToolTipText", Local.getString("Up One Level"));
        UIManager.put("FileChooser.newFolderToolTipText", Local.getString("Create New Folder"));
        UIManager.put("FileChooser.listViewButtonToolTipText", Local.getString("List"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", Local.getString("Details"));
        UIManager.put("FileChooser.fileNameLabelText", Local.getString("File Name:"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Local.getString("Files of Type:"));
        UIManager.put("FileChooser.openButtonText", Local.getString("Open"));
        UIManager.put("FileChooser.openButtonToolTipText", Local.getString("Open selected file"));
        UIManager.put("FileChooser.cancelButtonText", Local.getString("Cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", Local.getString("Cancel"));
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setDialogTitle(Local.getString("Add resource"));
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setPreferredSize(new Dimension(550, 375));
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.pathField.setText(jFileChooser.getSelectedFile().getPath());
        this.checkOkEnabled();
    }

    void pathField_caretUpdate(CaretEvent caretEvent) {
        this.checkOkEnabled();
    }

    void urlField_caretUpdate(CaretEvent caretEvent) {
        this.checkOkEnabled();
    }

    void checkOkEnabled() {
        this.okB.setEnabled(this.localFileRB.isSelected() && this.pathField.getText().length() > 0 || this.inetShortcutRB.isSelected() && this.urlField.getText().length() > 0);
    }

    void enableFields() {
        this.pathField.setEnabled(this.localFileRB.isSelected());
        this.jLabel1.setEnabled(this.localFileRB.isSelected());
        this.browseB.setEnabled(this.localFileRB.isSelected());
        this.projectFileCB.setEnabled(this.localFileRB.isSelected());
        this.urlField.setEnabled(this.inetShortcutRB.isSelected());
        this.jLabel2.setEnabled(this.inetShortcutRB.isSelected());
    }
}

