/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Event;
import net.sf.memoranda.EventNotificationListener;
import net.sf.memoranda.EventsManager;
import net.sf.memoranda.EventsScheduler;
import net.sf.memoranda.History;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.date.DateListener;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.DailyItemsPanel;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.StickerDialog;
import net.sf.memoranda.util.AgendaGenerator;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.Util;

public class AgendaPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JButton historyBackB = new JButton();
    JToolBar toolBar = new JToolBar();
    JButton historyForwardB = new JButton();
    JEditorPane viewer = new JEditorPane("text/html", "");
    JScrollPane scrollPane = new JScrollPane();
    DailyItemsPanel parentPanel = null;
    Collection expandedTasks;
    String gotoTask = null;
    boolean isActive = true;

    public AgendaPanel(DailyItemsPanel dailyItemsPanel) {
        try {
            this.parentPanel = dailyItemsPanel;
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.expandedTasks = new ArrayList();
        this.toolBar.setFloatable(false);
        this.viewer.setEditable(false);
        this.viewer.setOpaque(false);
        this.viewer.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hyperlinkEvent.getDescription();
                    if (string.equalsIgnoreCase("memoranda:events")) {
                        AgendaPanel.this.parentPanel.alarmB_actionPerformed(null);
                    } else if (string.startsWith("memoranda:tasks")) {
                        String string2 = string.split("#")[1];
                        CurrentProject.set(ProjectManager.getProject(string2));
                        AgendaPanel.this.parentPanel.taskB_actionPerformed(null);
                    } else if (string.startsWith("memoranda:project")) {
                        String string3 = string.split("#")[1];
                        CurrentProject.set(ProjectManager.getProject(string3));
                    } else if (string.startsWith("memoranda:removesticker")) {
                        String string4 = string.split("#")[1];
                        EventsManager.removeSticker(string4);
                        CurrentStorage.get().storeEventsManager();
                        AgendaPanel.this.refresh(CurrentDate.get());
                    } else if (string.startsWith("memoranda:addsticker")) {
                        StickerDialog stickerDialog = new StickerDialog(App.getFrame());
                        Dimension dimension = App.getFrame().getSize();
                        stickerDialog.setSize(new Dimension(300, 380));
                        Point point = App.getFrame().getLocation();
                        stickerDialog.setLocation((dimension.width - stickerDialog.getSize().width) / 2 + point.x, (dimension.height - stickerDialog.getSize().height) / 2 + point.y);
                        stickerDialog.setVisible(true);
                        if (!stickerDialog.CANCELLED) {
                            String string5 = stickerDialog.getStickerText();
                            string5 = string5.replaceAll("\\n", "<br>");
                            string5 = "<div style=\"background-color:" + stickerDialog.getStickerColor() + "\">" + string5 + "</div>";
                            EventsManager.createSticker(string5);
                            CurrentStorage.get().storeEventsManager();
                        }
                        AgendaPanel.this.refresh(CurrentDate.get());
                    } else if (string.startsWith("memoranda:expandsubtasks")) {
                        String string6;
                        AgendaPanel.this.gotoTask = string6 = string.split("#")[1];
                        AgendaPanel.this.expandedTasks.add(string6);
                        AgendaPanel.this.refresh(CurrentDate.get());
                    } else if (string.startsWith("memoranda:closesubtasks")) {
                        String string7;
                        AgendaPanel.this.gotoTask = string7 = string.split("#")[1];
                        AgendaPanel.this.expandedTasks.remove(string7);
                        AgendaPanel.this.refresh(CurrentDate.get());
                    }
                }
            }
        });
        this.historyBackB.setAction(History.historyBackAction);
        this.historyBackB.setFocusable(false);
        this.historyBackB.setBorderPainted(false);
        this.historyBackB.setToolTipText(Local.getString("History back"));
        this.historyBackB.setRequestFocusEnabled(false);
        this.historyBackB.setPreferredSize(new Dimension(24, 24));
        this.historyBackB.setMinimumSize(new Dimension(24, 24));
        this.historyBackB.setMaximumSize(new Dimension(24, 24));
        this.historyBackB.setText("");
        this.historyForwardB.setAction(History.historyForwardAction);
        this.historyForwardB.setBorderPainted(false);
        this.historyForwardB.setFocusable(false);
        this.historyForwardB.setPreferredSize(new Dimension(24, 24));
        this.historyForwardB.setRequestFocusEnabled(false);
        this.historyForwardB.setToolTipText(Local.getString("History forward"));
        this.historyForwardB.setMinimumSize(new Dimension(24, 24));
        this.historyForwardB.setMaximumSize(new Dimension(24, 24));
        this.historyForwardB.setText("");
        this.setLayout(this.borderLayout1);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.scrollPane.getViewport().add((Component)this.viewer, null);
        this.add((Component)this.scrollPane, "Center");
        this.toolBar.add((Component)this.historyBackB, null);
        this.toolBar.add((Component)this.historyForwardB, null);
        this.toolBar.addSeparator(new Dimension(8, 24));
        this.add((Component)this.toolBar, "North");
        CurrentDate.addDateListener(new DateListener(){

            public void dateChange(CalendarDate calendarDate) {
                if (AgendaPanel.this.isActive) {
                    AgendaPanel.this.refresh(calendarDate);
                }
            }
        });
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
            }

            public void projectWasChanged() {
                if (AgendaPanel.this.isActive) {
                    AgendaPanel.this.refresh(CurrentDate.get());
                }
            }
        });
        EventsScheduler.addListener(new EventNotificationListener(){

            public void eventIsOccured(Event event) {
                if (AgendaPanel.this.isActive) {
                    AgendaPanel.this.refresh(CurrentDate.get());
                }
            }

            public void eventsChanged() {
                if (AgendaPanel.this.isActive) {
                    AgendaPanel.this.refresh(CurrentDate.get());
                }
            }
        });
        this.refresh(CurrentDate.get());
    }

    public void refresh(CalendarDate calendarDate) {
        this.viewer.setText(AgendaGenerator.getAgenda(calendarDate, this.expandedTasks));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AgendaPanel.this.gotoTask != null) {
                    AgendaPanel.this.viewer.scrollToReference(AgendaPanel.this.gotoTask);
                    AgendaPanel.this.scrollPane.setViewportView(AgendaPanel.this.viewer);
                    Util.debug("Set view port to " + AgendaPanel.this.gotoTask);
                }
            }
        });
        Util.debug("Summary updated.");
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }
}

